/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.drmaa;

import java.util.HashMap;
import java.util.Map;
import org.ggf.drmaa.JobInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobInfoImpl
implements JobInfo {
    private static final int EXITED_BIT = 1;
    private static final int SIGNALED_BIT = 2;
    private static final int COREDUMP_BIT = 4;
    private static final int NEVERRAN_BIT = 8;
    private static final int EXIT_STATUS_BITS = 4080;
    private static final int EXIT_STATUS_OFFSET = 4;
    private final String signal;
    private final int status;
    private final String jobId;
    private final Map<String, String> resources;

    JobInfoImpl(String jobId, int status, String[] resourceUsage, String signal) {
        this.jobId = jobId;
        this.status = status;
        this.resources = JobInfoImpl.nameValuesToMap(resourceUsage);
        this.signal = signal;
    }

    public int getExitStatus() {
        if (!this.hasExited()) {
            throw new IllegalStateException();
        }
        return (this.status & 0xFF0) >> 4;
    }

    public String getTerminatingSignal() {
        if (!this.hasSignaled()) {
            throw new IllegalStateException();
        }
        return this.signal;
    }

    public boolean hasCoreDump() {
        return (this.status & 4) != 0;
    }

    public boolean hasExited() {
        return (this.status & 1) != 0;
    }

    public boolean hasSignaled() {
        return (this.status & 2) != 0;
    }

    public boolean wasAborted() {
        return (this.status & 8) != 0;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Map<String, String> getResourceUsage() {
        return this.resources;
    }

    private static Map<String, String> nameValuesToMap(String[] nameValuePairs) {
        HashMap<String, String> map = null;
        if (nameValuePairs != null) {
            map = new HashMap<String, String>();
            int count = 0;
            while (count < nameValuePairs.length) {
                int equals;
                if (nameValuePairs[count] != null && (equals = nameValuePairs[count].indexOf(61)) >= 0) {
                    map.put(nameValuePairs[count].substring(0, equals), nameValuePairs[count].substring(equals + 1));
                }
                ++count;
            }
        }
        return map;
    }
}

