/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.handler.impl.javaExpr.gui;

import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.gui.HandlerCustomizingEditor;
import agg.attribute.handler.gui.impl.AbstractHandlerEditor;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.parser.javaExpr.ClassResolver;
import agg.attribute.util.RowDragEvent;
import agg.attribute.util.RowDragListener;
import agg.attribute.util.TableRowDragger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class JexHandlerEditor
extends AbstractHandlerEditor
implements HandlerCustomizingEditor,
ScrollPaneConstants,
ListSelectionListener,
RowDragListener {
    protected JexHandler handler;
    protected ClassResolver classResolver;
    protected Vector<String> packages;
    protected PackageTableModel tableModel;
    protected JPanel mainPanel;
    protected JPanel packageP;
    protected JPanel buttonP;
    protected JPanel entriesP;
    protected JPanel inputP;
    protected JTable entriesL;
    protected JTextField inputTF;
    protected Action insertAction;
    protected Action appendAction;
    protected Action deleteAction;

    public JexHandlerEditor(AttrHandler h) {
        this.handler = (JexHandler)h;
        this.classResolver = this.handler.getClassResolver();
        this.tableModel = new PackageTableModel();
        this.entriesL = new JTable(this.tableModel);
        this.entriesL.setSelectionMode(0);
        this.entriesL.setRowSelectionAllowed(true);
        this.entriesL.setColumnSelectionAllowed(false);
        this.entriesL.getSelectionModel().addListSelectionListener(this);
        this.entriesL.setPreferredScrollableViewportSize(new Dimension(200, 100));
        TableRowDragger rowDragger = new TableRowDragger(this.entriesL);
        rowDragger.addRowDragListener(this);
        JScrollPane listScrollPane = new JScrollPane(this.entriesL);
        listScrollPane.setPreferredSize(new Dimension(200, 100));
        this.entriesP = new JPanel();
        this.entriesP.setLayout(new BorderLayout());
        this.entriesP.add((Component)listScrollPane, "Center");
        this.entriesP.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "Searched Packages", 2, 2));
        this.entriesP.setPreferredSize(new Dimension(200, 100));
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.insertAction = new AbstractAction("Insert"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int sel = JexHandlerEditor.this.entriesL.getSelectedRow();
                if (sel == -1) {
                    sel = 0;
                }
                JexHandlerEditor.this.packages.insertElementAt("", sel);
                JexHandlerEditor.this.tableModel.update();
                JexHandlerEditor.this.entriesL.editCellAt(sel, 0);
            }
        };
        toolBar.add(this.insertAction);
        toolBar.addSeparator();
        this.appendAction = new AbstractAction("Append"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int sel = JexHandlerEditor.this.entriesL.getSelectedRow();
                if (sel == -1) {
                    sel = JexHandlerEditor.this.packages.size() - 1;
                }
                JexHandlerEditor.this.appendPackageAt("", sel);
                JexHandlerEditor.this.tableModel.update();
                JexHandlerEditor.this.entriesL.editCellAt(sel + 1, 0);
            }
        };
        toolBar.add(this.appendAction);
        toolBar.addSeparator();
        this.deleteAction = new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int sel = JexHandlerEditor.this.entriesL.getSelectedRow();
                if (sel != -1) {
                    JexHandlerEditor.this.packages.removeElementAt(sel);
                    JexHandlerEditor.this.tableModel.update();
                    JexHandlerEditor.this.updateResolver();
                }
            }
        };
        toolBar.add(this.deleteAction);
        JPanel toolPanel = new JPanel();
        toolPanel.add(toolBar);
        this.packageP = new JPanel();
        this.packageP.setLayout(new BorderLayout());
        this.packageP.add((Component)this.entriesP, "Center");
        this.packageP.add((Component)toolPanel, "South");
        this.packageP.setPreferredSize(new Dimension(200, 200));
        this.mainPanel = this.packageP;
        this.mainPanel.setPreferredSize(new Dimension(200, 200));
        this.updateList();
    }

    protected void appendPackageAt(String p, int pos) {
        if (pos == this.packages.size() - 1) {
            this.packages.addElement(p);
        } else {
            this.packages.insertElementAt(p, pos + 1);
        }
    }

    @Override
    public void draggingStarted(RowDragEvent ev) {
        ev.getSourceRow();
    }

    @Override
    public void draggingStopped(RowDragEvent ev) {
        ev.getSourceRow();
        this.updateResolver();
    }

    @Override
    public void draggingMoved(RowDragEvent ev) {
        int src = ev.getSourceRow();
        int dest = ev.getTargetRow();
        if (dest == -1 || src == -1) {
            return;
        }
        if (dest == src) {
            return;
        }
        String p = this.packages.elementAt(src);
        if (src < dest) {
            this.appendPackageAt(p, dest);
            this.packages.removeElementAt(src);
        } else {
            this.packages.insertElementAt(p, dest);
            this.packages.removeElementAt(src + 1);
        }
        this.tableModel.update();
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        int row = ev.getFirstIndex();
        this.deleteAction.setEnabled(row != -1);
    }

    @Override
    public Component getComponent() {
        return this.mainPanel;
    }

    @Override
    public AttrHandler getAttrHandler() {
        return this.handler;
    }

    @Override
    public void setAttrHandler(AttrHandler h) {
        this.handler = (JexHandler)h;
        this.classResolver = this.handler.getClassResolver();
        this.packages = this.classResolver.getPackages();
        this.updateList();
    }

    protected void updateList() {
        this.packages = this.classResolver.getPackages();
        this.tableModel.update();
    }

    protected void updateResolver() {
        this.classResolver.setPackages(this.packages);
    }

    class PackageTableModel
    extends AbstractTableModel {
        PackageTableModel() {
        }

        @Override
        public int getRowCount() {
            if (JexHandlerEditor.this.packages == null) {
                JexHandlerEditor.this.updateList();
            }
            return JexHandlerEditor.this.packages.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return "".getClass();
        }

        @Override
        public String getColumnName(int column) {
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return JexHandlerEditor.this.packages.elementAt(row);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            String text = (String)value;
            if (text == null || text.trim().length() == 0) {
                JexHandlerEditor.this.packages.removeElementAt(row);
                this.update();
            } else {
                JexHandlerEditor.this.packages.setElementAt(text, row);
            }
            JexHandlerEditor.this.updateResolver();
        }

        public void update() {
            this.fireTableDataChanged();
        }
    }
}

