/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.view.impl;

import agg.attribute.AttrEvent;
import agg.attribute.AttrObserver;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ManagedObject;
import agg.attribute.impl.TupleObject;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.TupleFormat;
import agg.attribute.view.impl.TupleViewEvent;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ViewSetting
extends ManagedObject
implements AttrViewSetting {
    static final long serialVersionUID = -582744399860233794L;
    protected transient Hashtable<AttrTuple, Vector<WeakReference<AttrViewObserver>>> observerTab = new Hashtable();
    Object obsvs;

    public ViewSetting(AttrTupleManager m) {
        super(m);
    }

    @Override
    public void dispose() {
    }

    public void finalize() {
    }

    protected abstract TupleFormat getFormat(AttrTuple var1);

    protected abstract void removeFormat(AttrType var1);

    protected Vector<WeakReference<AttrViewObserver>> getObserversForTuple(AttrTuple attr) {
        if (this.observerTab == null) {
            this.observerTab = new Hashtable();
        }
        return this.observerTab.get(attr);
    }

    protected void addObserverForTuple(AttrViewObserver o, AttrTuple attr) {
        Vector<WeakReference<AttrViewObserver>> observers = this.getObserversForTuple(attr);
        if (observers == null) {
            observers = new Vector(4);
            this.observerTab.put(attr, observers);
            observers.add(new WeakReference<AttrViewObserver>(o));
        } else if (this.find(observers, o) == null) {
            observers.add(new WeakReference<AttrViewObserver>(o));
        }
    }

    protected void removeObserverForTuple(AttrViewObserver o, AttrTuple attr) {
        Vector<WeakReference<AttrViewObserver>> observers = this.getObserversForTuple(attr);
        if (observers == null) {
            return;
        }
        this.removeElement(observers, o);
    }

    private WeakReference<?> find(Vector<WeakReference<AttrViewObserver>> observers, AttrViewObserver o) {
        int i = 0;
        while (i < observers.size()) {
            WeakReference<AttrViewObserver> wr = observers.get(i);
            if (wr.get() == null) {
                observers.remove(i);
                --i;
            } else if (o == wr.get()) {
                return wr;
            }
            ++i;
        }
        return null;
    }

    private void removeElement(Vector<WeakReference<AttrViewObserver>> observers, AttrViewObserver o) {
        int i = 0;
        while (i < observers.size()) {
            WeakReference<AttrViewObserver> wr = observers.get(i);
            if (wr.get() == null) {
                observers.remove(i);
                --i;
            } else if (o == wr.get()) {
                observers.remove(i);
                return;
            }
            ++i;
        }
    }

    boolean contains(Vector<WeakReference<AttrViewObserver>> observers, AttrViewObserver o) {
        return this.find(observers, o) != null;
    }

    protected void notifyObservers(AttrTuple attr, int id, int slot0, int slot1) {
        Vector<WeakReference<AttrViewObserver>> observers;
        this.obsvs = observers = this.getObserversForTuple(attr);
        if (observers == null) {
            return;
        }
        TupleViewEvent evt = new TupleViewEvent(attr, id, slot0, slot1, this);
        Enumeration<WeakReference<AttrViewObserver>> en = observers.elements();
        while (en.hasMoreElements()) {
            WeakReference<AttrViewObserver> wr = en.nextElement();
            AttrViewObserver obs = (AttrViewObserver)wr.get();
            if (obs == null) {
                observers.removeElement(wr);
                continue;
            }
            obs.attributeChanged(evt);
        }
    }

    protected void fireAttrChanged(TupleObject attr, int id, int slot0, int slot1) {
        this.notifyObservers(attr, id, slot0, slot1);
        if (this.obsvs == null) {
            return;
        }
        Enumeration<AttrObserver> objEnum = attr.getObservers();
        while (objEnum.hasMoreElements()) {
            AttrObserver obj = objEnum.nextElement();
            if (!(obj instanceof AttrTuple)) continue;
            this.fireAttrChanged((TupleObject)obj, id, slot0, slot1);
        }
    }

    protected void propagateAttrEvent(AttrEvent event) {
        AttrTuple attr = event.getSource();
        if (attr == null) {
            return;
        }
        int id = event.getID();
        int index0 = event.getIndex0();
        int index1 = event.getIndex1();
        if (id == 0) {
            this.notifyObservers(attr, id, index0, index1);
        } else {
            int slot0 = this.convertIndexToSlot(attr, event.getIndex0());
            int slot1 = this.convertIndexToSlot(attr, event.getIndex1());
            this.notifyObservers(attr, id, slot0, slot1);
        }
    }

    @Override
    public void moveSlotAppending(AttrTuple attr, int srcSlot, int destSlot) {
        this.moveSlotInserting(attr, srcSlot, destSlot + 1);
    }

    public String toString(AttrTuple attr) {
        return this.getFormat(attr).toString();
    }
}

