/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.DrawLine;
import agg.gui.editor.EditorConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class Line {
    public static final int MOVE_ANCHOR_SIZE = 20;
    public static final int MOVE_ANCHOR_SIZE_W = 30;
    public static final int MOVE_ANCHOR_SIZE_W_2 = 15;
    public static final int MOVE_ANCHOR_OFFSET = 10;
    public static final Color MOVE_ANCHOR_COLOR = new Color(0, 200, 0);
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public int xh;
    public int yh;
    private Point anchor;
    private Color col = new Color(0, 0, 0);

    public Line(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.xh = x1 - (x1 - x2) / 2;
        this.yh = y2 + (y1 - y2) / 2;
        this.anchor = new Point(this.xh, this.yh);
    }

    public void setAnchor(Point newAnchor) {
        this.anchor = newAnchor;
    }

    public void setColor(Color newColor) {
        this.col = newColor;
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void drawSolidLine(Graphics g) {
        this.drawLine(g);
    }

    public void drawColorSolidLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setPaint(this.col);
        new DrawLine(g, 0, this.x1, this.y1, anch.x, anch.y);
        new DrawLine(g, 0, anch.x, anch.y, this.x2, this.y2);
    }

    public void drawColorDotLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setPaint(this.col);
        new DrawLine(g, 2, this.x1, this.y1, anch.x, anch.y);
        new DrawLine(g, 2, anch.x, anch.y, this.x2, this.y2);
    }

    public void drawColorDashLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setPaint(this.col);
        new DrawLine(g, 1, this.x1, this.y1, anch.x, anch.y);
        new DrawLine(g, 1, anch.x, anch.y, this.x2, this.y2);
    }

    public void drawColorDotLine(Graphics grs, int dots, int space) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        if (this.x1 == this.x2) {
            this.drawColorVDotLine(g, dots, space);
        } else if (this.y1 == this.y2) {
            this.drawColorHDotLine(g, dots, space);
        } else {
            g.setPaint(this.col);
            new DrawLine(g, 2, this.x1, this.y1, anch.x, anch.y);
            new DrawLine(g, 2, anch.x, anch.y, this.x2, this.y2);
        }
    }

    public void drawColorDashLine(Graphics grs, int dots, int space) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        if (this.x1 == this.x2) {
            this.drawColorVDotLine(g, dots, space);
        } else if (this.y1 == this.y2) {
            this.drawColorHDotLine(g, dots, space);
        } else {
            g.setPaint(this.col);
            new DrawLine(g, 1, this.x1, this.y1, anch.x, anch.y);
            new DrawLine(g, 1, anch.x, anch.y, this.x2, this.y2);
        }
    }

    public void drawDotLine(Graphics grs, int dots, int space) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        if (this.x1 == this.x2) {
            this.drawVDotLine(g, dots, space);
        } else if (this.y1 == this.y2) {
            this.drawHDotLine(g, dots, space);
        } else {
            int y;
            int j;
            int anf = this.x1;
            int end = this.x2;
            if (this.x2 < this.x1) {
                anf = this.x2;
                end = this.x1;
            }
            int a = (this.y1 - this.y2) / (this.x1 - this.x2);
            int b = this.y1 - this.x1 * (this.y1 - this.y2) / (this.x1 - this.x2);
            g.setPaint(Color.black);
            int i = anf;
            while (i < anch.x) {
                j = 0;
                while (j < dots) {
                    y = a * (i + j) + b;
                    g.drawLine(i + j, y, i + j, y);
                    ++j;
                }
                i += dots + space;
            }
            i = anch.x;
            while (i < end) {
                j = 0;
                while (j < dots) {
                    y = a * (i + j) + b;
                    g.drawLine(i + j, y, i + j, y);
                    ++j;
                }
                i += dots + space;
            }
        }
    }

    protected void drawWeakselectedLine(Graphics g) {
        g.setColor(EditorConstants.weakselectColor);
        new DrawLine(g, 0, this.x1 - 1, this.y1 - 1, this.anchor.x - 1, this.anchor.y - 1);
        new DrawLine(g, 0, this.anchor.x - 1, this.anchor.y - 1, this.x2 - 1, this.y2 - 1);
        new DrawLine(g, 0, this.x1 - 2, this.y1 - 2, this.anchor.x - 2, this.anchor.y - 2);
        new DrawLine(g, 0, this.anchor.x - 2, this.anchor.y - 2, this.x2 - 2, this.y2 - 2);
    }

    public void drawMoveAnchor(Graphics grs) {
        if (this.anchor == null) {
            return;
        }
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(MOVE_ANCHOR_COLOR);
        g.fill(new Rectangle(this.anchor.x - 10, this.anchor.y - 10, 20, 20));
        g.setPaint(lastColor);
    }

    private Point myAnchor() {
        if (this.anchor == null) {
            return new Point(this.xh, this.yh);
        }
        return this.anchor;
    }

    private void drawLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        g.setColor(Color.black);
        g.setPaint(Color.black);
        g.drawLine(this.x1, this.y1, anch.x, anch.y);
        g.drawLine(anch.x, anch.y, this.x2, this.y2);
    }

    private void drawHDotLine(Graphics grs, int dots, int space) {
        int j;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.x1;
        int end = this.x2;
        if (this.x2 < this.x1) {
            anf = this.x2;
            end = this.x1;
        }
        g.setColor(Color.black);
        g.setPaint(Color.black);
        int i = anf;
        while (i < anch.x) {
            j = 0;
            while (j < dots) {
                g.drawLine(i + j, this.y1, i + j, this.y2);
                ++j;
            }
            i = i + dots + space;
        }
        i = anch.x;
        while (i < end) {
            j = 0;
            while (j < dots) {
                g.drawLine(i + j, this.y1, i + j, this.y2);
                ++j;
            }
            i += dots + space;
        }
    }

    private void drawVDotLine(Graphics grs, int dots, int space) {
        int j;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.y1;
        int end = this.y2;
        if (this.y2 < this.y1) {
            anf = this.y2;
            end = this.y1;
        }
        g.setColor(Color.black);
        g.setPaint(Color.black);
        int i = anf;
        while (i < anch.y) {
            j = 0;
            while (j < dots) {
                g.drawLine(this.x1, i + j, this.x2, i + j);
                ++j;
            }
            i += dots + space;
        }
        i = anch.y;
        while (i < end) {
            j = 0;
            while (j < dots) {
                g.drawLine(this.x1, i + j, this.x2, i + j);
                ++j;
            }
            i += dots + space;
        }
    }

    private void drawColorHDotLine(Graphics grs, int dots, int space) {
        int j;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.x1;
        int end = this.x2;
        if (this.x2 < this.x1) {
            anf = this.x2;
            end = this.x1;
        }
        g.setColor(this.col);
        g.setPaint(this.col);
        int i = anf;
        while (i < anch.x) {
            j = 0;
            while (j < dots) {
                g.drawLine(i + j, this.y1, i + j, this.y1);
                ++j;
            }
            i += dots + space;
        }
        i = anch.x;
        while (i < end) {
            j = 0;
            while (j < dots) {
                g.drawLine(i + j, this.y1, i + j, this.y1);
                ++j;
            }
            i += dots + space;
        }
    }

    private void drawColorVDotLine(Graphics grs, int dots, int space) {
        int j;
        Graphics2D g = (Graphics2D)grs;
        Point anch = this.myAnchor();
        int anf = this.y1;
        int end = this.y2;
        if (this.y2 < this.y1) {
            anf = this.y2;
            end = this.y1;
        }
        g.setColor(this.col);
        g.setPaint(this.col);
        int i = anf;
        while (i < anch.y) {
            j = 0;
            while (j < dots) {
                g.drawLine(this.x1, i + j, this.x1, i + j);
                ++j;
            }
            i += dots + space;
        }
        i = anch.y;
        while (i < end) {
            j = 0;
            while (j < dots) {
                g.drawLine(this.x1, i + j, this.x1, i + j);
                ++j;
            }
            i += dots + space;
        }
    }

    public static boolean inside(int X, int Y, Point p1, Point p2, int size) {
        Rectangle r = null;
        int xh_2 = (p2.x - p1.x) / 2;
        int xt_2 = p1.x + xh_2;
        int yh_2 = (p2.y - p1.y) / 2;
        int yt_2 = p1.y + yh_2;
        r = new Rectangle(xt_2 - size / 2, yt_2 - size / 2, size, size);
        if (r.contains(X, Y)) {
            return true;
        }
        if (xh_2 > size && yh_2 > size / 2) {
            if (Line.inside(X, Y, p1, new Point(xt_2, yt_2), size)) {
                return true;
            }
            if (Line.inside(X, Y, new Point(xt_2, yt_2), p2, size)) {
                return true;
            }
        }
        return false;
    }

    public static boolean inside(int X, int Y, int x0, int y0, int w, int h) {
        Rectangle r;
        if (w > 0 && h > 0 && (r = new Rectangle(x0, y0, w, h)).contains(X, Y)) {
            return true;
        }
        if (w < 0 && h < 0 && (r = new Rectangle(x0 + w, y0 + h, -w, -h)).contains(X, Y)) {
            return true;
        }
        if (w > 0 && h < 0 && (r = new Rectangle(x0, y0 + h, w, -h)).contains(X, Y)) {
            return true;
        }
        if (w < 0 && h > 0 && (r = new Rectangle(x0 + w, y0, -w, h)).contains(X, Y)) {
            return true;
        }
        if (w == 0 && h > 0 && (r = new Rectangle(x0 - 5, y0, 10, h)).contains(X, Y)) {
            return true;
        }
        if (w == 0 && h < 0 && (r = new Rectangle(x0 - 5, y0 + h, 10, -h)).contains(X, Y)) {
            return true;
        }
        if (w > 0 && h == 0 && (r = new Rectangle(x0, y0 - 5, w, 10)).contains(X, Y)) {
            return true;
        }
        return w < 0 && h == 0 && (r = new Rectangle(x0 + w, y0 - 5, -w, 10)).contains(X, Y);
    }

    public static boolean insideLFunct(int X, int Y, double x1, double y1, double x2, double y2) {
        double resY;
        if ((int)(x2 - x1) != 0 && ((int)(resY = (y2 - y1) / (x2 - x1) * ((double)X - x1) + y1) == Y || Math.abs((int)resY - Y) <= 5)) {
            return true;
        }
        if (y2 > y1 && (double)Y > y1 && (double)Y < y2) {
            return true;
        }
        return y1 > y2 && (double)Y > y2 && (double)Y < y1;
    }
}

