/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.attribute.AttrInstance;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.ValueMember;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdMorphism;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.gui.AGGAppl;
import agg.gui.IconResource;
import agg.gui.cpa.CriticalPairPanel;
import agg.gui.cpa.VariableEqualityDialog;
import agg.gui.editor.GraphCanvas;
import agg.gui.editor.GraphEditor;
import agg.gui.editor.GraphPanel;
import agg.gui.editor.RuleEditor;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.gui.options.ParserGUIOption;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.parser.CriticalPairData;
import agg.parser.PairContainer;
import agg.parser.Report;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeError;
import agg.xt_basis.agt.RuleScheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.TreePath;

public class GraphDesktop
implements InternalFrameListener {
    int dx = 0;
    int dy = 0;
    protected final JFrame parentFrame;
    protected JDesktopPane desktop;
    protected JScrollPane jsp;
    protected ImageIcon internalFrameIcon;
    protected int nextX;
    protected int nextY;
    protected EdGraGra layout;
    protected Hashtable<Graph, Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlappings;
    protected Hashtable<Graph, EdGraph> internalLayoutGraphs;
    protected Hashtable<Graph, JInternalFrame> internalGraphFrames;
    protected Dimension internalFrameSize;
    protected ParserGUIOption option;
    protected Vector<ParserGUIListener> listener;
    protected JInternalFrame cpaGraphFrame;
    protected JInternalFrame conflictFrame;
    protected JInternalFrame dependFrame;
    protected JInternalFrame activeGraphFrame;
    protected final MouseListener ml;
    protected final JPopupMenu graphMenu = new JPopupMenu("Graph");
    protected final JMenu miShapeC = new JMenu();
    protected final JMenu miShapeD = new JMenu();
    protected final JPopupMenu cpaGraphMenu = new JPopupMenu("CPA Graph");
    protected final JMenuItem miC = new JMenuItem("Show Conflicts");
    protected final JMenuItem miD = new JMenuItem("Show Dependencies");
    protected final JMenuItem miAll = new JMenuItem("Show All");
    protected final JMenuItem miRefresh = new JMenuItem("Refresh");
    protected final JMenuItem miStraightEdges = new JMenuItem("Straight Edges");
    protected final JMenuItem miHide = new JMenuItem("Hide Node/Edge");
    protected final JMenuItem miLayoutGraph = new JMenuItem("Layout Graph");
    protected final JMenuItem miGraphExportJPG = new JMenuItem("Export JPEG");
    protected final JMenuItem miExportJPG_graphMenu = new JMenuItem("Export JPEG");
    protected final JMenuItem miAddToGraphs_graphMenu = new JMenuItem("Add To Host Graphs");
    protected final JMenu miAddToNACs_graphMenu = new JMenu("Add To NACs");
    protected final JMenuItem miLayout_graphMenu = new JMenuItem("Layout Graph");
    protected final JMenuItem miVarEqual_graphMenu = new JMenuItem("Variable Equalities");
    final JMenu confsMenu = new JMenu(" Show ");
    final JMenu depsMenu = new JMenu(" Show ");
    protected JMenuItem miFirstRule;
    protected JMenuItem miSecondRule;
    protected JMenuItem miAllConfs;
    protected JMenuItem miAllDeps;
    protected CriticalPairPanel conflictPanel;
    protected CriticalPairPanel dependPanel;
    protected int myW;
    protected int myH;
    protected RuleEditor ruleEdit1;
    protected RuleEditor ruleEdit2;
    protected JInternalFrame ruleFrame1;
    protected JInternalFrame ruleFrame2;
    protected EdRule layoutRule1;
    protected EdRule layoutRule2;
    protected GraphPanel activeGraphPanel;
    protected GraphicsExportJPEG exportJPEG;
    protected final Hashtable<EdGraph, VariableEqualityDialog> varEqualityDialogs;
    protected Point locationOnScreen;

    public GraphDesktop(JFrame parFrame, EdGraGra layout, ParserGUIOption option) {
        this.setLayout(layout);
        this.parentFrame = parFrame;
        this.listener = new Vector();
        this.overlappings = new Hashtable();
        this.internalGraphFrames = new Hashtable();
        this.internalLayoutGraphs = new Hashtable();
        this.varEqualityDialogs = new Hashtable();
        this.desktop = new JDesktopPane();
        this.myW = 500;
        this.myH = 500;
        this.desktop.setPreferredSize(new Dimension(this.myW, this.myH));
        this.jsp = new JScrollPane(22, 32);
        this.jsp.setViewportView(this.desktop);
        this.jsp.setBackground(Color.white);
        this.jsp.getHorizontalScrollBar().getModel().setValueIsAdjusting(true);
        this.jsp.getVerticalScrollBar().getModel().setValueIsAdjusting(true);
        this.internalFrameIcon = IconResource.getIconFromURL(IconResource.getURLOverlapGraph());
        this.internalFrameSize = new Dimension(200, 200);
        this.option = option;
        this.nextX = 5;
        this.nextY = 5;
        this.makeGraphMenu();
        this.makeCPAGraphMenu();
        this.ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GraphDesktop.this.showGraphMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GraphDesktop.this.showGraphMenu(e);
            }
        };
    }

    void showGraphMenu(MouseEvent e) {
        if (e.isPopupTrigger() && e.getSource() instanceof JPanel) {
            if (e.getSource() instanceof GraphCanvas) {
                this.activeGraphPanel = ((GraphCanvas)e.getSource()).getViewport();
            }
            if (this.cpaGraphFrame != null && this.cpaGraphFrame.isVisible() && this.activeGraphFrame == this.cpaGraphFrame) {
                this.cpaGraphMenu.show(e.getComponent(), e.getX(), e.getY());
                this.setPickedGraphObjectOfCPAgraph(e.getX(), e.getY());
            } else if (this.ruleEdit1 != null && (this.activeGraphPanel == this.ruleEdit1.getLeftPanel() || this.activeGraphPanel == this.ruleEdit1.getRightPanel())) {
                this.miAddToGraphs_graphMenu.setEnabled(false);
                this.miAddToNACs_graphMenu.setEnabled(false);
                if (this.activeGraphPanel.getGraph().getPicked(e.getX(), e.getY()) == null) {
                    this.graphMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            } else if (this.ruleEdit2 != null && (this.activeGraphPanel == this.ruleEdit2.getLeftPanel() || this.activeGraphPanel == this.ruleEdit2.getRightPanel() || this.activeGraphPanel == this.ruleEdit2.getLeftCondPanel())) {
                this.miAddToGraphs_graphMenu.setEnabled(false);
                this.miAddToNACs_graphMenu.setEnabled(false);
                if (this.activeGraphPanel.getGraph().getPicked(e.getX(), e.getY()) == null) {
                    this.graphMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            } else if (!this.activeGraphPanel.getGraph().isCPAgraph()) {
                this.miAddToGraphs_graphMenu.setEnabled(true);
                this.miAddToNACs_graphMenu.setEnabled(true);
                this.miFirstRule.setText("Of First  Rule: " + this.ruleEdit1.getRule().getName());
                this.miSecondRule.setText("Of Second Rule: " + this.ruleEdit2.getRule().getName());
                if (this.activeGraphPanel.getGraph().getPicked(e.getX(), e.getY()) == null) {
                    this.locationOnScreen = new Point(this.parentFrame.getLocation().x + this.desktop.getLocation().x + this.activeGraphPanel.getLocation().x + e.getX(), this.parentFrame.getLocation().y + this.desktop.getLocation().y + this.activeGraphPanel.getLocation().y + e.getY());
                    this.graphMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    protected void showVarEqualityDialog(EdGraph graph, Point location) {
        if (this.varEqualityDialogs.get(graph) != null) {
            this.varEqualityDialogs.get(graph).setVisible(true);
        } else if (!graph.getBasisGraph().getHelpInfoAboutVariableEquality().equals("")) {
            this.varEqualityDialogs.put(graph, new VariableEqualityDialog(graph, location));
        }
    }

    private void createRuleEditor1() {
        this.ruleEdit1 = new RuleEditor(null);
        this.ruleEdit1.setRuleDividerLocation(150);
        this.ruleEdit1.getLeftPanel().getCanvas().addMouseListener(this.ml);
        this.ruleEdit1.getRightPanel().getCanvas().addMouseListener(this.ml);
        this.ruleEdit1.getNACPanel().getCanvas().addMouseListener(this.ml);
        if (this.exportJPEG != null) {
            this.ruleEdit1.setExportJPEG(this.exportJPEG);
        }
    }

    private void createRuleEditor2() {
        this.ruleEdit2 = new RuleEditor(null);
        this.ruleEdit2.setRuleDividerLocation(150);
        this.ruleEdit2.getLeftPanel().getCanvas().addMouseListener(this.ml);
        this.ruleEdit2.getRightPanel().getCanvas().addMouseListener(this.ml);
        this.ruleEdit2.getNACPanel().getCanvas().addMouseListener(this.ml);
        if (this.exportJPEG != null) {
            this.ruleEdit2.setExportJPEG(this.exportJPEG);
        }
    }

    protected Object setPickedGraphObjectOfCPAgraph(int x, int y) {
        if (this.cpaGraphFrame == null) {
            return null;
        }
        Component c = this.cpaGraphFrame.getContentPane().getComponent(0);
        if (c instanceof GraphEditor) {
            return ((GraphEditor)c).getGraph().getPicked(x, y);
        }
        return null;
    }

    public void setLayout(EdGraGra layout) {
        this.layout = layout;
        this.nextX = 5;
        this.nextY = 5;
    }

    public void setGUIOption(ParserGUIOption option) {
        this.option = option;
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        if (this.ruleEdit1 != null && this.ruleEdit2 != null) {
            this.ruleEdit1.setExportJPEG(this.exportJPEG);
            this.ruleEdit2.setExportJPEG(this.exportJPEG);
        }
    }

    public JInternalFrame addCriticalPairTable(CriticalPairPanel cppanel, String tableName) {
        boolean newFrame = false;
        String name = "Critical Pairs";
        if (!tableName.equals("")) {
            name = tableName;
        }
        JInternalFrame cpIFrame = null;
        if (cppanel.getPairContainer().getKindOfConflict() == 0) {
            if (this.conflictFrame == null) {
                this.conflictFrame = cpIFrame = new JInternalFrame(name, true, true, true, true);
                this.setMenuBarOfConflictTableFrame(this.confsMenu);
                this.conflictPanel = cppanel;
                newFrame = true;
                this.nextX = 0;
                this.nextY = this.dependFrame == null ? 50 : 100;
            } else {
                cpIFrame = this.conflictFrame;
            }
        } else if (cppanel.getPairContainer().getKindOfConflict() == 1 || cppanel.getPairContainer().getKindOfConflict() == 2) {
            if (this.dependFrame == null) {
                this.dependFrame = cpIFrame = new JInternalFrame(name, true, true, true, true);
                this.setMenuBarOfDependencyTableFrame(this.depsMenu);
                this.dependPanel = cppanel;
                newFrame = true;
                this.nextX = 50;
                this.nextY = this.conflictFrame == null ? 50 : 100;
            } else {
                cpIFrame = this.dependFrame;
            }
        }
        if (cpIFrame != null) {
            if (newFrame) {
                cpIFrame.addInternalFrameListener(this);
                int fw = cppanel.getTableWidth() + 110;
                int fh = cppanel.getTableHeight() + 80;
                if (fw > 600) {
                    fw = 600;
                }
                if (fh > 400) {
                    fh = 400;
                }
                cpIFrame.setSize(new Dimension(fw, fh));
                cpIFrame.setFrameIcon(this.internalFrameIcon);
                cpIFrame.getContentPane().add(cppanel);
                cpIFrame.setLocation(this.nextX, this.nextY);
                this.desktop.add(cpIFrame);
                cpIFrame.setVisible(true);
                try {
                    cpIFrame.setIcon(false);
                    cpIFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (!cpIFrame.isVisible()) {
                this.desktop.add(cpIFrame);
                cpIFrame.setVisible(true);
                try {
                    cpIFrame.setIcon(false);
                    cpIFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    if (cpIFrame.isIcon()) {
                        cpIFrame.setIcon(false);
                    }
                    cpIFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        return cpIFrame;
    }

    public JInternalFrame addGraph(Graph g) {
        if (this.option == null || this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        GraphEditor gege = null;
        JInternalFrame newGraph = new JInternalFrame(g.getName(), true, false, true, true);
        this.internalGraphFrames.put(g, newGraph);
        newGraph.addInternalFrameListener(this);
        newGraph.setSize(this.internalFrameSize);
        newGraph.setFrameIcon(this.internalFrameIcon);
        EdGraph eg = new EdGraph(g, this.layout.getTypeSet());
        this.internalLayoutGraphs.put(g, eg);
        eg.setEditable(false);
        eg.setDrawingStyleOfCriticalObjects(this.option.getDrawingStyleOfCriticalObjects());
        gege = new GraphEditor();
        gege.setGraph(eg);
        eg.makeInitialUpdateOfNodes();
        eg.doDefaultEvolutionaryGraphLayout(10);
        gege.setExportJPEG(this.exportJPEG);
        gege.getGraphPanel().getCanvas().addMouseListener(this.ml);
        gege.setEditMode(13);
        gege.setTitle("    ");
        newGraph.getContentPane().add(gege);
        this.desktop.add(newGraph);
        try {
            newGraph.setIcon(true);
            newGraph.setSelected(false);
            newGraph.setVisible(true);
            newGraph.getDesktopIcon().setLocation(this.nextX, this.nextY);
            if (this.nextX + newGraph.getDesktopIcon().getSize().width >= this.desktop.getSize().width) {
                int h = this.desktop.getSize().height;
                this.nextX = 5;
                this.nextY += newGraph.getDesktopIcon().getSize().height;
                if (this.nextY + newGraph.getDesktopIcon().getSize().height >= h) {
                    h = this.nextY + newGraph.getDesktopIcon().getSize().height;
                    this.desktop.setPreferredSize(new Dimension(this.myW, h));
                }
            }
            this.nextX += newGraph.getDesktopIcon().getSize().width;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return newGraph;
    }

    public JInternalFrame addGraph(EdGraph eg, int w1, int h1) {
        if (eg == null || this.option == null || this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        boolean newFrame = true;
        GraphEditor gege = null;
        eg.setEditable(false);
        eg.setDrawingStyleOfCriticalObjects(this.option.getDrawingStyleOfCriticalObjects());
        JInternalFrame graphFrame = this.internalGraphFrames.get(eg.getBasisGraph());
        if (graphFrame == null) {
            graphFrame = new JInternalFrame(eg.getBasisGraph().getName(), true, true, true, true);
            this.internalGraphFrames.put(eg.getBasisGraph(), graphFrame);
            this.internalLayoutGraphs.put(eg.getBasisGraph(), eg);
            graphFrame.addInternalFrameListener(this);
            graphFrame.setSize(new Dimension(w1, h1));
            graphFrame.setFrameIcon(this.internalFrameIcon);
            if (!eg.isCPAgraph()) {
                eg.updateGraph();
            }
            gege = new GraphEditor();
            gege.setExportJPEG(this.exportJPEG);
            graphFrame.getContentPane().add(gege);
            if (eg.isCPAgraph()) {
                if (!eg.getBasisGraph().isEmpty()) {
                    int fw = eg.getGraphDimension().width;
                    int fh = eg.getGraphDimension().height;
                    if (fw > 600) {
                        fw = 600;
                    } else if (fw < 400) {
                        fw = 400;
                    }
                    if (fh > 400) {
                        fh = 400;
                    } else if (fh < 300) {
                        fh = 300;
                    }
                    graphFrame.setSize(new Dimension(fw, fh));
                } else {
                    graphFrame.setSize(new Dimension(300, 200));
                }
                this.cpaGraphFrame = graphFrame;
                this.cpaGraphFrame.addMouseListener(this.ml);
            }
            gege.getGraphPanel().getCanvas().addMouseListener(this.ml);
        } else {
            newFrame = false;
            if (eg.isCPAgraph()) {
                Component c = graphFrame.getContentPane().getComponent(0);
                if (c instanceof GraphEditor) {
                    gege = (GraphEditor)c;
                    gege.setExportJPEG(this.exportJPEG);
                }
                if (!eg.getBasisGraph().isEmpty()) {
                    int fw = eg.getGraphDimension().width;
                    int fh = eg.getGraphDimension().height;
                    if (fw > 600) {
                        fw = 600;
                    } else if (fw < 400) {
                        fw = 400;
                    }
                    if (fh > 400) {
                        fh = 400;
                    } else if (fh < 300) {
                        fh = 300;
                    }
                    graphFrame.setSize(new Dimension(fw, fh));
                } else {
                    graphFrame.setSize(new Dimension(300, 200));
                }
                try {
                    graphFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        if (gege != null) {
            gege.setGraph(eg);
            gege.setEditMode(13);
            gege.setTitle("    ");
        }
        this.desktop.add(graphFrame);
        try {
            if (!eg.isCPAgraph()) {
                graphFrame.setIcon(true);
                graphFrame.setSelected(false);
            }
            graphFrame.setVisible(true);
        }
        catch (PropertyVetoException pve) {
            System.out.println("GraphDesktop.addGraph:: java.beans.PropertyVetoException:  " + pve.getMessage());
        }
        if (newFrame) {
            graphFrame.getDesktopIcon().setLocation(this.nextX, this.nextY);
            this.nextX += graphFrame.getDesktopIcon().getSize().width;
            if (this.nextX + graphFrame.getDesktopIcon().getSize().width >= this.desktop.getSize().width) {
                int h = this.desktop.getSize().height;
                this.nextX = 5;
                this.nextY += graphFrame.getDesktopIcon().getSize().height;
                if (this.nextY + graphFrame.getDesktopIcon().getSize().height >= h) {
                    h = this.nextY + graphFrame.getDesktopIcon().getSize().height;
                    this.desktop.setPreferredSize(new Dimension(this.myW, h));
                }
            }
            this.nextX += graphFrame.getDesktopIcon().getSize().width;
        }
        return graphFrame;
    }

    public JInternalFrame addRule1(Rule rule, int w1, int h1) {
        if (this.option == null || this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        if (!(rule instanceof RuleScheme)) {
            if (this.layout != null) {
                this.layoutRule1 = this.layout.getRule(rule);
                if (this.layoutRule1 == null) {
                    this.layoutRule1 = new EdRule(rule);
                    this.layoutRule1.getLeft().doDefaultEvolutionaryGraphLayout(10);
                    this.layoutRule1.getRight().doDefaultEvolutionaryGraphLayout(10);
                } else {
                    if (!this.layoutRule1.getLeft().hasDefaultLayout()) {
                        this.layoutRule1.getLeft().doDefaultEvolutionaryGraphLayout(10);
                    }
                    if (!this.layoutRule1.getRight().hasDefaultLayout()) {
                        this.layoutRule1.getRight().doDefaultEvolutionaryGraphLayout(10);
                    }
                }
            } else {
                this.layoutRule1 = new EdRule(rule);
                this.layoutRule1.getLeft().doDefaultEvolutionaryGraphLayout(10);
                this.layoutRule1.getRight().doDefaultEvolutionaryGraphLayout(10);
            }
            this.layoutRule1.update();
            this.layoutRule1.getLeft().setEditable(false);
            this.layoutRule1.getRight().setEditable(false);
        } else {
            this.layoutRule1 = null;
        }
        if (this.ruleFrame1 == null) {
            this.createRuleEditor1();
            this.ruleFrame1 = new JInternalFrame("", true, true, true, true);
            this.ruleFrame1.setFrameIcon(this.internalFrameIcon);
            this.ruleFrame1.setTitle("     Rule 1 ");
            this.ruleFrame1.addInternalFrameListener(this);
            this.ruleFrame1.getContentPane().add(this.ruleEdit1);
            this.ruleFrame1.setSize(new Dimension(w1, h1));
            this.desktop.add(this.ruleFrame1);
        }
        this.ruleEdit1.setRule(this.layoutRule1);
        this.ruleEdit1.setNAC(null);
        this.ruleEdit1.setEditMode(13);
        this.ruleEdit1.setRuleTitle(rule.getQualifiedName(), "");
        this.ruleEdit1.enableSynchronMoveOfMappedObjects(false);
        this.ruleFrame1.setVisible(false);
        try {
            this.ruleFrame1.setIcon(true);
            this.ruleFrame1.setSelected(false);
            this.ruleFrame1.setVisible(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.nextX = this.ruleFrame1.getDesktopIcon().getSize().width;
        this.nextY = 5;
        this.ruleFrame1.getDesktopIcon().setLocation(this.nextX, this.nextY);
        return this.ruleFrame1;
    }

    public JInternalFrame addRule2(Rule rule, int w1, int h1) {
        if (this.option == null || this.option.getNumberOfCriticalPair() <= this.desktop.getComponentCount()) {
            return null;
        }
        if (!(rule instanceof RuleScheme)) {
            if (this.layout != null) {
                this.layoutRule2 = this.layout.getRule(rule);
                if (this.layoutRule2 == null) {
                    this.layoutRule2 = new EdRule(rule);
                    this.layoutRule2.getLeft().doDefaultEvolutionaryGraphLayout(10);
                    this.layoutRule2.getRight().doDefaultEvolutionaryGraphLayout(10);
                } else if (this.layoutRule2 == this.layoutRule1) {
                    this.layoutRule2 = new EdRule(rule);
                    this.setRuleLayout(this.layoutRule2, this.layoutRule1);
                } else {
                    if (!this.layoutRule2.getLeft().hasDefaultLayout()) {
                        this.layoutRule2.getLeft().doDefaultEvolutionaryGraphLayout(10);
                    }
                    if (!this.layoutRule2.getRight().hasDefaultLayout()) {
                        this.layoutRule2.getRight().doDefaultEvolutionaryGraphLayout(10);
                    }
                }
            } else {
                this.layoutRule2 = new EdRule(rule);
                this.layoutRule2.getLeft().doDefaultEvolutionaryGraphLayout(10);
                this.layoutRule2.getRight().doDefaultEvolutionaryGraphLayout(10);
            }
            this.layoutRule2.update();
            this.layoutRule2.getLeft().setEditable(false);
            this.layoutRule2.getRight().setEditable(false);
        } else {
            this.layoutRule2 = null;
        }
        if (this.ruleFrame2 == null) {
            this.createRuleEditor2();
            this.ruleFrame2 = new JInternalFrame("", true, true, true, true);
            this.ruleFrame2.setFrameIcon(this.internalFrameIcon);
            this.ruleFrame2.setTitle("     Rule 2 ");
            this.ruleFrame2.addInternalFrameListener(this);
            this.ruleFrame2.getContentPane().add(this.ruleEdit2);
            this.ruleFrame2.setSize(new Dimension(w1, h1));
            this.desktop.add(this.ruleFrame2);
        }
        this.ruleEdit2.setRule(this.layoutRule2);
        this.ruleEdit2.setNAC(null);
        this.ruleEdit2.setEditMode(13);
        this.ruleEdit2.setRuleTitle(rule.getQualifiedName(), "");
        this.ruleEdit2.enableSynchronMoveOfMappedObjects(false);
        this.ruleFrame2.setVisible(false);
        try {
            this.ruleFrame2.setIcon(true);
            this.ruleFrame2.setSelected(false);
            this.ruleFrame2.setVisible(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.nextX = this.ruleFrame1.getDesktopIcon().getSize().width * 2;
        this.nextY = 5;
        this.ruleFrame2.getDesktopIcon().setLocation(this.nextX, this.nextY);
        return this.ruleFrame2;
    }

    private void setRuleLayout(EdRule to, EdRule from) {
        to.getLeft().setLayoutByBasisObject(from.getLeft());
        to.getRight().setLayoutByBasisObject(from.getRight());
        Vector<EdNAC> nacsTo = to.getNACs();
        Vector<EdNAC> nacsFrom = from.getNACs();
        int i = 0;
        while (i < nacsTo.size()) {
            EdGraph nacGto = nacsTo.get(i);
            int j = 0;
            while (j < nacsFrom.size()) {
                EdGraph nacGfrom = nacsFrom.get(j);
                if (nacGto.getBasisGraph() == nacGfrom.getBasisGraph()) {
                    nacGto.setLayoutByBasisObject(nacGfrom);
                    break;
                }
                ++j;
            }
            ++i;
        }
        Vector<EdPAC> pacsTo = to.getPACs();
        Vector<EdPAC> pacsFrom = from.getPACs();
        int i2 = 0;
        while (i2 < pacsTo.size()) {
            EdGraph pacGto = pacsTo.get(i2);
            int j = 0;
            while (j < pacsFrom.size()) {
                EdGraph pacGfrom = pacsFrom.get(j);
                if (pacGto.getBasisGraph() == pacGfrom.getBasisGraph()) {
                    pacGto.setLayoutByBasisObject(pacGfrom);
                    break;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void setIconOfRules(boolean b) {
        if (this.ruleFrame1 != null && !this.ruleFrame1.isIcon()) {
            try {
                this.ruleFrame1.setIcon(b);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.ruleFrame2 != null && !this.ruleFrame2.isIcon()) {
            try {
                this.ruleFrame2.setIcon(b);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private EdNAC resetNAC(RuleEditor edit, EdRule rule, String nacName, Color bgcolor) {
        if (rule == null || nacName == null || nacName.length() == 0) {
            return null;
        }
        EdNAC nacGraph = null;
        if (rule.getNACs().isEmpty()) {
            edit.setNAC(null);
        } else {
            int i = 0;
            while (i < rule.getNACs().size()) {
                nacGraph = rule.getNACs().get(i);
                if (nacName.equals(nacGraph.getName())) {
                    edit.setNAC(nacGraph);
                    edit.setNACTitle("NAC: " + nacGraph.getName());
                    edit.getNACPanel().setBackground(bgcolor);
                    edit.getLeftPanel().setBackground(bgcolor);
                    return nacGraph;
                }
                ++i;
            }
        }
        return nacGraph;
    }

    private EdPAC resetPAC(RuleEditor edit, EdRule rule, String pacName, Color bgcolor) {
        if (rule == null || pacName == null || pacName.length() == 0) {
            return null;
        }
        EdPAC pacGraph = null;
        if (rule.getPACs().isEmpty()) {
            edit.setPAC(null);
        } else {
            int i = 0;
            while (i < rule.getPACs().size()) {
                pacGraph = rule.getPACs().get(i);
                if (pacName.equals(pacGraph.getName())) {
                    edit.setPAC(pacGraph);
                    edit.setPACTitle("PAC: " + pacGraph.getName());
                    edit.getPACPanel().setBackground(bgcolor);
                    edit.getLeftPanel().setBackground(bgcolor);
                    return pacGraph;
                }
                ++i;
            }
        }
        return pacGraph;
    }

    public JInternalFrame getInternalCPAGraphFrame() {
        return this.cpaGraphFrame;
    }

    public JInternalFrame getInternalGraphFrame(Graph g) {
        return this.internalGraphFrames.get(g);
    }

    public EdGraph getInternalLayoutGraph(Graph g) {
        return this.internalLayoutGraphs.get(g);
    }

    public JButton addNextButton(Graph g, String text) {
        JInternalFrame f = this.internalGraphFrames.get(g);
        JButton next = new JButton(text);
        f.getContentPane().add((Component)next, "South");
        return next;
    }

    public void notCriticFrame(Rule first, Rule second) {
        this.notCriticFrame(first, second, "");
    }

    public void notCriticFrame(Rule first, Rule second, String text) {
        this.resetNAC(this.ruleEdit1, this.layoutRule1, null, Color.WHITE);
        this.ruleEdit1.setDividerLocation(0, 0);
        this.resetNAC(this.ruleEdit2, this.layoutRule2, null, Color.WHITE);
        this.ruleEdit2.setDividerLocation(0, 0);
        Report.trace("starte notCriticFrame", 1);
        JInternalFrame newGraph = new JInternalFrame("not critic rules", false, false, false, false);
        newGraph.setVisible(true);
        newGraph.setSize(300, 150);
        newGraph.setFrameIcon(this.internalFrameIcon);
        newGraph.getContentPane().setLayout(new BorderLayout());
        URL url = ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/ok2.gif");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            Image image = icon.getImage();
            Image scaledImage = image.getScaledInstance(50, 50, 4);
            ImageIcon scaledIcon = new ImageIcon(scaledImage);
            JLabel l = new JLabel(scaledIcon);
            newGraph.getContentPane().add((Component)l, "West");
        }
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new GridBagLayout());
        JLabel message1 = new JLabel("r1: " + first.getName());
        JLabel message2 = new JLabel("doesn't exclude");
        JLabel message3 = new JLabel("r2: " + second.getName());
        JLabel message4 = null;
        if (text.length() != 0) {
            message4 = new JLabel(text);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        messagePanel.add((Component)message1, c);
        messagePanel.add((Component)message2, c);
        messagePanel.add((Component)message3, c);
        if (message4 != null) {
            messagePanel.add((Component)message4, c);
        }
        newGraph.getContentPane().add((Component)messagePanel, "Center");
        Report.println("DesktopSize " + this.desktop.getSize(), Report.TRACE);
        int posX = (int)this.desktop.getSize().getWidth();
        int posY = (int)this.desktop.getSize().getHeight();
        int width = (int)newGraph.getSize().getWidth();
        int height = (int)newGraph.getSize().getHeight();
        newGraph.setLocation((posX /= 2) - (width /= 2), (posY /= 2) - (height /= 2));
        this.desktop.add(newGraph);
        Report.trace("beende notCriticFrame", -1);
    }

    public void setOverlappingGraphWindowSize(Dimension size) {
        this.internalFrameSize = size;
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = 0;
            while (i < allFrames.length) {
                allFrames[i].setSize(this.internalFrameSize);
                ++i;
            }
        }
    }

    public void addOverlapping(Graph graph, Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pair) {
        this.overlappings.put(graph, pair);
    }

    public CriticalPairPanel getActivePairPanel() {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = 0;
            while (i < allFrames.length) {
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (c instanceof CriticalPairPanel && ((CriticalPairPanel)c).isActive()) {
                    return (CriticalPairPanel)c;
                }
                ++i;
            }
        }
        return null;
    }

    public CriticalPairPanel getConflictPairPanel() {
        return this.conflictPanel;
    }

    public CriticalPairPanel getDependPairPanel() {
        return this.dependPanel;
    }

    public Component getComponent() {
        return this.jsp;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public void setIconOfPairTable(boolean b) {
        int i = this.desktop.getAllFrames().length - 1;
        while (i >= 0) {
            JInternalFrame f = this.desktop.getAllFrames()[i];
            Component c = f.getContentPane().getComponent(0);
            if (c instanceof CriticalPairPanel) {
                try {
                    f.setIcon(b);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            --i;
        }
    }

    public void setIconOfPairTable(CriticalPairPanel p, boolean b) {
        if (p == null) {
            return;
        }
        int i = this.desktop.getAllFrames().length - 1;
        while (i >= 0) {
            JInternalFrame f = this.desktop.getAllFrames()[i];
            Component c = f.getContentPane().getComponent(0);
            if (c instanceof CriticalPairPanel && (CriticalPairPanel)c == p) {
                try {
                    f.setIcon(b);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            --i;
        }
    }

    public void setIconOfCPAGraph(boolean b) {
        if (this.cpaGraphFrame == null) {
            return;
        }
        try {
            this.cpaGraphFrame.setIcon(b);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void removeCPAGraphFrame() {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = 0;
            while (i < allFrames.length) {
                GraphEditor gege;
                EdGraph eg;
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (c instanceof GraphEditor && (eg = (gege = (GraphEditor)c).getGraph()).isCPAgraph()) {
                    if (f.isIcon()) {
                        this.desktop.remove(f.getDesktopIcon());
                    } else {
                        this.desktop.remove(f);
                    }
                }
                ++i;
            }
        }
    }

    private void removeVarEqualityDialogs() {
        Iterator<VariableEqualityDialog> iterator = this.varEqualityDialogs.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setVisible(false);
        }
        this.varEqualityDialogs.clear();
    }

    public void removeAllFrames() {
        this.removeVarEqualityDialogs();
        this.overlappings.clear();
        this.desktop.removeAll();
        this.nextX = 5;
        this.nextY = 5;
    }

    public void removeAllGraphFrames() {
        this.removeVarEqualityDialogs();
        this.overlappings = new Hashtable();
        int i = this.desktop.getAllFrames().length - 1;
        while (i >= 0) {
            JInternalFrame f = this.desktop.getAllFrames()[i];
            if (f != this.cpaGraphFrame) {
                Component c = f.getContentPane().getComponent(0);
                if (c instanceof GraphEditor) {
                    if (f.isIcon()) {
                        this.desktop.remove(f.getDesktopIcon());
                    } else {
                        this.desktop.remove(f);
                    }
                } else if (c instanceof JLabel) {
                    this.desktop.remove(f);
                }
            }
            --i;
        }
        this.nextX = 5;
        this.nextY = 5;
        this.nextX += 480;
    }

    public void removePairPanelFrame(CriticalPairPanel p) {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = 0;
            while (i < allFrames.length) {
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (c instanceof CriticalPairPanel && p == (CriticalPairPanel)c) {
                    this.desktop.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void removePairPanelFrame(PairContainer p) {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = 0;
            while (i < allFrames.length) {
                JInternalFrame f = allFrames[i];
                Component c = f.getContentPane().getComponent(0);
                if (c instanceof CriticalPairPanel && ((CriticalPairPanel)c).getPairContainer() == p) {
                    this.desktop.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void removeRuleFrame(int indx) {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = 0;
            while (i < allFrames.length) {
                JInternalFrame f = allFrames[i];
                if (indx == 1 && f == this.ruleFrame1) {
                    this.desktop.remove(i);
                    this.ruleFrame1 = null;
                    break;
                }
                if (indx == 2 && f == this.ruleFrame2) {
                    this.desktop.remove(i);
                    this.ruleFrame2 = null;
                    break;
                }
                ++i;
            }
        }
    }

    public void removeRuleFrames() {
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = allFrames.length - 1;
            while (i >= 0) {
                JInternalFrame f = allFrames[i];
                if (f == this.ruleFrame1) {
                    this.desktop.remove(i);
                    this.ruleFrame1 = null;
                } else if (f == this.ruleFrame2) {
                    this.desktop.remove(i);
                    this.ruleFrame2 = null;
                }
                --i;
            }
        }
    }

    public void reinitComponents() {
        if (this.conflictPanel != null) {
            this.removePairPanelFrame(this.conflictPanel);
            this.conflictPanel = null;
            this.conflictFrame = null;
        }
        if (this.dependPanel != null) {
            this.removePairPanelFrame(this.dependPanel);
            this.dependPanel = null;
            this.dependFrame = null;
        }
        if (this.cpaGraphFrame != null) {
            this.removeCPAGraphFrame();
            this.cpaGraphFrame = null;
        }
        this.internalLayoutGraphs.clear();
        this.internalGraphFrames.clear();
        if (this.ruleEdit1 != null) {
            this.removeRuleFrame(1);
        }
        if (this.ruleEdit2 != null) {
            this.removeRuleFrame(2);
        }
        this.removeAllFrames();
    }

    public void refresh() {
        Component c;
        this.removeAllGraphFrames();
        JInternalFrame[] allFrames = this.desktop.getAllFrames();
        if (allFrames != null) {
            int i = 0;
            while (i < allFrames.length) {
                JInternalFrame f = allFrames[i];
                Component c2 = f.getContentPane().getComponent(0);
                if (c2 instanceof CriticalPairPanel) {
                    ((CriticalPairPanel)c2).refreshView();
                }
                ++i;
            }
        }
        if (this.cpaGraphFrame != null && (c = this.cpaGraphFrame.getContentPane().getComponent(0)) instanceof GraphEditor) {
            ((GraphEditor)c).updateGraphics();
        }
        if (this.ruleEdit1 != null) {
            this.ruleEdit1.updateGraphics();
        }
        if (this.ruleEdit2 != null) {
            this.ruleEdit2.updateGraphics();
        }
    }

    public void refreshCPAGraph() {
        Component c;
        if (this.cpaGraphFrame != null && (c = this.cpaGraphFrame.getContentPane().getComponent(0)) instanceof GraphEditor) {
            ((GraphEditor)c).updateGraphics();
        }
    }

    public boolean hasEmptyComponents() {
        if (this.conflictFrame != null && !((CriticalPairPanel)this.conflictFrame.getContentPane().getComponent(0)).isEmpty()) {
            return false;
        }
        return this.dependFrame == null || ((CriticalPairPanel)this.dependFrame.getContentPane().getComponent(0)).isEmpty();
    }

    public void addParserGUIListener(ParserGUIListener pgl) {
        this.listener.addElement(pgl);
    }

    public void removeParserGUIListener(ParserGUIListener pgl) {
        this.listener.remove(pgl);
    }

    void fireParserGUIEvent(Object data) {
        ParserGUIEvent event = new ParserGUIEvent(this, data);
        int i = 0;
        while (i < this.listener.size()) {
            ParserGUIListener l = this.listener.elementAt(i);
            l.occured(event);
            ++i;
        }
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        JInternalFrame jif = (JInternalFrame)e.getSource();
        Component c = jif.getContentPane().getComponent(0);
        if (jif == this.cpaGraphFrame && this.activeGraphFrame != this.cpaGraphFrame) {
            if (this.ruleFrame1 != null && this.ruleFrame2 != null) {
                try {
                    this.ruleFrame1.setIcon(true);
                    this.ruleFrame2.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (!this.internalGraphFrames.isEmpty()) {
                Enumeration<JInternalFrame> en = this.internalGraphFrames.elements();
                while (en.hasMoreElements()) {
                    JInternalFrame item = en.nextElement();
                    if (item == this.cpaGraphFrame) continue;
                    try {
                        item.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            this.activeGraphFrame = jif;
        } else if (c instanceof GraphEditor) {
            EdMorphism numbers;
            GraphEditor gege;
            EdGraph eg;
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> morphs;
            Component co;
            if (this.activeGraphFrame != null && (co = this.activeGraphFrame.getContentPane().getComponent(0)) instanceof GraphEditor) {
                GraphEditor gege2 = (GraphEditor)co;
                Color bgcolor = Color.WHITE;
                if (gege2.getGraphPanel() != null) {
                    gege2.getGraphPanel().setBackground(bgcolor);
                }
                if (this.ruleEdit1 != null && this.ruleEdit1.getLeftPanel() != null) {
                    this.ruleEdit1.getLeftPanel().setBackground(bgcolor);
                    this.ruleEdit1.getRightPanel().setBackground(bgcolor);
                }
                if (this.ruleEdit2 != null && this.ruleEdit2.getLeftPanel() != null) {
                    this.ruleEdit2.getNACPanel().setBackground(bgcolor);
                    this.ruleEdit2.getLeftPanel().setBackground(bgcolor);
                    this.ruleEdit2.setNAC(null);
                }
                EdGraph eg2 = gege2.getGraph();
                eg2.clearMarks();
            }
            this.activeGraphFrame = jif;
            if (this.activeGraphFrame.getX() == 0 && this.activeGraphFrame.getY() == 0) {
                this.activeGraphFrame.setLocation(this.dx, this.dy);
                this.dx = this.dx == 0 ? 50 : 0;
                int n = this.dy = this.dy == 0 ? 50 : 0;
            }
            if ((morphs = this.overlappings.get((eg = (gege = (GraphEditor)c).getGraph()).getBasisGraph())) == null) {
                return;
            }
            String nacName = eg.getBasisGraph().getHelpInfoAboutNAC();
            String pacName = eg.getBasisGraph().getHelpInfoAboutPAC();
            OrdinaryMorphism o1 = (OrdinaryMorphism)((Pair)morphs.first).first;
            OrdinaryMorphism o2 = (OrdinaryMorphism)((Pair)morphs.first).second;
            Color bgcolor = new Color(255, 255, 165);
            gege.getGraphPanel().setBackground(bgcolor);
            if (CriticalPairData.isSwitchDependency(eg.getBasisGraph().getName())) {
                if (o1.getSource() == this.layoutRule2.getBasisRule().getLeft()) {
                    this.ruleEdit2.getLeftPanel().setBackground(bgcolor);
                } else if (o1.getSource() == this.layoutRule2.getBasisRule().getRight()) {
                    this.ruleEdit2.getRightPanel().setBackground(bgcolor);
                }
                EdNAC nac1 = this.resetNAC(this.ruleEdit1, this.layoutRule1, nacName, bgcolor);
                if (nac1 != null) {
                    this.ruleEdit1.getNACPanel().setBackground(bgcolor);
                }
                if (morphs.second != null) {
                    if (((OrdinaryMorphism)((Pair)morphs.second).first).getSource() == this.layoutRule1.getBasisRule().getLeft()) {
                        this.ruleEdit1.getLeftPanel().setBackground(bgcolor);
                        this.ruleEdit1.getRightPanel().setBackground(Color.WHITE);
                    } else if (((OrdinaryMorphism)((Pair)morphs.second).first).getSource() == this.layoutRule1.getBasisRule().getRight()) {
                        this.ruleEdit1.getRightPanel().setBackground(bgcolor);
                        this.ruleEdit1.getLeftPanel().setBackground(Color.WHITE);
                    }
                } else {
                    this.ruleEdit1.getRightPanel().setBackground(bgcolor);
                }
                int indx = 0;
                numbers = new EdMorphism(null);
                Pair morphsN2 = (Pair)morphs.second;
                indx = numbers.makeVDiagram_NAC(this.layoutRule2.getBasisRule(), this.layoutRule1.getBasisRule(), o1, o2, morphsN2, indx);
                if (nac1 != null) {
                    indx = numbers.completeMorphismMarks(nac1.getMorphism(), numbers.getFirstTarget(), indx);
                }
                eg.setMorphismMarks(numbers.getSourceOfMorphism(), true);
                this.setMorphismMarks(this.layoutRule2, null, numbers.getTargetOfMorphism(1), indx);
                this.setMorphismMarks(this.layoutRule1, nac1, numbers.getTargetOfMorphism(2), indx);
                this.fireParserGUIEvent(numbers);
                this.fireParserGUIEvent(eg.getBasisGraph());
            } else if (eg.getBasisGraph().getName().indexOf("produceEdge-deleteNode-") >= 0) {
                this.ruleEdit1.getLeftPanel().setBackground(bgcolor);
                this.ruleEdit2.getLeftPanel().setBackground(bgcolor);
                int indx = 0;
                EdMorphism numbers2 = new EdMorphism(null);
                indx = numbers2.makeVDiagram(this.layoutRule1.getBasisRule(), this.layoutRule2.getBasisRule(), o1, o2, indx);
                eg.setMorphismMarks(numbers2.getSourceOfMorphism(), true);
                this.setMorphismMarks(this.layoutRule1, null, numbers2.getTargetOfMorphism(1), indx);
                this.setMorphismMarks(this.layoutRule2, null, numbers2.getTargetOfMorphism(2), indx);
                this.fireParserGUIEvent(numbers2);
                this.fireParserGUIEvent(eg.getBasisGraph());
            } else {
                EdPAC pac2 = null;
                EdNAC nac2 = null;
                if (o1.getSource() == this.layoutRule1.getBasisRule().getLeft()) {
                    this.ruleEdit1.getLeftPanel().setBackground(bgcolor);
                } else if (o1.getSource() == this.layoutRule1.getBasisRule().getRight()) {
                    this.ruleEdit1.getRightPanel().setBackground(bgcolor);
                }
                nac2 = this.resetNAC(this.ruleEdit2, this.layoutRule2, nacName, bgcolor);
                if (nac2 != null) {
                    this.ruleEdit2.getNACPanel().setBackground(bgcolor);
                }
                if ((pac2 = this.resetPAC(this.ruleEdit2, this.layoutRule2, pacName, bgcolor)) != null) {
                    this.ruleEdit2.getPACPanel().setBackground(bgcolor);
                }
                this.ruleEdit2.getLeftPanel().setBackground(bgcolor);
                numbers = new EdMorphism(null);
                int indx = 0;
                Pair condMorph2 = (Pair)morphs.second;
                if (pac2 != null) {
                    indx = numbers.makeVDiagram_PAC(this.layoutRule1.getBasisRule(), this.layoutRule2.getBasisRule(), o1, o2, condMorph2, pac2.getMorphism(), indx);
                }
                indx = nac2 != null ? numbers.makeVDiagram_NAC(this.layoutRule1.getBasisRule(), this.layoutRule2.getBasisRule(), o1, o2, condMorph2, indx) : numbers.makeVDiagram(this.layoutRule1.getBasisRule(), this.layoutRule2.getBasisRule(), o1, o2, indx);
                eg.setMorphismMarks(numbers.getSourceOfMorphism(), true);
                this.setMorphismMarks(this.layoutRule1, null, numbers.getTargetOfMorphism(1), indx);
                if (pac2 != null) {
                    this.setMorphismMarks(this.layoutRule2, pac2, numbers.getTargetOfMorphism(2), indx);
                }
                if (nac2 != null) {
                    this.setMorphismMarks(this.layoutRule2, nac2, numbers.getTargetOfMorphism(2), indx);
                } else {
                    this.setMorphismMarks(this.layoutRule2, pac2, numbers.getTargetOfMorphism(2), indx);
                }
                this.fireParserGUIEvent(numbers);
                this.fireParserGUIEvent(eg.getBasisGraph());
            }
            gege.updateGraphics();
            JInternalFrame[] allFrames = this.desktop.getAllFrames();
            if (allFrames != null) {
                int i = 0;
                while (i < allFrames.length) {
                    JInternalFrame f = allFrames[i];
                    Component comp = f.getContentPane().getComponent(0);
                    if (!(comp instanceof CriticalPairPanel)) {
                        return;
                    }
                    ((CriticalPairPanel)comp).active = false;
                    ++i;
                }
            }
        } else if (c instanceof CriticalPairPanel) {
            ((CriticalPairPanel)c).active = true;
            if (this.ruleEdit1 != null) {
                this.ruleEdit1.getLeftPanel().setBackground(Color.WHITE);
                this.ruleEdit1.getRightPanel().setBackground(Color.WHITE);
            }
            if (this.ruleEdit2 != null) {
                this.ruleEdit2.getLeftPanel().setBackground(Color.WHITE);
                if (this.ruleEdit2.getLeftCondPanel() != null) {
                    this.ruleEdit2.getLeftCondPanel().setBackground(Color.WHITE);
                }
            }
            this.fireParserGUIEvent(c);
        } else if (jif == this.ruleFrame1) {
            int xpos = this.ruleFrame1.getX() < 0 ? 0 : this.ruleFrame1.getX();
            int ypos = this.ruleFrame1.getY() < 0 ? 0 : this.ruleFrame1.getY();
            this.ruleFrame1.setLocation(xpos, ypos);
        } else if (jif == this.ruleFrame2) {
            int xpos = this.ruleFrame2.getX() <= 0 ? 0 : this.ruleFrame2.getX();
            int ypos = this.ruleFrame2.getY() <= 0 ? 50 : this.ruleFrame2.getY();
            this.ruleFrame2.setLocation(xpos, ypos);
        }
    }

    private void setMorphismMarks(EdRule r, EdGraph condGraph, HashMap<?, ?> map, int lastMark) {
        if (condGraph == null) {
            r.setMorphismMarks(map);
        } else if (condGraph instanceof EdNAC) {
            r.setMorphismMarks(map, (EdNAC)condGraph);
        } else if (condGraph instanceof EdPAC) {
            r.setMorphismMarks(map, (EdPAC)condGraph);
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        JInternalFrame jif = (JInternalFrame)e.getSource();
        Component c = jif.getContentPane().getComponent(0);
        if (c instanceof GraphEditor) {
            GraphEditor gege = (GraphEditor)c;
            EdGraph eg = gege.getGraph();
            if (eg.isCPAgraph()) {
                if (jif.isIcon()) {
                    this.desktop.remove(jif.getDesktopIcon());
                } else {
                    this.desktop.remove(jif);
                }
            } else if (this.varEqualityDialogs.get(eg) != null) {
                this.varEqualityDialogs.get(eg).setVisible(false);
                this.varEqualityDialogs.remove(eg);
            }
        } else if (c instanceof CriticalPairPanel) {
            if (jif.isIcon()) {
                this.desktop.remove(jif.getDesktopIcon());
            } else {
                this.desktop.remove(jif);
            }
        } else if (c instanceof RuleEditor) {
            RuleEditor re = (RuleEditor)c;
            if (jif.isIcon()) {
                this.desktop.remove(jif.getDesktopIcon());
            } else {
                this.desktop.remove(jif);
            }
            if (re == this.ruleEdit1) {
                this.ruleFrame1 = null;
            } else if (re == this.ruleEdit2) {
                this.ruleFrame2 = null;
            }
        }
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        GraphEditor gege;
        EdGraph eg;
        JInternalFrame jif = (JInternalFrame)e.getSource();
        Component c = jif.getContentPane().getComponent(0);
        if (c instanceof CriticalPairPanel) {
            if (((CriticalPairPanel)c).getPairContainer().getKindOfConflict() == 0) {
                jif.getDesktopIcon().setLocation(5, 5);
            } else {
                jif.getDesktopIcon().setLocation(5, jif.getDesktopIcon().getSize().height);
            }
        } else if (jif == this.cpaGraphFrame) {
            jif.getDesktopIcon().setLocation(5, jif.getDesktopIcon().getSize().height * 2);
        } else if (c instanceof GraphEditor && this.varEqualityDialogs.get(eg = (gege = (GraphEditor)c).getGraph()) != null) {
            this.varEqualityDialogs.get(eg).setVisible(false);
            this.varEqualityDialogs.remove(eg);
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    private void makeCPAGraphMenu() {
        this.cpaGraphMenu.add(this.miC);
        this.cpaGraphMenu.add(this.miD);
        this.cpaGraphMenu.add(this.miAll);
        this.cpaGraphMenu.addSeparator();
        this.cpaGraphMenu.add(this.miHide);
        this.cpaGraphMenu.addSeparator();
        this.cpaGraphMenu.add(this.miStraightEdges);
        this.cpaGraphMenu.addSeparator();
        this.makeCPAEdgeShapeMenu(this.miShapeC, "Conflict Edge Style", "Conflict");
        this.cpaGraphMenu.add(this.miShapeC);
        this.makeCPAEdgeShapeMenu(this.miShapeD, "Dependency Edge Style", "Dependency");
        this.cpaGraphMenu.add(this.miShapeD);
        this.cpaGraphMenu.addSeparator();
        this.cpaGraphMenu.add(this.miLayoutGraph);
        this.cpaGraphMenu.addSeparator();
        this.cpaGraphMenu.add(this.miRefresh);
        this.cpaGraphMenu.addSeparator();
        this.cpaGraphMenu.add(this.miGraphExportJPG);
        this.miGraphExportJPG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.activeGraphPanel != null && GraphDesktop.this.activeGraphPanel.getGraph() != null) {
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.activeGraphPanel.getCanvas());
                }
            }
        });
        this.cpaGraphMenu.pack();
        this.cpaGraphMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private void makeGraphMenu() {
        this.graphMenu.add(this.miVarEqual_graphMenu);
        this.miVarEqual_graphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.activeGraphPanel != null && GraphDesktop.this.activeGraphPanel.getGraph() != null) {
                    GraphDesktop.this.showVarEqualityDialog(GraphDesktop.this.activeGraphPanel.getGraph(), GraphDesktop.this.locationOnScreen);
                }
            }
        });
        this.graphMenu.addSeparator();
        this.graphMenu.add(this.miAddToGraphs_graphMenu);
        this.miAddToGraphs_graphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.activeGraphPanel != null && GraphDesktop.this.activeGraphPanel.getGraph() != null && GraphDesktop.this.layout != null) {
                    GraphDesktop.this.addGraphToHostGraphs();
                }
            }
        });
        this.graphMenu.add(this.miAddToNACs_graphMenu);
        this.miFirstRule = this.miAddToNACs_graphMenu.add(new JMenuItem("Of First Rule"));
        this.miFirstRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktop.this.addGraphToNACs(true);
            }
        });
        this.miSecondRule = this.miAddToNACs_graphMenu.add(new JMenuItem("Of Second Rule"));
        this.miSecondRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphDesktop.this.addGraphToNACs(false);
            }
        });
        this.graphMenu.addSeparator();
        this.graphMenu.add(this.miLayout_graphMenu);
        this.miLayout_graphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.activeGraphPanel != null && GraphDesktop.this.activeGraphPanel.getGraph() != null) {
                    GraphDesktop.this.makeLayout(GraphDesktop.this.activeGraphPanel.getGraph(), GraphDesktop.this.activeGraphPanel.getSize());
                    GraphDesktop.this.activeGraphPanel.updateGraphics();
                }
            }
        });
        this.graphMenu.addSeparator();
        this.graphMenu.add(this.miExportJPG_graphMenu);
        this.miExportJPG_graphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.activeGraphPanel != null && GraphDesktop.this.activeGraphPanel.getGraph() != null) {
                    GraphDesktop.this.activeGraphPanel.setBackground(Color.white);
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.activeGraphPanel.getCanvas());
                    GraphDesktop.this.activeGraphPanel.setBackground(new Color(255, 255, 165));
                }
            }
        });
        this.graphMenu.pack();
        this.graphMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    void addGraphToHostGraphs() {
        int levelOfTGcheck = this.layout.getLevelOfTypeGraphCheck();
        this.layout.getTypeSet().getBasisTypeSet().setLevelOfTypeGraph(10);
        EdGraph g = this.activeGraphPanel.getGraph().copy();
        g.unsetAttributeValueWhereVariable();
        if (this.layout.addGraph(g)) {
            Collection<TypeError> errors = this.layout.setLevelOfTypeGraphCheck(levelOfTGcheck);
            if (errors == null || errors.isEmpty()) {
                if (this.parentFrame instanceof AGGAppl) {
                    TreePath path = ((AGGAppl)this.parentFrame).getGraGraTreeView().getTreePathOfGrammarElement(this.layout);
                    ((AGGAppl)this.parentFrame).getGraGraTreeView().getTree().setSelectionPath(path);
                    ((AGGAppl)this.parentFrame).getGraGraTreeView().selectPath(((AGGAppl)this.parentFrame).getGraGraTreeView().getTree().getRowForPath(path));
                    this.layout.setEditable(true);
                    if (((AGGAppl)this.parentFrame).getGraGraTreeView().addGraph(this.layout, g)) {
                        JOptionPane.showMessageDialog(this.parentFrame, "<html><body>You will see currently added graph in the GraGra tree view <br>when you are back to main AGG GUI. <br>Please check attribute settings of nodes and edges.</html></body>");
                    }
                    this.layout.setEditable(false);
                } else {
                    JOptionPane.showMessageDialog(null, "<html><body>To see the saved graph in the GraGra tree view, <br>please reload the grammar of CPA <br>when you are back to main AGG GUI. <br>Please check attribute settings of nodes and edges.</html></body>");
                }
            } else if (this.parentFrame instanceof AGGAppl) {
                TreePath path = ((AGGAppl)this.parentFrame).getGraGraTreeView().getTreePathOfGrammarElement(this.layout.getTypeGraph());
                if (path != null) {
                    ((AGGAppl)this.parentFrame).getGraGraTreeView().selectPath(((AGGAppl)this.parentFrame).getGraGraTreeView().getTree().getRowForPath(path));
                    ((AGGAppl)this.parentFrame).getGraGraTreeView().setTypeGraphLevel(10);
                }
                if ((path = ((AGGAppl)this.parentFrame).getGraGraTreeView().getTreePathOfGrammarElement(this.layout)) != null) {
                    boolean graEditable = this.layout.isEditable();
                    if (!graEditable) {
                        this.layout.setEditable(true);
                    }
                    ((AGGAppl)this.parentFrame).getGraGraTreeView().selectPath(((AGGAppl)this.parentFrame).getGraGraTreeView().getTree().getRowForPath(path));
                    ((AGGAppl)this.parentFrame).getGraGraTreeView().addGraph(this.layout, g);
                    if (!graEditable) {
                        this.layout.setEditable(false);
                    }
                }
                JOptionPane.showMessageDialog(this.parentFrame, "<html><body>You will see currently added graph in the GraGra tree view <br>when you are back to main AGG GUI.<br> <br><font color=\"#FF0000\">WARNING!</font><br>Maybe the level of the Type Graph was changed to <font color=\"#FF0000\">enabled</font>.</html></body>");
            } else {
                JOptionPane.showMessageDialog(null, "<html><body>To see currently saved graph in the GraGra tree view, <br>please reload the grammar of CPA <br>when you are back to main AGG GUI.<br> <br><font color=\"#FF0000\">WARNING!</font><br>Maybe the level of the Type Graph was changed to <font color=\"#FF0000\">enabled</font>.</html></body>");
            }
        }
    }

    void addGraphToNACs(boolean firstRule) {
        if (this.activeGraphPanel != null && this.activeGraphPanel.getGraph() != null && this.layout != null) {
            int levelOfTGcheck = this.layout.getLevelOfTypeGraphCheck();
            this.layout.getTypeSet().getBasisTypeSet().setLevelOfTypeGraph(10);
            EdRule r = firstRule ? this.ruleEdit1.getRule() : this.ruleEdit2.getRule();
            EdGraph g = this.activeGraphPanel.getGraph();
            Hashtable<String, String> varEqualName = VariableEqualityDialog.getVarNameEquality(g.getBasisGraph().getHelpInfoAboutVariableEquality());
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> cp = this.overlappings.get(g.getBasisGraph());
            boolean mapOK = true;
            JLabel errMsg = new JLabel();
            OrdinaryMorphism bnac = this.makeNAC(cp, r.getBasisRule(), g.getBasisGraph(), firstRule, errMsg);
            boolean bl = mapOK = bnac != null && !bnac.isEmpty();
            if (mapOK) {
                this.insertNACIntoGrammar(bnac, g, r, varEqualName, firstRule);
            } else {
                JOptionPane.showMessageDialog(null, "It was not possible to create a NAC based on this critical graph.\n" + errMsg.getText(), "Rule:  " + r.getName(), 0);
            }
            this.layout.getTypeSet().getBasisTypeSet().setLevelOfTypeGraph(levelOfTGcheck);
        }
    }

    private OrdinaryMorphism makeNAC(Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p, Rule r, Graph g, boolean firstRule, JLabel errMsg) {
        OrdinaryMorphism iso = g.isoCopy();
        if (iso == null) {
            return null;
        }
        iso.getTarget().setName(iso.getTarget().getName().replace("_copy", ""));
        OrdinaryMorphism bnac = BaseFactory.theFactory().createMorphism(r.getLeft(), iso.getTarget());
        Pair cp1 = (Pair)p.first;
        Pair cp2 = (Pair)p.second;
        OrdinaryMorphism o1 = (OrdinaryMorphism)cp1.first;
        OrdinaryMorphism o2 = (OrdinaryMorphism)cp1.second;
        boolean mapOK = true;
        if (firstRule) {
            Enumeration<GraphObject> dom = o1.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                try {
                    if (go.getContext() == r.getLeft()) {
                        bnac.addMapping(go, iso.getImage(o1.getImage(go)));
                        continue;
                    }
                    if (go.getContext() != r.getRight()) continue;
                    Enumeration<GraphObject> inverse = r.getInverseImage(go);
                    if (inverse.hasMoreElements()) {
                        GraphObject goL = inverse.nextElement();
                        bnac.addMapping(goL, iso.getImage(o1.getImage(go)));
                        continue;
                    }
                    errMsg.setText("One of critical objects has reference to a new RHS object.");
                    mapOK = false;
                    break;
                }
                catch (BadMappingException ex) {
                    mapOK = false;
                }
            }
            mapOK = mapOK && !bnac.isEmpty();
        } else {
            Enumeration<GraphObject> dom = o2.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                try {
                    Enumeration<GraphObject> inverse;
                    if (go.getContext() == r.getLeft()) {
                        bnac.addMapping(go, iso.getImage(o2.getImage(go)));
                        continue;
                    }
                    if (go.getContext() != ((OrdinaryMorphism)cp2.first).getTarget() || !(inverse = ((OrdinaryMorphism)cp2.first).getInverseImage(go)).hasMoreElements()) continue;
                    GraphObject goL = inverse.nextElement();
                    bnac.addMapping(goL, iso.getImage(o2.getImage(go)));
                }
                catch (BadMappingException ex) {
                    mapOK = false;
                }
            }
            mapOK = mapOK && !bnac.isEmpty();
        }
        iso.dispose();
        if (!mapOK) {
            bnac.dispose(false, true);
            return null;
        }
        return bnac;
    }

    private void insertNACIntoGrammar(OrdinaryMorphism bnac, EdGraph g, EdRule r, Hashtable<String, String> varEqualName, boolean firstRule) {
        EdNAC nac = new EdNAC(bnac);
        nac.setLayoutByIndex(g, true);
        if (this.parentFrame instanceof AGGAppl) {
            TreePath path = ((AGGAppl)this.parentFrame).getGraGraTreeView().getTreePathOfGrammarElement(r);
            ((AGGAppl)this.parentFrame).getGraGraTreeView().getTree().setSelectionPath(path);
            ((AGGAppl)this.parentFrame).getGraGraTreeView().selectPath(((AGGAppl)this.parentFrame).getGraGraTreeView().getTree().getRowForPath(path));
            if (((AGGAppl)this.parentFrame).getGraGraTreeView().addNAC(r, nac)) {
                this.renameEqualVar(nac.getBasisGraph(), r.getBasisRule().getAttrContext().getVariables(), varEqualName, firstRule);
                r.getBasisRule().addToAttrContext(nac.getBasisGraph().getAttrContext());
                JOptionPane.showMessageDialog(this.parentFrame, "<html><body>You will see currently added NAC in the GraGra tree view <br>when you are back to main AGG GUI. <br>Please check attribute settings of nodes and edges.</html></body>", "Rule:  " + r.getName(), 1);
            }
        } else {
            r.addNAC(nac);
            this.renameEqualVar(nac.getBasisGraph(), r.getBasisRule().getAttrContext().getVariables(), varEqualName, false);
            r.getBasisRule().addToAttrContext(nac.getBasisGraph().getAttrContext());
            JOptionPane.showMessageDialog(null, "<html><body>To see the saved NAC in the GraGra tree view, <br>please reload the grammar of CPA <br>when you are back to main AGG GUI. <br>Please check attribute settings of nodes and edges.</html></body>", "Rule:  " + r.getName(), 1);
        }
    }

    private void renameEqualVar(Graph g, AttrVariableTuple attrCont, Hashtable<String, String> varEqualName, boolean firstRule) {
        for (Node go : g.getNodesCollection()) {
            if (go.getAttribute() == null) continue;
            this.renameEqualVar(go, attrCont, varEqualName, firstRule);
        }
        for (Arc go : g.getArcsCollection()) {
            if (go.getAttribute() == null) continue;
            this.renameEqualVar(go, attrCont, varEqualName, firstRule);
        }
    }

    private void renameEqualVar(GraphObject go, AttrVariableTuple attrCont, Hashtable<String, String> varEqualName, boolean firstRule) {
        AttrInstance attr = go.getAttribute();
        int i = 0;
        while (i < attr.getNumberOfEntries()) {
            ValueMember m = (ValueMember)attr.getMemberAt(i);
            if (m.isSet() && m.getExpr().isVariable()) {
                String vR;
                String vR2;
                String vnameG = m.getExprAsText();
                if (firstRule) {
                    if (attrCont.getMemberAt(vnameG.replace("r1_", "")) != null) {
                        vR2 = vnameG.replace("r1_", "");
                        m.setExprAsText(vR2);
                    } else {
                        Enumeration<String> names1 = varEqualName.keys();
                        while (names1.hasMoreElements()) {
                            String n1 = names1.nextElement().replace("[", "");
                            if (!vnameG.contains(n1)) continue;
                            vR = n1.replace("r1_", "");
                            m.setExprAsText(vR);
                        }
                    }
                } else if (attrCont.getMemberAt(vnameG.replace("r2_", "")) != null) {
                    vR2 = vnameG.replace("r2_", "");
                    m.setExprAsText(vR2);
                } else {
                    Iterator<String> names2 = varEqualName.values().iterator();
                    while (names2.hasNext()) {
                        String n2 = names2.next().replace("]", "");
                        if (!vnameG.contains(n2)) continue;
                        vR = n2.replace("r2_", "");
                        m.setExprAsText(vR);
                    }
                }
            }
            ++i;
        }
    }

    protected void makeLayout(EdGraph g, Dimension d) {
        g.updateVisibility();
        List<EdNode> visiblenodes = g.getVisibleNodes();
        g.setCurrentLayoutToDefault(false);
        g.getDefaultGraphLayouter().setEnabled(true);
        Dimension dim = g.getDefaultGraphLayouter().getNeededPanelSize(visiblenodes);
        if (dim.width < 350) {
            dim.width = 350;
        }
        if (dim.width < d.width) {
            dim.width = d.width;
        }
        if (dim.height < 350) {
            dim.height = 350;
        }
        if (dim.height < d.height) {
            dim.height = d.height;
        }
        g.getDefaultGraphLayouter().setPanelSize(dim);
        g.getDefaultGraphLayouter().allowChangePanelSize(false);
        g.getDefaultGraphLayouter().setEnabled(true);
        g.doDefaultEvolutionaryGraphLayout(g.getDefaultGraphLayouter(), 100, 10);
    }

    private JMenu makeCPAEdgeShapeMenu(JMenu shape, String title, String kind) {
        shape.setText(title);
        JMenuItem miSolid = shape.add(new JMenuItem("Solid Line"));
        miSolid.setHorizontalTextPosition(4);
        miSolid.setIcon(new ColorSolidLineIcon(Color.black));
        miSolid.setActionCommand(String.valueOf(kind) + "Solid");
        JMenuItem miDot = shape.add(new JMenuItem("Dot Line"));
        miDot.setHorizontalTextPosition(4);
        miDot.setIcon(new ColorDotLineIcon(Color.black));
        miDot.setActionCommand(String.valueOf(kind) + "Dot");
        JMenuItem miDash = shape.add(new JMenuItem("Dash Line"));
        miDash.setHorizontalTextPosition(4);
        miDash.setIcon(new ColorDashLineIcon(Color.black));
        miDash.setActionCommand(String.valueOf(kind) + "Dash");
        return shape;
    }

    public void addActionListenerToCPAGraphMenu(ActionListener l) {
        this.miC.addActionListener(l);
        this.miD.addActionListener(l);
        this.miAll.addActionListener(l);
        this.miRefresh.addActionListener(l);
        this.miStraightEdges.addActionListener(l);
        this.miHide.addActionListener(l);
        this.miLayoutGraph.addActionListener(l);
        int i = 0;
        while (i < this.miShapeC.getItemCount()) {
            this.miShapeC.getItem(i).addActionListener(l);
            ++i;
        }
        i = 0;
        while (i < this.miShapeD.getItemCount()) {
            this.miShapeD.getItem(i).addActionListener(l);
            ++i;
        }
    }

    public void removeActionListenerFromCPAGraphMenu(ActionListener l) {
        this.miC.removeActionListener(l);
        this.miD.removeActionListener(l);
        this.miAll.removeActionListener(l);
        this.miRefresh.removeActionListener(l);
        this.miStraightEdges.removeActionListener(l);
        this.miHide.removeActionListener(l);
        this.miLayoutGraph.removeActionListener(l);
        int i = 0;
        while (i < this.miShapeC.getItemCount()) {
            this.miShapeC.getItem(i).removeActionListener(l);
            ++i;
        }
        i = 0;
        while (i < this.miShapeD.getItemCount()) {
            this.miShapeD.getItem(i).removeActionListener(l);
            ++i;
        }
    }

    private void setMenuBarOfConflictTableFrame(JMenu m) {
        JMenuBar mb = new JMenuBar();
        mb.add(m);
        this.conflictFrame.setJMenuBar(mb);
        JMenuItem item = this.makeConflictMenuItem("delete - use conflict", m);
        item.setActionCommand("delete-use-conflict");
        item = this.makeConflictMenuItem("delete - need ( PAC ) conflict", m);
        item.setActionCommand("delete-need-conflict");
        m.addSeparator();
        item = this.makeConflictMenuItem("produce - forbid ( NAC ) conflict", m);
        item.setActionCommand("produce-forbid-conflict");
        item = this.makeConflictMenuItem("produce Edge - delete Node conflict", m);
        item.setActionCommand("produceEdge-deleteNode-conflict");
        m.addSeparator();
        item = this.makeConflictMenuItem("change - use attr-conflict", m);
        item.setActionCommand("change-use-attr-conflict");
        item = this.makeConflictMenuItem("change - forbid ( NAC ) attr-conflict", m);
        item.setActionCommand("change-forbid-attr-dependency");
        item = this.makeConflictMenuItem("change - need ( PAC ) attr-conflict", m);
        item.setActionCommand("change-need-attr-conflict");
        m.addSeparator();
        item = this.makeConflictMenuItem("All Conflicts", m);
        item.setActionCommand("ALL");
        this.miAllConfs = item;
        m.addSeparator();
        m.addSeparator();
        JMenuItem mi = m.add(new JMenuItem(" Export JPEG "));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.exportJPEG != null) {
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.conflictFrame);
                }
            }
        });
    }

    private JMenuItem makeConflictMenuItem(String txt, final JMenu m) {
        JMenuItem mi = new JMenuItem(txt);
        mi.setForeground(Color.red);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JMenuItem)e.getSource()).getActionCommand().equals("ALL")) {
                    m.setForeground(Color.black);
                    m.setText(" Show ");
                    GraphDesktop.this.conflictPanel.refreshView();
                    GraphDesktop.this.fireParserGUIEvent(null);
                } else {
                    m.setForeground(Color.red);
                    m.setText(" Show  :       " + ((JMenuItem)e.getSource()).getText());
                    GraphDesktop.this.conflictPanel.showCriticalPairsOfKind(((JMenuItem)e.getSource()).getActionCommand());
                    GraphDesktop.this.fireParserGUIEvent(null);
                }
            }
        });
        m.add(mi);
        return mi;
    }

    public void doClickShowAllConflicts() {
        this.confsMenu.setForeground(Color.black);
        this.confsMenu.setText(" Show ");
    }

    private JMenuItem makeDependMenuItem(String txt, final JMenu m) {
        JMenuItem mi = new JMenuItem(txt);
        mi.setForeground(Color.blue);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JMenuItem)e.getSource()).getActionCommand().equals("ALL")) {
                    m.setForeground(Color.black);
                    m.setText(" Show ");
                    GraphDesktop.this.dependPanel.refreshView();
                    GraphDesktop.this.fireParserGUIEvent(null);
                } else {
                    m.setForeground(Color.blue);
                    m.setText(" Show  :       " + ((JMenuItem)e.getSource()).getText());
                    GraphDesktop.this.dependPanel.showCriticalPairsOfKind(((JMenuItem)e.getSource()).getActionCommand());
                    GraphDesktop.this.fireParserGUIEvent(null);
                }
            }
        });
        m.add(mi);
        return mi;
    }

    public void doClickShowAllDepends() {
        this.depsMenu.setForeground(Color.black);
        this.depsMenu.setText(" Show ");
    }

    private void setMenuBarOfDependencyTableFrame(JMenu m) {
        JMenuBar mb = new JMenuBar();
        mb.add(m);
        this.dependFrame.setJMenuBar(mb);
        JMenuItem item = this.makeDependMenuItem("produce - use dependency", m);
        item.setActionCommand("produce-use-dependency");
        item = this.makeDependMenuItem("produce - <use & delete> dependency", m);
        item.setActionCommand("deliver-delete-dependency");
        item = this.makeDependMenuItem("produce - <use & change> dependency", m);
        item.setActionCommand("deliver-change-dependency");
        m.addSeparator();
        item = this.makeDependMenuItem("produce - need ( PAC ) dependency", m);
        item.setActionCommand("produce-need-dependency");
        m.addSeparator();
        item = this.makeDependMenuItem("delete - forbid ( NAC ) dependency", m);
        item.setActionCommand("delete-forbid-dependency");
        m.addSeparator();
        item = this.makeDependMenuItem("change - use attr-dependency", m);
        item.setActionCommand("change-use-attr-dependency");
        item = this.makeDependMenuItem("change - forbid ( NAC ) attr-dependency", m);
        item.setActionCommand("change-forbid-attr-dependency");
        m.addSeparator();
        item = this.makeDependMenuItem("All Dependencies", m);
        item.setActionCommand("ALL");
        this.miAllDeps = item;
        m.addSeparator();
        m.addSeparator();
        JMenuItem mi = m.add(new JMenuItem(" Export JPEG "));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphDesktop.this.exportJPEG != null) {
                    GraphDesktop.this.exportJPEG.save(GraphDesktop.this.dependFrame);
                }
            }
        });
    }

    private void testCPData(Rule r1, Rule r2) {
        CriticalPairPanel panel = null;
        if (this.conflictPanel != null && this.conflictPanel.isEnabled()) {
            panel = this.conflictPanel;
        } else if (this.dependPanel != null && this.dependPanel.isEnabled()) {
            panel = this.dependPanel;
        }
        if (panel == null) {
            return;
        }
        CriticalPairData cpdata = panel.getPairContainer().getCriticalPairData(r1, r2);
        List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> delUse = cpdata.getDeleteUseConflicts();
        List<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> delNeed = cpdata.getDeleteNeedConflicts();
        System.out.println("CriticalPairData  elements::");
        cpdata.resetIterator();
        while (cpdata.hasCriticals()) {
            OrdinaryMorphism duetoLHS2;
            OrdinaryMorphism duetoPAC;
            cpdata.next();
            Graph g = cpdata.getCriticalGraph();
            String gname = g.getName();
            System.out.println(gname);
            String ghelpNAC = g.getHelpInfoAboutNAC();
            String ghelpPAC = g.getHelpInfoAboutPAC();
            OrdinaryMorphism duetoNAC = cpdata.getMorph2DueToNAC();
            if (duetoNAC != null) {
                Vector<GraphObject> out = duetoNAC.getDomainObjects();
                System.out.println("due to NAC: " + duetoNAC.getSource().getName() + " ::: " + out);
            }
            if ((duetoPAC = cpdata.getMorph2DueToPAC()) != null) {
                Vector<GraphObject> out = duetoPAC.getDomainObjects();
                System.out.println("due to PAC: " + duetoPAC.getSource().getName() + " ::: " + out);
            }
            if ((duetoLHS2 = cpdata.getMorph2DueToLHS()) == null) continue;
            Vector<GraphObject> out = duetoLHS2.getDomainObjects();
            System.out.println("due to LHS2: " + duetoLHS2.getSource().getName() + " ::: " + out);
        }
    }
}

