/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraphObject;
import agg.gui.AGGAppl;
import agg.gui.editor.RuleEditor;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class RuleEditorMouseAdapter
extends MouseAdapter {
    private final RuleEditor editor;
    private EdGraphObject leftObj;
    private EdGraphObject rightObj;
    private EdGraphObject leftCondObj;
    private EdGraphObject graphObj;

    public RuleEditorMouseAdapter(RuleEditor ruleEditorImpl) {
        this.editor = ruleEditorImpl;
        this.editor.addMouseListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object source = e.getSource();
        if (this.editor.getApplFrame() == null) {
            return;
        }
        if (source == this.editor.getLeftPanel().getCanvas()) {
            AGGAppl.getInstance().setCursor(this.editor.getLeftPanel().getEditCursor());
        } else if (source == this.editor.getRightPanel().getCanvas()) {
            AGGAppl.getInstance().setCursor(this.editor.getLeftPanel().getEditCursor());
        } else if (source == this.editor.getNACPanel().getCanvas()) {
            AGGAppl.getInstance().setCursor(this.editor.getLeftPanel().getEditCursor());
        } else if (this.editor.getGraphEditor() != null && source == this.editor.getGraphEditor().getGraphPanel().getCanvas()) {
            AGGAppl.getInstance().setCursor(this.editor.getLeftPanel().getEditCursor());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        AGGAppl.getInstance().setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.editor.getRule() == null || !this.editor.getRule().isEditable()) {
            return;
        }
        Object source = e.getSource();
        if (this.editor.setActivePanel(source) == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
            if (this.editor.isEditPopupMenuShown() && this.editor.getEditPopupMenu().isMapping() || this.editor.isEditSelPopupMenuShown() && this.editor.getEditSelPopupMenu().isMapping()) {
                this.editor.resetEditModeAfterMapping();
            }
            if (this.editor.getActivePanel().getCanvas().isLeftPressed()) {
                this.editor.allowToShowPopupMenu(false);
            }
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            if (this.editor.getActivePanel().getCanvas().getPickedObject(e.getX(), e.getY(), this.editor.getGraphics().getFontMetrics()) != null) {
                AGGAppl.getInstance().setCursor(new Cursor(13));
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.editor.getActivePanel().getCanvas().isRightPressed()) {
                this.editor.allowToShowPopupMenu(false);
            }
            switch (this.editor.getLeftPanel().getEditMode()) {
                case 13: {
                    EdGraphObject ego = this.editor.getActivePanel().getGraph().getPicked(x, y);
                    this.editor.setMoveCursorWhenLoop(ego);
                    break;
                }
                case 32: {
                    if (source != this.editor.getLeftPanel().getCanvas()) break;
                    this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                    if (this.editor.removeRuleMapping(this.leftObj, true)) {
                        this.editor.getLeftPanel().updateGraphics();
                        this.editor.getRightPanel().updateGraphics();
                    }
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    break;
                }
                case 82: {
                    if (this.editor.getNAC() == null || source != this.editor.getLeftPanel().getCanvas()) break;
                    this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                    if (this.editor.removeNacMapping(this.leftObj, true)) {
                        this.editor.getLeftPanel().updateGraphics();
                        this.editor.getNACPanel().updateGraphics();
                    }
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    break;
                }
                case 802: {
                    if (this.editor.getPAC() == null || source != this.editor.getLeftPanel().getCanvas()) break;
                    this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                    if (this.editor.removePacMapping(this.leftObj, true)) {
                        this.editor.getLeftPanel().updateGraphics();
                        this.editor.getNACPanel().updateGraphics();
                    }
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    break;
                }
                case 8020: {
                    if (this.editor.getNestedAC() == null || source != this.editor.getLeftPanel().getCanvas()) break;
                    this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                    if (this.editor.removeNestedACMapping(this.leftObj, true)) {
                        this.editor.getLeftPanel().updateGraphics();
                        this.editor.getLeftCondPanel().updateGraphics();
                    }
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    break;
                }
                case 42: {
                    if (this.editor.getGraphEditor() == null) break;
                    if (source == this.editor.getLeftPanel().getCanvas()) {
                        if (this.leftObj != null) {
                            this.leftObj.setWeakselected(false);
                        }
                        this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                        if (this.leftObj == null) {
                            this.graphObj = this.editor.setHostGraphObject(null);
                        } else {
                            this.leftObj.setWeakselected(true);
                        }
                    } else if (source == this.editor.getGraphEditor().getGraphPanel().getCanvas() && this.leftObj != null) {
                        this.leftObj.setWeakselected(false);
                        this.graphObj = this.editor.setHostGraphObject(this.editor.getGraphEditor().getGraph().getPicked(x, y));
                        if (this.graphObj == null) {
                            this.leftObj = this.editor.setLeftGraphObject(null);
                        }
                    }
                    if (this.leftObj != null && this.graphObj != null) {
                        if (this.editor.setMatchMapping(this.leftObj, this.graphObj)) {
                            this.editor.getLeftPanel().updateGraphics();
                            this.editor.getGraphEditor().getGraphPanel().updateGraphics();
                        }
                        this.leftObj = this.editor.setLeftGraphObject(null);
                        this.graphObj = this.editor.setHostGraphObject(null);
                    }
                    this.editor.getLeftPanel().updateGraphics();
                    break;
                }
                case 43: {
                    if (this.editor.getGraphEditor() == null || source != this.editor.getLeftPanel().getCanvas()) break;
                    this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                    if (this.editor.removeMatchMapping(this.leftObj, true)) {
                        this.editor.getLeftPanel().updateGraphics();
                        this.editor.getGraphEditor().getGraphPanel().updateGraphics();
                    }
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    break;
                }
                case 115: {
                    if (this.editor.isEditPopupMenuShown() && this.editor.getEditPopupMenu().isMapping()) {
                        this.leftObj = this.editor.setLeftGraphObject(this.editor.getEditPopupMenu().getPickedObj());
                    }
                    if (this.leftObj != null) {
                        this.leftObj.setWeakselected(false);
                    }
                    if (source == this.editor.getLeftPanel().getCanvas()) {
                        if (this.editor.isEditPopupMenuShown() && this.editor.getEditPopupMenu().isMapping()) {
                            this.editor.setObjMapping(false);
                            this.leftObj = this.editor.setLeftGraphObject(null);
                        } else {
                            this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                            if (this.leftObj == null) {
                                this.editor.setObjMapping(false);
                            } else if (this.leftObj.isSelected()) {
                                this.editor.setEditMode(117);
                                if (this.editor.getGraphEditor() != null) {
                                    this.editor.getGraphEditor().setEditMode(117);
                                }
                            } else {
                                this.leftObj.setWeakselected(true);
                            }
                        }
                        if (this.editor.isEditPopupMenuShown() && this.editor.getEditPopupMenu().isMapping() && !this.editor.isObjMapping()) {
                            this.editor.resetEditModeAfterMapping();
                        }
                        this.editor.getLeftPanel().updateGraphics();
                        break;
                    }
                    if (source == this.editor.getRightPanel().getCanvas() && this.editor.getRightPanel().getEditMode() == 115) {
                        this.rightObj = this.editor.setRightGraphObject(this.editor.getRightPanel().getGraph().getPicked(x, y));
                        this.editor.setMappingRule(this.leftObj, this.rightObj);
                        this.rightObj = this.editor.setRightGraphObject(null);
                        this.leftObj = this.editor.setLeftGraphObject(null);
                        this.editor.getRightPanel().getCanvas().setPickedObject(null);
                        break;
                    }
                    if (source == this.editor.getLeftCondPanel().getCanvas() && this.editor.getLeftCondPanel().getGraph() != null && this.editor.getLeftCondPanel().getEditMode() == 115) {
                        this.leftCondObj = this.editor.setLeftCondGraphObject(this.editor.getLeftCondPanel().getGraph().getPicked(x, y));
                        this.editor.setMappingApplCond(this.leftObj, this.leftCondObj);
                        this.leftCondObj = this.editor.setLeftCondGraphObject(null);
                        this.leftObj = this.editor.setLeftGraphObject(null);
                        this.editor.getLeftCondPanel().getCanvas().setPickedObject(null);
                        break;
                    }
                    if (this.editor.getRule() instanceof EdAtomic || this.editor.getGraphEditor() == null || source != this.editor.getGraphEditor().getGraphPanel().getCanvas() || this.editor.getGraphEditor().getGraph().isTypeGraph() || this.editor.getGraphEditor().getGraphPanel().getEditMode() != 115) break;
                    this.graphObj = this.editor.setHostGraphObject(this.editor.getGraphEditor().getGraph().getPicked(x, y));
                    this.editor.setMappingGraph(this.leftObj, this.graphObj);
                    this.graphObj = this.editor.setHostGraphObject(null);
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    this.editor.getGraphEditor().getGraphPanel().getCanvas().setPickedObject(null);
                    break;
                }
                case 116: {
                    if (source == this.editor.getLeftPanel().getCanvas()) {
                        this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                        this.editor.removeMappingLeft(this.leftObj);
                        this.leftObj = this.editor.setLeftGraphObject(null);
                        break;
                    }
                    if (source == this.editor.getRightPanel().getCanvas()) {
                        this.rightObj = this.editor.setRightGraphObject(this.editor.getRightPanel().getGraph().getPicked(x, y));
                        this.editor.removeMappingRight(this.rightObj);
                        this.rightObj = this.editor.setRightGraphObject(null);
                        break;
                    }
                    if (source == this.editor.getLeftCondPanel().getCanvas()) {
                        this.leftCondObj = this.editor.setLeftCondGraphObject(this.editor.getLeftCondPanel().getGraph().getPicked(x, y));
                        this.editor.removeMappingApplCond(this.leftCondObj);
                        this.leftCondObj = this.editor.setLeftCondGraphObject(null);
                        break;
                    }
                    if (this.editor.getGraphEditor() == null || source != this.editor.getGraphEditor().getGraphPanel().getCanvas()) break;
                    this.graphObj = this.editor.setHostGraphObject(this.editor.getGraphEditor().getGraph().getPicked(x, y));
                    this.editor.removeMappingGraph(this.graphObj);
                    this.graphObj = this.editor.setHostGraphObject(null);
                    break;
                }
                case 1161: 
                case 1181: {
                    if (source != this.editor.getLeftPanel().getCanvas()) break;
                    this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                    this.editor.removeMappingLeft(this.leftObj);
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    break;
                }
                case 117: {
                    this.leftObj = this.editor.setLeftGraphObject(null);
                    if (source == this.editor.getLeftPanel().getCanvas()) {
                        if (this.editor.isEditSelPopupMenuShown() && this.editor.getEditSelPopupMenu().isMapping()) break;
                        this.leftObj = this.editor.setLeftGraphObject(this.editor.getLeftPanel().getGraph().getPicked(x, y));
                        if (this.leftObj == null || this.leftObj.isSelected()) break;
                        this.editor.setEditMode(115);
                        if (this.editor.getGraphEditor() == null) break;
                        this.editor.getGraphEditor().setEditMode(115);
                        break;
                    }
                    if (source == this.editor.getRightPanel().getCanvas()) {
                        this.rightObj = this.editor.setRightGraphObject(this.editor.getRightPanel().getGraph().getPicked(x, y));
                        this.editor.setMappingRule(this.editor.getRule().getLeft().getSelectedObjs(), this.rightObj);
                        this.rightObj = this.editor.setRightGraphObject(null);
                        break;
                    }
                    if (source == this.editor.getLeftCondPanel().getCanvas() && this.editor.getLeftCondPanel().getGraph() != null) {
                        if (this.editor.getNAC() == null && this.editor.getPAC() == null) break;
                        this.leftCondObj = this.editor.setLeftCondGraphObject(this.editor.getLeftCondPanel().getGraph().getPicked(x, y));
                        this.editor.setMappingApplCond(this.editor.getRule().getLeft().getSelectedObjs(), this.leftCondObj);
                        this.leftCondObj = this.editor.setLeftCondGraphObject(null);
                        break;
                    }
                    if (this.editor.getRule() instanceof EdAtomic || this.editor.getGraphEditor() == null || source != this.editor.getGraphEditor().getGraphPanel().getCanvas() || this.editor.getGraphEditor().getGraph().isTypeGraph()) break;
                    this.graphObj = this.editor.setHostGraphObject(this.editor.getGraphEditor().getGraphPanel().getGraph().getPicked(x, y));
                    this.editor.setMappingGraph(this.editor.getRule().getLeft().getSelectedObjs(), this.graphObj);
                    this.graphObj = this.editor.setHostGraphObject(null);
                    break;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.editor.getRule() == null || !this.editor.getRule().isEditable()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.editor.isEditPopupMenuShown() && this.editor.getEditPopupMenu().isMapping() || this.editor.isEditSelPopupMenuShown() && this.editor.getEditSelPopupMenu().isMapping()) {
                this.editor.resetEditModeAfterMapping();
            }
            if (this.editor.getGraGra() != null && this.editor.getGraGra().getGraph().isEditable() && e.getX() > 0 && e.getY() > 0 && this.editor.isPopupMenuAllowed()) {
                this.editor.showPopupMenu(e);
            }
            this.editor.allowToShowPopupMenu(true);
            this.editor.getActivePanel().getCanvas().unsetLeftAndRightPressed();
            return;
        }
        if (!this.editor.getActivePanel().getCanvas().isRightPressed()) {
            this.editor.getActivePanel().getCanvas().setLeftPressed(false);
        }
        switch (this.editor.getActivePanel().getEditMode()) {
            case 113: {
                this.editor.setMsg("You have just picked the source of an edge. Click on a node to get the target.");
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                AGGAppl.getInstance().setCursor(new Cursor(13));
                break;
            }
            case 151: {
                AGGAppl.getInstance().setCursor(new Cursor(1));
                break;
            }
            case 15: {
                break;
            }
            default: {
                AGGAppl.getInstance().setCursor(this.editor.getActivePanel().getEditCursor());
            }
        }
        this.editor.unsetDragging();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

