/*
 * Decompiled with CFR 0.152.
 */
package agg.layout;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleGraph;

public class ZestGraphLayout {
    EdGraph edgraph;
    Dimension dimension;
    Hashtable<EdNode, LayoutEntity> ednode2node = new Hashtable();
    Hashtable<EdArc, LayoutRelationship> edarc2arc = new Hashtable();
    List<EdNode> ednodes = new Vector<EdNode>();
    List<EdArc> edarcs = new Vector<EdArc>();
    Dimension averNodeSize = new Dimension(500, 500);
    SimpleGraph simplegraph;
    LayoutAlgorithm algorithm;
    String algorithmName;
    Hashtable<String, LayoutAlgorithm> name2algorithm = new Hashtable();
    private static final ArrayList<LayoutAlgorithm> algorithms = new ArrayList();
    public static final ArrayList<String> algorithmNames;

    static {
        algorithms.add((LayoutAlgorithm)new SpringLayoutAlgorithm(1));
        algorithms.add((LayoutAlgorithm)new TreeLayoutAlgorithm(1));
        algorithms.add((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1));
        algorithms.add((LayoutAlgorithm)new RadialLayoutAlgorithm(1));
        algorithms.add((LayoutAlgorithm)new GridLayoutAlgorithm(1));
        algorithms.add((LayoutAlgorithm)new HorizontalLayoutAlgorithm(1));
        algorithms.add((LayoutAlgorithm)new VerticalLayoutAlgorithm(1));
        algorithmNames = new ArrayList();
        algorithmNames.add("Spring");
        algorithmNames.add("Tree (vertical)");
        algorithmNames.add("Tree (horizontal)");
        algorithmNames.add("Radial");
        algorithmNames.add("Grid");
        algorithmNames.add("Horizontal");
        algorithmNames.add("Vertical");
    }

    public ZestGraphLayout() {
        int i = 0;
        while (i < algorithmNames.size()) {
            this.name2algorithm.put(algorithmNames.get(i), algorithms.get(i));
            ++i;
        }
    }

    public ZestGraphLayout(EdGraph graph) {
        this();
        this.edgraph = graph;
    }

    public ZestGraphLayout(EdGraph graph, String algorithmname) {
        this();
        this.edgraph = graph;
        this.setAlgorithm(algorithmname);
    }

    public void start() {
        this.applyLayout();
    }

    public void setGraph(EdGraph graph) {
        this.edgraph = graph;
    }

    public void setGraphDimension(Dimension dim) {
        this.dimension = dim;
    }

    public void setAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
        this.algorithm = this.name2algorithm.get(algorithmName);
        if (this.algorithm instanceof SpringLayoutAlgorithm) {
            ((SpringLayoutAlgorithm)this.algorithm).setIterations(1000);
            ((SpringLayoutAlgorithm)this.algorithm).setRandom(true);
            ((SpringLayoutAlgorithm)this.algorithm).setSpringGravitation(1.0E-4);
        } else if (this.algorithm instanceof TreeLayoutAlgorithm) {
            ((TreeLayoutAlgorithm)this.algorithm).setComparator(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof Comparable && o2 instanceof Comparable) {
                        return ((Comparable)o1).compareTo(o2);
                    }
                    return 0;
                }
            });
        } else if (this.algorithm instanceof GridLayoutAlgorithm) {
            ((GridLayoutAlgorithm)this.algorithm).setRowPadding(20);
        }
    }

    public boolean applyLayout() {
        if (this.edgraph == null) {
            return false;
        }
        this.setGraphLayoutData();
        List entitiesList = this.simplegraph.getEntities();
        LayoutEntity[] entities = new LayoutEntity[entitiesList.size()];
        entitiesList.toArray(entities);
        List relationshipList = this.simplegraph.getRelationships();
        LayoutRelationship[] relationships = new LayoutRelationship[relationshipList.size()];
        relationshipList.toArray(relationships);
        try {
            this.algorithm.applyLayout(entities, relationships, 15.0, 15.0, (double)this.dimension.width, (double)this.dimension.height, false, false);
        }
        catch (InvalidLayoutConfiguration e) {
            System.out.println(e.getLocalizedMessage());
            return false;
        }
        this.convertFromSimpleGraph();
        this.unsetGraphLayoutData();
        return true;
    }

    private void setGraphLayoutData() {
        this.simplegraph = new SimpleGraph();
        this.ednodes.clear();
        this.edarcs.clear();
        this.ednodes.addAll(this.edgraph.getVisibleNodes());
        this.edarcs.addAll(this.edgraph.getArcs());
        int i = 0;
        while (i < this.ednodes.size()) {
            EdNode ednode = this.ednodes.get(i);
            LayoutEntity node = this.simplegraph.addObjectNode((Object)ednode);
            node.setLocationInLayout((double)ednode.getX(), (double)ednode.getY());
            node.setSizeInLayout((double)ednode.getWidth(), (double)ednode.getHeight());
            this.ednode2node.put(ednode, node);
            ++i;
        }
        i = 0;
        while (i < this.edarcs.size()) {
            EdArc edarc = this.edarcs.get(i);
            EdNode src = (EdNode)edarc.getSource();
            EdNode tar = (EdNode)edarc.getTarget();
            if (this.ednodes.contains(src) && this.ednodes.contains(tar)) {
                this.simplegraph.addObjectRelationship((Object)src, (Object)tar, false, 1);
            }
            ++i;
        }
        this.averNodeSize.setSize(this.edgraph.getAverageNodeDim(this.ednodes));
        this.dimension = this.getNeededPanelSize(this.averNodeSize, this.ednodes.size(), this.algorithm);
    }

    private void unsetGraphLayoutData() {
        this.simplegraph = null;
        this.ednodes.clear();
        this.edarcs.clear();
        this.ednode2node.clear();
        this.dimension = null;
    }

    protected Dimension getNeededPanelSize(Dimension averagenodesize, int count, LayoutAlgorithm algorith) {
        int ans;
        int sizeX;
        if (averagenodesize.width < 25 || averagenodesize.height < 25) {
            averagenodesize.width = 25;
            averagenodesize.height = 25;
        }
        if ((sizeX = (ans = averagenodesize.width >= averagenodesize.height ? averagenodesize.width : averagenodesize.height) * count / 2) > 500 && sizeX < 1000) {
            sizeX = 1000;
        }
        int sizeY = sizeX * 3 / 4;
        if (this.algorithm instanceof HorizontalLayoutAlgorithm) {
            sizeX = (ans + 20) * count;
            sizeY = 400;
        } else if (this.algorithm instanceof VerticalLayoutAlgorithm) {
            sizeX = 400;
            sizeY = (ans + 20) * count;
        }
        Dimension dim = new Dimension(sizeX, sizeY);
        if (dim.width < 400 || dim.height < 400) {
            dim.width = 400;
            dim.height = 400;
        }
        return dim;
    }

    protected void convertFromSimpleGraph() {
        if (this.edgraph != null) {
            Enumeration<EdNode> list = this.ednode2node.keys();
            while (list.hasMoreElements()) {
                EdNode ednode = list.nextElement();
                LayoutEntity n = this.ednode2node.get(ednode);
                ednode.setX((int)n.getXInLayout());
                ednode.setY((int)n.getYInLayout());
            }
            this.edgraph.straightAllArcs();
        }
    }
}

