/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.SuperRowImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.SuperRow;
import me.prettyprint.hector.api.beans.SuperRows;
import org.apache.cassandra.thrift.SuperColumn;

public class SuperRowsImpl<K, SN, N, V>
implements SuperRows<K, SN, N, V> {
    private final Map<K, SuperRow<K, SN, N, V>> rows;
    Serializer<K> keySerializer;

    public SuperRowsImpl(Map<K, List<SuperColumn>> thriftRet, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(thriftRet, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
        this.keySerializer = keySerializer;
        this.rows = new HashMap<K, SuperRow<K, SN, N, V>>(thriftRet.size());
        for (Map.Entry<K, List<SuperColumn>> entry : thriftRet.entrySet()) {
            this.rows.put(entry.getKey(), new SuperRowImpl<K, SN, N, V>(entry.getKey(), entry.getValue(), sNameSerializer, nameSerializer, valueSerializer));
        }
    }

    @Override
    public SuperRow<K, SN, N, V> getByKey(K key) {
        return this.rows.get(key);
    }

    @Override
    public int getCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<SuperRow<K, SN, N, V>> iterator() {
        return this.rows.values().iterator();
    }

    public String toString() {
        return "SuperRows(" + this.rows + ")";
    }
}

