/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.model.HSuperColumnImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HSuperColumn;
import me.prettyprint.hector.api.beans.SuperSlice;
import org.apache.cassandra.thrift.SuperColumn;

public final class SuperSliceImpl<SN, N, V>
implements SuperSlice<SN, N, V> {
    private final Map<SN, HSuperColumn<SN, N, V>> columnsMap;
    private final List<HSuperColumn<SN, N, V>> columnsList;

    public SuperSliceImpl(List<SuperColumn> tSuperColumns, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(tSuperColumns, sNameSerializer, nameSerializer, valueSerializer);
        this.columnsMap = new HashMap<SN, HSuperColumn<SN, N, V>>(tSuperColumns.size());
        this.columnsList = new ArrayList<HSuperColumn<SN, N, V>>(tSuperColumns.size());
        for (SuperColumn sc : tSuperColumns) {
            HSuperColumnImpl<SN, N, V> column = new HSuperColumnImpl<SN, N, V>(sc, sNameSerializer, nameSerializer, valueSerializer);
            this.columnsMap.put(column.getName(), column);
            this.columnsList.add(column);
        }
    }

    @Override
    public List<HSuperColumn<SN, N, V>> getSuperColumns() {
        return Collections.unmodifiableList(this.columnsList);
    }

    @Override
    public HSuperColumn<SN, N, V> getColumnByName(SN columnName) {
        return this.columnsMap.get(columnName);
    }

    public String toString() {
        return "SuperSlice(" + this.columnsList.toString() + ")";
    }
}

