/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.AbstractSerializer;

public final class LongSerializer
extends AbstractSerializer<Long> {
    private static final LongSerializer instance = new LongSerializer();

    public static LongSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Long obj) {
        if (obj == null) {
            return null;
        }
        long l = obj;
        int size = 8;
        ByteBuffer b = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            b.put(i, (byte)(l >> (size - i - 1 << 3)));
        }
        return b;
    }

    @Override
    public Long fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasArray()) {
            return null;
        }
        long l = 0L;
        int size = byteBuffer.capacity();
        for (int i = 0; i < size; ++i) {
            l |= ((long)byteBuffer.get(i) & 0xFFL) << (size - i - 1 << 3);
        }
        return l;
    }
}

