/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.service.AbstractCluster;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.cassandra.service.ThriftKsDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.TokenRange;

public class ThriftCluster
extends AbstractCluster
implements Cluster {
    public ThriftCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator) {
        super(clusterName, cassandraHostConfigurator);
    }

    public ThriftCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator, Map<String, String> credentials) {
        super(clusterName, cassandraHostConfigurator, credentials);
    }

    public List<TokenRange> describeRing(final String keyspace) throws HectorException {
        Operation<List<TokenRange>> op = new Operation<List<TokenRange>>(OperationType.META_READ, this.getCredentials()){

            @Override
            public List<TokenRange> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.describe_ring(keyspace);
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public String updateKeyspace(final KeyspaceDefinition ksdef) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.system_update_keyspace(((ThriftKsDef)ksdef).toThrift());
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String addColumnFamily(final ColumnFamilyDefinition cfdef) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE, cfdef.getKeyspaceName(), this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.system_add_column_family(((ThriftCfDef)cfdef).toThrift());
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String updateColumnFamily(final ColumnFamilyDefinition cfdef) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE, cfdef.getKeyspaceName(), this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.system_update_column_family(((ThriftCfDef)cfdef).toThrift());
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String addKeyspace(final KeyspaceDefinition ksdef) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.system_add_keyspace(((ThriftKsDef)ksdef).toThrift());
                }
                catch (Exception e) {
                    throw ThriftCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }
}

