/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.AvroRemoteException;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.avro.AuthenticationException;
import org.apache.cassandra.avro.AuthenticationRequest;
import org.apache.cassandra.avro.AuthorizationException;
import org.apache.cassandra.avro.AvroRecordFactory;
import org.apache.cassandra.avro.AvroValidation;
import org.apache.cassandra.avro.Cassandra;
import org.apache.cassandra.avro.CfDef;
import org.apache.cassandra.avro.Column;
import org.apache.cassandra.avro.ColumnOrSuperColumn;
import org.apache.cassandra.avro.ColumnParent;
import org.apache.cassandra.avro.ColumnPath;
import org.apache.cassandra.avro.ConsistencyLevel;
import org.apache.cassandra.avro.CoscsMapEntry;
import org.apache.cassandra.avro.Deletion;
import org.apache.cassandra.avro.ErrorFactory;
import org.apache.cassandra.avro.IndexClause;
import org.apache.cassandra.avro.IndexExpression;
import org.apache.cassandra.avro.IndexOperator;
import org.apache.cassandra.avro.InvalidRequestException;
import org.apache.cassandra.avro.KeyCountMapEntry;
import org.apache.cassandra.avro.KeyRange;
import org.apache.cassandra.avro.KeySlice;
import org.apache.cassandra.avro.KsDef;
import org.apache.cassandra.avro.Mutation;
import org.apache.cassandra.avro.MutationsMapEntry;
import org.apache.cassandra.avro.NotFoundException;
import org.apache.cassandra.avro.SlicePredicate;
import org.apache.cassandra.avro.SliceRange;
import org.apache.cassandra.avro.SuperColumn;
import org.apache.cassandra.avro.TimedOutException;
import org.apache.cassandra.avro.TokenRange;
import org.apache.cassandra.avro.UnavailableException;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.migration.AddColumnFamily;
import org.apache.cassandra.db.migration.AddKeyspace;
import org.apache.cassandra.db.migration.DropColumnFamily;
import org.apache.cassandra.db.migration.DropKeyspace;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.UpdateColumnFamily;
import org.apache.cassandra.db.migration.UpdateKeyspace;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraServer
implements Cassandra {
    private static Logger logger = LoggerFactory.getLogger(CassandraServer.class);
    private static final GenericArray<Column> EMPTY_SUBCOLUMNS = new GenericData.Array(0, Schema.createArray((Schema)Column.SCHEMA$));
    private static final GenericArray<ColumnOrSuperColumn> EMPTY_COLUMNS = new GenericData.Array(0, Schema.createArray((Schema)ColumnOrSuperColumn.SCHEMA$));
    private static final Utf8 API_VERSION = new Utf8("0.0.0");
    private static final String D_CF_CFTYPE = "Standard";
    private static final String D_CF_CFCLOCKTYPE = "Timestamp";
    private static final String D_CF_COMPTYPE = "BytesType";
    private static final String D_CF_SUBCOMPTYPE = "";
    private static final String D_CF_RECONCILER = null;
    public static final String D_COLDEF_INDEXTYPE = "KEYS";
    public static final String D_COLDEF_INDEXNAME = null;
    public final ThreadLocal<ClientState> clientState = new ThreadLocal<ClientState>(){

        @Override
        public ClientState initialValue() {
            return new ClientState();
        }
    };
    private final IRequestScheduler requestScheduler = DatabaseDescriptor.getRequestScheduler();

    @Override
    public Void login(AuthenticationRequest auth_request) throws AuthenticationException, AuthorizationException {
        try {
            this.state().login(auth_request.credentials);
        }
        catch (org.apache.cassandra.thrift.AuthenticationException thriftE) {
            throw new AuthenticationException();
        }
        return null;
    }

    public ClientState state() {
        return this.clientState.get();
    }

    @Override
    public ColumnOrSuperColumn get(ByteBuffer key, ColumnPath columnPath, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, NotFoundException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("get");
        }
        AvroValidation.validateColumnPath(this.state().getKeyspace(), columnPath);
        ByteBuffer column = columnPath.column == null ? null : columnPath.column;
        ByteBuffer super_column = columnPath.super_column == null ? null : columnPath.super_column;
        QueryPath path = new QueryPath(((Object)columnPath.column_family).toString(), column == null ? null : super_column);
        List<ByteBuffer> nameAsList = Arrays.asList(column == null ? super_column : column);
        AvroValidation.validateKey(key);
        SliceByNamesReadCommand command = new SliceByNamesReadCommand(this.state().getKeyspace(), key, path, nameAsList);
        Map<DecoratedKey<?>, ColumnFamily> cfamilies = this.readColumnFamily(Arrays.asList(command), consistencyLevel);
        ColumnFamily cf = cfamilies.get(StorageService.getPartitioner().decorateKey(command.key));
        if (cf == null) {
            throw ErrorFactory.newNotFoundException();
        }
        GenericArray<ColumnOrSuperColumn> avroColumns = this.avronateColumnFamily(cf, command.queryPath.superColumnName != null, false);
        if (avroColumns.size() == 0) {
            throw ErrorFactory.newNotFoundException();
        }
        assert (avroColumns.size() == 1);
        return (ColumnOrSuperColumn)((Object)avroColumns.iterator().next());
    }

    protected Map<DecoratedKey<?>, ColumnFamily> readColumnFamily(List<ReadCommand> commands, ConsistencyLevel consistency) throws InvalidRequestException, UnavailableException, TimedOutException {
        List<Row> rows;
        HashMap columnFamilyKeyMap = new HashMap();
        try {
            this.schedule();
            rows = StorageProxy.readProtocol(commands, this.thriftConsistencyLevel(consistency));
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (org.apache.cassandra.thrift.UnavailableException e) {
            throw ErrorFactory.newUnavailableException(e);
        }
        catch (org.apache.cassandra.thrift.InvalidRequestException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
        finally {
            this.release();
        }
        for (Row row : rows) {
            columnFamilyKeyMap.put(row.key, row.cf);
        }
        return columnFamilyKeyMap;
    }

    private List<Column> avronateSubColumns(Collection<IColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return EMPTY_SUBCOLUMNS;
        }
        ArrayList<Column> avroColumns = new ArrayList<Column>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column avroColumn = AvroRecordFactory.newColumn(column.name(), column.value(), column.timestamp());
            avroColumns.add(avroColumn);
        }
        return avroColumns;
    }

    private GenericArray<ColumnOrSuperColumn> avronateColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> avroColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column avroColumn = AvroRecordFactory.newColumn(column.name(), column.value(), column.timestamp());
            if (column instanceof ExpiringColumn) {
                avroColumn.ttl = ((ExpiringColumn)column).getTimeToLive();
            }
            avroColumns.add(AvroRecordFactory.newColumnOrSuperColumn(avroColumn));
        }
        if (reverseOrder) {
            Collections.reverse(avroColumns);
        }
        GenericData.Array avroArray = new GenericData.Array(avroColumns.size(), Schema.createArray((Schema)ColumnOrSuperColumn.SCHEMA$));
        for (ColumnOrSuperColumn cosc : avroColumns) {
            avroArray.add((Object)cosc);
        }
        return avroArray;
    }

    private GenericArray<ColumnOrSuperColumn> avronateSuperColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> avroSuperColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            List<Column> subColumns = this.avronateSubColumns(column.getSubColumns());
            if (subColumns.size() == 0) continue;
            SuperColumn superColumn = AvroRecordFactory.newSuperColumn(column.name(), subColumns);
            avroSuperColumns.add(AvroRecordFactory.newColumnOrSuperColumn(superColumn));
        }
        if (reverseOrder) {
            Collections.reverse(avroSuperColumns);
        }
        GenericData.Array avroArray = new GenericData.Array(avroSuperColumns.size(), Schema.createArray((Schema)ColumnOrSuperColumn.SCHEMA$));
        for (ColumnOrSuperColumn cosc : avroSuperColumns) {
            avroArray.add((Object)cosc);
        }
        return avroArray;
    }

    private GenericArray<ColumnOrSuperColumn> avronateColumnFamily(ColumnFamily cf, boolean subColumnsOnly, boolean reverseOrder) {
        if (cf == null || cf.getColumnsMap().size() == 0) {
            return EMPTY_COLUMNS;
        }
        if (subColumnsOnly) {
            IColumn column = cf.getColumnsMap().values().iterator().next();
            Collection<IColumn> subColumns = column.getSubColumns();
            if (subColumns == null || subColumns.isEmpty()) {
                return EMPTY_COLUMNS;
            }
            return this.avronateColumns(subColumns, reverseOrder);
        }
        if (cf.isSuper()) {
            return this.avronateSuperColumns(cf.getSortedColumns(), reverseOrder);
        }
        return this.avronateColumns(cf.getSortedColumns(), reverseOrder);
    }

    @Override
    public List<ColumnOrSuperColumn> get_slice(ByteBuffer key, ColumnParent columnParent, SlicePredicate predicate, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("get_slice");
        }
        Schema bytesArray = Schema.createArray((Schema)Schema.parse((String)"{\"type\": \"bytes\"}"));
        GenericData.Array keys = new GenericData.Array(1, bytesArray);
        keys.add((Object)key);
        return this.multigetSliceInternal((String)this.state().getKeyspace(), (List<ByteBuffer>)keys, (ColumnParent)columnParent, (SlicePredicate)predicate, (ConsistencyLevel)consistencyLevel).iterator().next().columns;
    }

    private List<CoscsMapEntry> multigetSliceInternal(String keyspace, List<ByteBuffer> keys, ColumnParent columnParent, SlicePredicate predicate, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException {
        AvroValidation.validateColumnParent(keyspace, columnParent);
        AvroValidation.validatePredicate(keyspace, columnParent, predicate);
        QueryPath queryPath = new QueryPath(((Object)columnParent.column_family).toString(), columnParent.super_column);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        if (predicate.column_names != null) {
            for (ByteBuffer key : keys) {
                AvroValidation.validateKey(key);
                commands.add(new SliceByNamesReadCommand(keyspace, key, queryPath, predicate.column_names));
            }
        } else {
            SliceRange range = predicate.slice_range;
            for (ByteBuffer key : keys) {
                AvroValidation.validateKey(key);
                commands.add(new SliceFromReadCommand(keyspace, key, queryPath, range.start, range.finish, range.reversed, range.count));
            }
        }
        return this.getSlice(commands, consistencyLevel);
    }

    private List<CoscsMapEntry> getSlice(List<ReadCommand> commands, ConsistencyLevel consistencyLevel) throws InvalidRequestException, UnavailableException, TimedOutException {
        Map<DecoratedKey<?>, ColumnFamily> columnFamilies = this.readColumnFamily(commands, consistencyLevel);
        Schema sch = Schema.createArray((Schema)CoscsMapEntry.SCHEMA$);
        GenericData.Array columnFamiliesList = new GenericData.Array(commands.size(), sch);
        for (ReadCommand cmd : commands) {
            ColumnFamily cf = columnFamilies.get(StorageService.getPartitioner().decorateKey(cmd.key));
            boolean reverseOrder = cmd instanceof SliceFromReadCommand && ((SliceFromReadCommand)cmd).reversed;
            GenericArray<ColumnOrSuperColumn> avroColumns = this.avronateColumnFamily(cf, cmd.queryPath.superColumnName != null, reverseOrder);
            columnFamiliesList.add(AvroRecordFactory.newCoscsMapEntry(cmd.key, avroColumns));
        }
        return columnFamiliesList;
    }

    @Override
    public int get_count(ByteBuffer key, ColumnParent columnParent, SlicePredicate predicate, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("get_count");
        }
        return this.get_slice(key, columnParent, predicate, consistencyLevel).size();
    }

    @Override
    public List<CoscsMapEntry> multiget_slice(List<ByteBuffer> keys, ColumnParent columnParent, SlicePredicate predicate, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("multiget_slice");
        }
        return this.multigetSliceInternal(this.state().getKeyspace(), keys, columnParent, predicate, consistencyLevel);
    }

    @Override
    public Void insert(ByteBuffer key, ColumnParent parent, Column column, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("insert");
        }
        AvroValidation.validateKey(key);
        AvroValidation.validateColumnParent(this.state().getKeyspace(), parent);
        AvroValidation.validateColumn(this.state().getKeyspace(), parent, column);
        RowMutation rm = new RowMutation(this.state().getKeyspace(), key);
        try {
            rm.add(new QueryPath(((Object)parent.column_family).toString(), parent.super_column, column.name), column.value, column.timestamp, column.ttl == null ? 0 : column.ttl);
        }
        catch (MarshalException e) {
            throw ErrorFactory.newInvalidRequestException(e.getMessage());
        }
        this.doInsert(consistencyLevel, rm);
        return null;
    }

    @Override
    public Void remove(ByteBuffer key, ColumnPath columnPath, long timestamp, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("remove");
        }
        AvroValidation.validateKey(key);
        AvroValidation.validateColumnPath(this.state().getKeyspace(), columnPath);
        RowMutation rm = new RowMutation(this.state().getKeyspace(), key);
        rm.delete(new QueryPath(((Object)columnPath.column_family).toString(), columnPath.super_column), timestamp);
        this.doInsert(consistencyLevel, rm);
        return null;
    }

    private void doInsert(ConsistencyLevel consistency, RowMutation rm) throws UnavailableException, TimedOutException {
        try {
            this.schedule();
            StorageProxy.mutate(Arrays.asList(rm), this.thriftConsistencyLevel(consistency));
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (org.apache.cassandra.thrift.UnavailableException thriftE) {
            throw ErrorFactory.newUnavailableException(thriftE);
        }
        finally {
            this.release();
        }
    }

    @Override
    public Void batch_mutate(List<MutationsMapEntry> mutationMap, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("batch_mutate");
        }
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>();
        for (MutationsMapEntry pair : mutationMap) {
            AvroValidation.validateKey(pair.key);
            Map<CharSequence, List<Mutation>> cfToMutations = pair.mutations;
            for (Map.Entry<CharSequence, List<Mutation>> cfMutations : cfToMutations.entrySet()) {
                String cfName = ((Object)cfMutations.getKey()).toString();
                for (Mutation mutation : cfMutations.getValue()) {
                    AvroValidation.validateMutation(this.state().getKeyspace(), cfName, mutation);
                }
            }
            rowMutations.add(CassandraServer.getRowMutationFromMutations(this.state().getKeyspace(), pair.key, cfToMutations));
        }
        try {
            this.schedule();
            StorageProxy.mutate(rowMutations, this.thriftConsistencyLevel(consistencyLevel));
        }
        catch (TimeoutException te) {
            throw ErrorFactory.newTimedOutException();
        }
        catch (org.apache.cassandra.thrift.UnavailableException ue) {
            throw ErrorFactory.newUnavailableException();
        }
        finally {
            this.release();
        }
        return null;
    }

    private static RowMutation getRowMutationFromMutations(String keyspace, ByteBuffer key, Map<CharSequence, List<Mutation>> cfMap) {
        RowMutation rm = new RowMutation(keyspace, key);
        for (Map.Entry<CharSequence, List<Mutation>> entry : cfMap.entrySet()) {
            String cfName = ((Object)entry.getKey()).toString();
            for (Mutation mutation : entry.getValue()) {
                if (mutation.deletion != null) {
                    CassandraServer.deleteColumnOrSuperColumnToRowMutation(rm, cfName, mutation.deletion);
                    continue;
                }
                CassandraServer.addColumnOrSuperColumnToRowMutation(rm, cfName, mutation.column_or_supercolumn);
            }
        }
        return rm;
    }

    private static void addColumnOrSuperColumnToRowMutation(RowMutation rm, String cfName, ColumnOrSuperColumn cosc) {
        if (cosc.column == null) {
            for (Column column : cosc.super_column.columns) {
                rm.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp);
            }
        } else {
            rm.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp);
        }
    }

    private static void deleteColumnOrSuperColumnToRowMutation(RowMutation rm, String cfName, Deletion del) {
        if (del.predicate != null && del.predicate.column_names != null) {
            for (ByteBuffer col : del.predicate.column_names) {
                if (del.super_column == null && DatabaseDescriptor.getColumnFamilyType(rm.getTable(), cfName) == ColumnFamilyType.Super) {
                    rm.delete(new QueryPath(cfName, col), del.timestamp);
                    continue;
                }
                rm.delete(new QueryPath(cfName, del.super_column, col), del.timestamp);
            }
        } else {
            rm.delete(new QueryPath(cfName, del.super_column), del.timestamp);
        }
    }

    private static void applyMigrationOnStage(final Migration m) throws InvalidRequestException {
        Future f = StageManager.getStage(Stage.MIGRATION).submit(new Callable(){

            public Object call() throws Exception {
                m.apply();
                m.announce();
                return null;
            }
        });
        try {
            f.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                throw ErrorFactory.newInvalidRequestException(e.getCause());
            }
            throw ErrorFactory.newInvalidRequestException(e);
        }
    }

    private org.apache.cassandra.thrift.ConsistencyLevel thriftConsistencyLevel(ConsistencyLevel consistency) {
        switch (consistency) {
            case ONE: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ONE;
            }
            case QUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.QUORUM;
            }
            case LOCAL_QUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.LOCAL_QUORUM;
            }
            case EACH_QUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.EACH_QUORUM;
            }
            case ALL: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ALL;
            }
        }
        return null;
    }

    @Override
    public Void set_keyspace(CharSequence keyspace) throws InvalidRequestException {
        String keyspaceStr = ((Object)keyspace).toString();
        if (DatabaseDescriptor.getTableDefinition(keyspaceStr) == null) {
            throw ErrorFactory.newInvalidRequestException("Keyspace does not exist");
        }
        this.state().setKeyspace(keyspaceStr);
        return null;
    }

    @Override
    public CharSequence system_add_keyspace(KsDef ksDef) throws AvroRemoteException, InvalidRequestException {
        if (!(DatabaseDescriptor.getAuthenticator() instanceof AllowAllAuthenticator)) {
            throw ErrorFactory.newInvalidRequestException("Unable to create new keyspace while authentication is enabled.");
        }
        for (CfDef cf : ksDef.cf_defs) {
            if (cf.keyspace.equals(ksDef.name)) continue;
            throw ErrorFactory.newInvalidRequestException("CsDef (" + cf.name + ") had a keyspace definition that did not match KsDef");
        }
        try {
            ArrayList<CFMetaData> cfDefs = new ArrayList<CFMetaData>(ksDef.cf_defs.size());
            for (CfDef cfDef : ksDef.cf_defs) {
                cfDefs.add(this.convertToCFMetaData(cfDef));
            }
            HashMap<String, String> strategyOptions = null;
            if (ksDef.strategy_options != null && !ksDef.strategy_options.isEmpty()) {
                strategyOptions = new HashMap<String, String>();
                for (Map.Entry<CharSequence, CharSequence> option : ksDef.strategy_options.entrySet()) {
                    strategyOptions.put(((Object)option.getKey()).toString(), ((Object)option.getValue()).toString());
                }
            }
            KSMetaData ksmeta = new KSMetaData(((Object)ksDef.name).toString(), AbstractReplicationStrategy.getClass(((Object)ksDef.strategy_class).toString()), strategyOptions, ksDef.replication_factor, cfDefs.toArray(new CFMetaData[cfDefs.size()]));
            CassandraServer.applyMigrationOnStage(new AddKeyspace(ksmeta));
            return DatabaseDescriptor.getDefsVersion().toString();
        }
        catch (ConfigurationException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
        catch (IOException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
    }

    @Override
    public CharSequence system_add_column_family(CfDef cfDef) throws AvroRemoteException, InvalidRequestException {
        this.checkKeyspaceAndLoginAuthorized(Permission.WRITE);
        try {
            CassandraServer.applyMigrationOnStage(new AddColumnFamily(this.convertToCFMetaData(cfDef)));
            return DatabaseDescriptor.getDefsVersion().toString();
        }
        catch (ConfigurationException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
        catch (IOException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
    }

    @Override
    public CharSequence system_update_column_family(CfDef cf_def) throws AvroRemoteException, InvalidRequestException {
        this.checkKeyspaceAndLoginAuthorized(Permission.WRITE);
        if (cf_def.keyspace == null || cf_def.name == null) {
            throw ErrorFactory.newInvalidRequestException("Keyspace and CF name must be set.");
        }
        CFMetaData oldCfm = DatabaseDescriptor.getCFMetaData(CFMetaData.getId(((Object)cf_def.keyspace).toString(), ((Object)cf_def.name).toString()));
        if (oldCfm == null) {
            throw ErrorFactory.newInvalidRequestException("Could not find column family definition to modify.");
        }
        try {
            CFMetaData.applyImplicitDefaults(cf_def);
            UpdateColumnFamily update = new UpdateColumnFamily(cf_def);
            CassandraServer.applyMigrationOnStage(update);
            return DatabaseDescriptor.getDefsVersion().toString();
        }
        catch (ConfigurationException e) {
            InvalidRequestException ex = ErrorFactory.newInvalidRequestException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            InvalidRequestException ex = ErrorFactory.newInvalidRequestException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public CharSequence system_update_keyspace(KsDef ks_def) throws AvroRemoteException, InvalidRequestException {
        this.checkKeyspaceAndLoginAuthorized(Permission.WRITE);
        if (ks_def.cf_defs != null && ks_def.cf_defs.size() > 0) {
            throw ErrorFactory.newInvalidRequestException("Keyspace update must not contain any column family definitions.");
        }
        if (DatabaseDescriptor.getTableDefinition(((Object)ks_def.name).toString()) == null) {
            throw ErrorFactory.newInvalidRequestException("Keyspace does not exist.");
        }
        try {
            HashMap<String, String> strategyOptions = null;
            if (ks_def.strategy_options != null && !ks_def.strategy_options.isEmpty()) {
                strategyOptions = new HashMap<String, String>();
                for (Map.Entry<CharSequence, CharSequence> option : ks_def.strategy_options.entrySet()) {
                    strategyOptions.put(((Object)option.getKey()).toString(), ((Object)option.getValue()).toString());
                }
            }
            KSMetaData ksm = new KSMetaData(((Object)ks_def.name).toString(), AbstractReplicationStrategy.getClass(((Object)ks_def.strategy_class).toString()), strategyOptions, ks_def.replication_factor, new CFMetaData[0]);
            CassandraServer.applyMigrationOnStage(new UpdateKeyspace(ksm));
            return DatabaseDescriptor.getDefsVersion().toString();
        }
        catch (ConfigurationException e) {
            InvalidRequestException ex = ErrorFactory.newInvalidRequestException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            InvalidRequestException ex = ErrorFactory.newInvalidRequestException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public GenericArray<CharSequence> describe_keyspaces() throws AvroRemoteException {
        Set<String> keyspaces = DatabaseDescriptor.getTables();
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        GenericData.Array avroResults = new GenericData.Array(keyspaces.size(), schema);
        for (String ksp : keyspaces) {
            avroResults.add((Object)new Utf8(ksp));
        }
        return avroResults;
    }

    public Utf8 describe_cluster_name() throws AvroRemoteException {
        return new Utf8(DatabaseDescriptor.getClusterName());
    }

    public Utf8 describe_version() throws AvroRemoteException {
        return API_VERSION;
    }

    @Override
    public Map<CharSequence, List<CharSequence>> check_schema_agreement() {
        logger.debug("checking schema agreement");
        return StorageProxy.describeSchemaVersions();
    }

    protected void checkKeyspaceAndLoginAuthorized(Permission perm) throws InvalidRequestException {
        try {
            this.state().hasColumnFamilyListAccess(perm);
        }
        catch (org.apache.cassandra.thrift.InvalidRequestException e) {
            throw ErrorFactory.newInvalidRequestException(e.getWhy());
        }
    }

    private void schedule() {
        this.requestScheduler.queue(Thread.currentThread(), this.state().getSchedulingValue());
    }

    private void release() {
        this.requestScheduler.release();
    }

    private CFMetaData convertToCFMetaData(CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        String cfType = cf_def.column_type == null ? D_CF_CFTYPE : ((Object)cf_def.column_type).toString();
        String compare = cf_def.comparator_type == null ? D_CF_COMPTYPE : ((Object)cf_def.comparator_type).toString();
        String validate = cf_def.default_validation_class == null ? D_CF_COMPTYPE : ((Object)cf_def.default_validation_class).toString();
        String subCompare = cf_def.subcomparator_type == null ? D_CF_SUBCOMPTYPE : ((Object)cf_def.subcomparator_type).toString();
        CFMetaData.validateMinMaxCompactionThresholds(cf_def);
        CFMetaData.validateMemtableSettings(cf_def);
        return new CFMetaData(((Object)cf_def.keyspace).toString(), ((Object)cf_def.name).toString(), ColumnFamilyType.create(cfType), DatabaseDescriptor.getComparator(compare), subCompare.length() == 0 ? null : DatabaseDescriptor.getComparator(subCompare), cf_def.comment == null ? D_CF_SUBCOMPTYPE : ((Object)cf_def.comment).toString(), cf_def.row_cache_size == null ? 0.0 : cf_def.row_cache_size, cf_def.key_cache_size == null ? 200000.0 : cf_def.key_cache_size, cf_def.read_repair_chance == null ? 1.0 : cf_def.read_repair_chance, cf_def.gc_grace_seconds != null ? cf_def.gc_grace_seconds : 864000, DatabaseDescriptor.getComparator(validate), cf_def.min_compaction_threshold == null ? 4 : cf_def.min_compaction_threshold, cf_def.max_compaction_threshold == null ? 32 : cf_def.max_compaction_threshold, cf_def.row_cache_save_period_in_seconds == null ? 0 : cf_def.row_cache_save_period_in_seconds, cf_def.key_cache_save_period_in_seconds == null ? 3600 : cf_def.key_cache_save_period_in_seconds, cf_def.memtable_flush_after_mins == null ? 60 : cf_def.memtable_flush_after_mins, cf_def.memtable_throughput_in_mb == null ? CFMetaData.DEFAULT_MEMTABLE_THROUGHPUT_IN_MB : cf_def.memtable_throughput_in_mb, cf_def.memtable_operations_in_millions == null ? CFMetaData.DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS : cf_def.memtable_operations_in_millions, ColumnDefinition.fromColumnDefs(cf_def.column_metadata));
    }

    @Override
    public KsDef describe_keyspace(CharSequence keyspace) throws AvroRemoteException, NotFoundException {
        KSMetaData ksMetadata = DatabaseDescriptor.getTableDefinition(((Object)keyspace).toString());
        if (ksMetadata == null) {
            throw new NotFoundException();
        }
        KsDef ksDef = new KsDef();
        ksDef.name = keyspace;
        ksDef.replication_factor = ksMetadata.replicationFactor;
        ksDef.strategy_class = ksMetadata.strategyClass.getName();
        if (ksMetadata.strategyOptions != null) {
            ksDef.strategy_options = new HashMap<CharSequence, CharSequence>();
            ksDef.strategy_options.putAll(ksMetadata.strategyOptions);
        }
        GenericData.Array cfDefs = new GenericData.Array(ksMetadata.cfMetaData().size(), Schema.createArray((Schema)CfDef.SCHEMA$));
        for (CFMetaData cfm : ksMetadata.cfMetaData().values()) {
            cfDefs.add((Object)CFMetaData.convertToAvro(cfm));
        }
        ksDef.cf_defs = cfDefs;
        return ksDef;
    }

    @Override
    public CharSequence system_drop_column_family(CharSequence column_family) throws AvroRemoteException, InvalidRequestException {
        this.checkKeyspaceAndLoginAuthorized(Permission.WRITE);
        try {
            CassandraServer.applyMigrationOnStage(new DropColumnFamily(this.state().getKeyspace(), ((Object)column_family).toString()));
            return DatabaseDescriptor.getDefsVersion().toString();
        }
        catch (ConfigurationException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
        catch (IOException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
    }

    @Override
    public CharSequence system_drop_keyspace(CharSequence keyspace) throws AvroRemoteException, InvalidRequestException {
        if (!(DatabaseDescriptor.getAuthenticator() instanceof AllowAllAuthenticator)) {
            throw ErrorFactory.newInvalidRequestException("Unable to create new keyspace while authentication is enabled.");
        }
        try {
            CassandraServer.applyMigrationOnStage(new DropKeyspace(((Object)keyspace).toString()));
            return DatabaseDescriptor.getDefsVersion().toString();
        }
        catch (ConfigurationException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
        catch (IOException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
    }

    @Override
    public CharSequence describe_partitioner() throws AvroRemoteException {
        return StorageService.getPartitioner().getClass().getName();
    }

    @Override
    public List<CharSequence> describe_splits(CharSequence cfName, CharSequence start_token, CharSequence end_token, int keys_per_split) {
        Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
        List<Token> tokens = StorageService.instance.getSplits(this.state().getKeyspace(), ((Object)cfName).toString(), new Range(tf.fromString(((Object)start_token).toString()), tf.fromString(((Object)end_token).toString())), keys_per_split);
        ArrayList<CharSequence> splits = new ArrayList<CharSequence>(tokens.size());
        for (Token token : tokens) {
            splits.add(tf.toString(token));
        }
        return splits;
    }

    @Override
    public List<KeyCountMapEntry> multiget_count(List<ByteBuffer> keys, ColumnParent columnParent, SlicePredicate predicate, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug("multiget_count");
        }
        this.checkKeyspaceAndLoginAuthorized(Permission.READ);
        String keyspace = this.state().getKeyspace();
        ArrayList<KeyCountMapEntry> counts = new ArrayList<KeyCountMapEntry>();
        List<CoscsMapEntry> columnFamiliesMap = this.multigetSliceInternal(keyspace, keys, columnParent, predicate, consistencyLevel);
        for (CoscsMapEntry cf : columnFamiliesMap) {
            KeyCountMapEntry countEntry = new KeyCountMapEntry();
            countEntry.key = cf.key;
            countEntry.count = cf.columns.size();
            counts.add(countEntry);
        }
        return counts;
    }

    @Override
    public List<TokenRange> describe_ring(CharSequence keyspace) throws AvroRemoteException, InvalidRequestException {
        if (keyspace == null || ((Object)keyspace).toString().equals("system")) {
            throw ErrorFactory.newInvalidRequestException("There is no ring for the keyspace: " + keyspace);
        }
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
        for (Map.Entry<Range, List<String>> entry : StorageService.instance.getRangeToEndpointMap(((Object)keyspace).toString()).entrySet()) {
            Range range = entry.getKey();
            List<String> endpoints = entry.getValue();
            ranges.add(ErrorFactory.newTokenRange(tf.toString(range.left), tf.toString(range.right), endpoints));
        }
        return ranges;
    }

    @Override
    public Void truncate(CharSequence columnFamily) throws AvroRemoteException, InvalidRequestException, UnavailableException {
        if (logger.isDebugEnabled()) {
            logger.debug("truncating {} in {}", (Object)columnFamily, (Object)this.state().getKeyspace());
        }
        try {
            this.state().hasColumnFamilyAccess(((Object)columnFamily).toString(), Permission.WRITE);
            this.schedule();
            StorageProxy.truncateBlocking(this.state().getKeyspace(), ((Object)columnFamily).toString());
        }
        catch (org.apache.cassandra.thrift.InvalidRequestException e) {
            throw ErrorFactory.newInvalidRequestException(e);
        }
        catch (org.apache.cassandra.thrift.UnavailableException e) {
            throw ErrorFactory.newUnavailableException(e);
        }
        catch (TimeoutException e) {
            throw ErrorFactory.newUnavailableException(e);
        }
        catch (IOException e) {
            throw ErrorFactory.newUnavailableException(e);
        }
        finally {
            this.release();
        }
        return null;
    }

    @Override
    public List<KeySlice> get_range_slices(ColumnParent column_parent, SlicePredicate slice_predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, TimedOutException {
        List<Row> rows;
        String keyspace = this.state().getKeyspace();
        try {
            this.state().hasColumnFamilyAccess(((Object)column_parent.column_family).toString(), Permission.READ);
        }
        catch (org.apache.cassandra.thrift.InvalidRequestException thriftE) {
            throw ErrorFactory.newInvalidRequestException(thriftE);
        }
        AvroValidation.validateColumnParent(keyspace, column_parent);
        AvroValidation.validatePredicate(keyspace, column_parent, slice_predicate);
        AvroValidation.validateKeyRange(range);
        try {
            AbstractBounds bounds;
            IPartitioner p = StorageService.getPartitioner();
            if (range.start_key == null) {
                Token.TokenFactory tokenFactory = p.getTokenFactory();
                Token left = tokenFactory.fromString(((Object)range.start_token).toString());
                Token right = tokenFactory.fromString(((Object)range.end_token).toString());
                bounds = new Range(left, right);
            } else {
                bounds = new Bounds((Token)p.getToken(range.start_key), (Token)p.getToken(range.end_key));
            }
            try {
                this.schedule();
                rows = StorageProxy.getRangeSlice(new RangeSliceCommand(keyspace, this.thriftColumnParent(column_parent), this.thriftSlicePredicate(slice_predicate), bounds, range.count), this.thriftConsistencyLevel(consistency_level));
            }
            catch (org.apache.cassandra.thrift.UnavailableException thriftE) {
                throw ErrorFactory.newUnavailableException(thriftE);
            }
            finally {
                this.release();
            }
            assert (rows != null);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.avronateKeySlices(rows, column_parent, slice_predicate);
    }

    @Override
    public List<KeySlice> get_indexed_slices(ColumnParent column_parent, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        List<Row> rows;
        if (logger.isDebugEnabled()) {
            logger.debug("scan");
        }
        try {
            this.state().hasColumnFamilyAccess(((Object)column_parent.column_family).toString(), Permission.READ);
        }
        catch (org.apache.cassandra.thrift.InvalidRequestException thriftE) {
            throw ErrorFactory.newInvalidRequestException(thriftE);
        }
        String keyspace = this.state().getKeyspace();
        AvroValidation.validateColumnParent(keyspace, column_parent);
        AvroValidation.validatePredicate(keyspace, column_parent, column_predicate);
        AvroValidation.validateIndexClauses(keyspace, ((Object)column_parent.column_family).toString(), index_clause);
        try {
            rows = StorageProxy.scan(keyspace.toString(), ((Object)column_parent.column_family).toString(), this.thriftIndexClause(index_clause), this.thriftSlicePredicate(column_predicate), this.thriftConsistencyLevel(consistency_level));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (org.apache.cassandra.thrift.UnavailableException e) {
            throw ErrorFactory.newUnavailableException();
        }
        return this.avronateKeySlices(rows, column_parent, column_predicate);
    }

    private List<KeySlice> avronateKeySlices(List<Row> rows, ColumnParent column_parent, SlicePredicate predicate) {
        ArrayList<KeySlice> keySlices = new ArrayList<KeySlice>(rows.size());
        boolean reversed = predicate.slice_range != null && predicate.slice_range.reversed;
        for (Row row : rows) {
            GenericArray<ColumnOrSuperColumn> avronatedColumns = this.avronateColumnFamily(row.cf, column_parent.super_column != null, reversed);
            keySlices.add(AvroRecordFactory.newKeySlice(row.key.key, avronatedColumns));
        }
        return keySlices;
    }

    private org.apache.cassandra.thrift.ColumnParent thriftColumnParent(ColumnParent avro_column_parent) {
        org.apache.cassandra.thrift.ColumnParent cp = new org.apache.cassandra.thrift.ColumnParent(((Object)avro_column_parent.column_family).toString());
        if (avro_column_parent.super_column != null) {
            cp.super_column = avro_column_parent.super_column;
        }
        return cp;
    }

    private org.apache.cassandra.thrift.SlicePredicate thriftSlicePredicate(SlicePredicate avro_pred) {
        org.apache.cassandra.thrift.SliceRange slice_range = avro_pred.slice_range != null ? this.thriftSliceRange(avro_pred.slice_range) : null;
        return new org.apache.cassandra.thrift.SlicePredicate().setColumn_names(avro_pred.column_names).setSlice_range(slice_range);
    }

    private org.apache.cassandra.thrift.SliceRange thriftSliceRange(SliceRange avro_range) {
        return new org.apache.cassandra.thrift.SliceRange(avro_range.start, avro_range.finish, avro_range.reversed, avro_range.count);
    }

    private org.apache.cassandra.thrift.IndexClause thriftIndexClause(IndexClause avro_clause) {
        ArrayList<org.apache.cassandra.thrift.IndexExpression> expressions = new ArrayList<org.apache.cassandra.thrift.IndexExpression>();
        for (IndexExpression exp : avro_clause.expressions) {
            expressions.add(this.thriftIndexExpression(exp));
        }
        return new org.apache.cassandra.thrift.IndexClause(expressions, avro_clause.start_key, avro_clause.count);
    }

    private org.apache.cassandra.thrift.IndexExpression thriftIndexExpression(IndexExpression avro_exp) {
        return new org.apache.cassandra.thrift.IndexExpression(avro_exp.column_name, this.thriftIndexOperator(avro_exp.op), avro_exp.value);
    }

    private org.apache.cassandra.thrift.IndexOperator thriftIndexOperator(IndexOperator avro_op) {
        switch (avro_op) {
            case EQ: {
                return org.apache.cassandra.thrift.IndexOperator.EQ;
            }
            case GTE: {
                return org.apache.cassandra.thrift.IndexOperator.GTE;
            }
            case GT: {
                return org.apache.cassandra.thrift.IndexOperator.GT;
            }
            case LTE: {
                return org.apache.cassandra.thrift.IndexOperator.LTE;
            }
            case LT: {
                return org.apache.cassandra.thrift.IndexOperator.LT;
            }
        }
        return null;
    }
}

