/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Set;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.service.StorageService;

class HeaderSerializer
implements ICompactSerializer<Header> {
    HeaderSerializer() {
    }

    @Override
    public void serialize(Header t, DataOutputStream dos) throws IOException {
        dos.writeUTF(t.getMessageId());
        CompactEndpointSerializationHelper.serialize(t.getFrom(), dos);
        dos.writeInt(t.getVerb().ordinal());
        int size = t.details_.size();
        dos.writeInt(size);
        Set<String> keys = t.details_.keySet();
        for (String key : keys) {
            dos.writeUTF(key);
            byte[] value = t.details_.get(key);
            dos.writeInt(value.length);
            dos.write(value);
        }
    }

    @Override
    public Header deserialize(DataInputStream dis) throws IOException {
        String id = dis.readUTF();
        InetAddress from = CompactEndpointSerializationHelper.deserialize(dis);
        int verbOrdinal = dis.readInt();
        int size = dis.readInt();
        Hashtable<String, byte[]> details = new Hashtable<String, byte[]>(size);
        for (int i = 0; i < size; ++i) {
            String key = dis.readUTF();
            int length = dis.readInt();
            byte[] bytes = new byte[length];
            dis.readFully(bytes);
            details.put(key, bytes);
        }
        return new Header(id, from, StorageService.VERBS[verbOrdinal], details);
    }
}

