/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.locator.ILatencyPublisher;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseVerbHandler
implements IVerbHandler,
ILatencyPublisher {
    private static final Logger logger_ = LoggerFactory.getLogger(ResponseVerbHandler.class);
    private List<ILatencySubscriber> subscribers = new ArrayList<ILatencySubscriber>();

    @Override
    public void doVerb(Message message) {
        String messageId = message.getMessageId();
        MessagingService.responseReceivedFrom(messageId, message.getFrom());
        double age = System.currentTimeMillis() - MessagingService.getRegisteredCallbackAge(messageId);
        IMessageCallback cb = MessagingService.getRegisteredCallback(messageId);
        if (cb == null) {
            return;
        }
        for (ILatencySubscriber subscriber : this.subscribers) {
            subscriber.receiveTiming(message.getFrom(), age);
        }
        if (cb instanceof IAsyncCallback) {
            if (logger_.isDebugEnabled()) {
                logger_.debug("Processing response on a callback from " + message.getMessageId() + "@" + message.getFrom());
            }
            ((IAsyncCallback)cb).response(message);
        } else {
            if (logger_.isDebugEnabled()) {
                logger_.debug("Processing response on an async result from " + message.getMessageId() + "@" + message.getFrom());
            }
            ((IAsyncResult)cb).result(message);
        }
    }

    @Override
    public void register(ILatencySubscriber subscriber) {
        this.subscribers.add(subscriber);
    }
}

