/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.openstack.keystone.v2_0.config.AuthenticationApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.v2_0.config.NovaHttpApiModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class NovaApiMetadata
extends BaseHttpApiMetadata<NovaApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public NovaApiMetadata() {
        this(new Builder());
    }

    protected NovaApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        properties.setProperty("jclouds.keystone.service-type", "compute");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.openstack-nova.auto-create-floating-ips", "false");
        properties.setProperty("jclouds.openstack-nova.auto-generate-keypairs", "false");
        properties.setProperty("jclouds.openstack-nova.timeout.securitygroup-present", "500");
        properties.setProperty("jclouds.session-interval", "1800");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<NovaApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-nova")).name("OpenStack Nova Diablo+ API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Keystone base url ending in /v2.0/")).documentation(URI.create("http://api.openstack.org/"))).version("2")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(NovaApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)ImmutableSet.builder().add(AuthenticationApiModule.class).add(KeystoneAuthenticationModule.class).add(KeystoneAuthenticationModule.ZoneModule.class).add(NovaParserModule.class).add(NovaHttpApiModule.class).add(NovaComputeServiceContextModule.class).build());
        }

        public NovaApiMetadata build() {
            return new NovaApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

