/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.Zone;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.domain.ServerWithSecurityGroups;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndId;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.extensions.ServerWithSecurityGroupsApi;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;

public class NovaSecurityGroupExtension
implements SecurityGroupExtension {
    protected final NovaApi api;
    protected final ListeningExecutorService userExecutor;
    protected final Supplier<Set<String>> zoneIds;
    protected final Function<SecurityGroupInZone, SecurityGroup> groupConverter;
    protected final LoadingCache<ZoneAndName, SecurityGroupInZone> groupCreator;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    public NovaSecurityGroupExtension(NovaApi api, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Zone Supplier<Set<String>> zoneIds, Function<SecurityGroupInZone, SecurityGroup> groupConverter, LoadingCache<ZoneAndName, SecurityGroupInZone> groupCreator, GroupNamingConvention.Factory namingConvention) {
        this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
        this.zoneIds = (Supplier)Preconditions.checkNotNull(zoneIds, (Object)"zoneIds");
        this.groupConverter = (Function)Preconditions.checkNotNull(groupConverter, (Object)"groupConverter");
        this.groupCreator = (LoadingCache)Preconditions.checkNotNull(groupCreator, (Object)"groupCreator");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
    }

    public Set<SecurityGroup> listSecurityGroups() {
        Iterable<? extends SecurityGroupInZone> rawGroups = this.pollSecurityGroups();
        Iterable groups = Iterables.transform((Iterable)Iterables.filter(rawGroups, (Predicate)Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf((Iterable)groups);
    }

    public Set<SecurityGroup> listSecurityGroupsInLocation(Location location) {
        String zone = location.getId();
        if (zone == null) {
            return ImmutableSet.of();
        }
        return this.listSecurityGroupsInLocation(zone);
    }

    public Set<SecurityGroup> listSecurityGroupsInLocation(String zone) {
        Iterable<? extends SecurityGroupInZone> rawGroups = this.pollSecurityGroupsByZone(zone);
        Iterable groups = Iterables.transform((Iterable)Iterables.filter(rawGroups, (Predicate)Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf((Iterable)groups);
    }

    public Set<SecurityGroup> listSecurityGroupsForNode(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        String zone = zoneAndId.getZone();
        String instanceId = zoneAndId.getId();
        Optional<? extends ServerWithSecurityGroupsApi> serverApi = this.api.getServerWithSecurityGroupsExtensionForZone(zone);
        Optional<? extends SecurityGroupApi> sgApi = this.api.getSecurityGroupExtensionForZone(zone);
        if (!serverApi.isPresent() || !sgApi.isPresent()) {
            return ImmutableSet.of();
        }
        ServerWithSecurityGroups instance = ((ServerWithSecurityGroupsApi)serverApi.get()).get(instanceId);
        if (instance == null) {
            return ImmutableSet.of();
        }
        Set<String> groupNames = instance.getSecurityGroupNames();
        ImmutableSet rawGroups = ((SecurityGroupApi)sgApi.get()).list().filter(SecurityGroupPredicates.nameIn(groupNames)).transform(this.groupToGroupInZone(zone)).toSet();
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)rawGroups, (Predicate)Predicates.notNull()), this.groupConverter));
    }

    public SecurityGroup getSecurityGroupById(String id) {
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        String zone = zoneAndId.getZone();
        String groupId = zoneAndId.getId();
        Optional<? extends SecurityGroupApi> sgApi = this.api.getSecurityGroupExtensionForZone(zone);
        if (!sgApi.isPresent()) {
            return null;
        }
        SecurityGroupInZone rawGroup = new SecurityGroupInZone(((SecurityGroupApi)sgApi.get()).get(groupId), zone);
        return (SecurityGroup)this.groupConverter.apply((Object)rawGroup);
    }

    public SecurityGroup createSecurityGroup(String name, Location location) {
        String zone = location.getId();
        if (zone == null) {
            return null;
        }
        return this.createSecurityGroup(name, zone);
    }

    public SecurityGroup createSecurityGroup(String name, String zone) {
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        ZoneSecurityGroupNameAndPorts zoneAndName = new ZoneSecurityGroupNameAndPorts(zone, markerGroup, (Iterable<Integer>)ImmutableSet.of());
        SecurityGroupInZone rawGroup = (SecurityGroupInZone)this.groupCreator.getUnchecked((Object)zoneAndName);
        return (SecurityGroup)this.groupConverter.apply((Object)rawGroup);
    }

    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(id);
        String zone = zoneAndId.getZone();
        String groupId = zoneAndId.getId();
        Optional<? extends SecurityGroupApi> sgApi = this.api.getSecurityGroupExtensionForZone(zone);
        if (!sgApi.isPresent()) {
            return false;
        }
        if (((SecurityGroupApi)sgApi.get()).get(groupId) == null) {
            return false;
        }
        ((SecurityGroupApi)sgApi.get()).delete(groupId);
        this.groupCreator.invalidate((Object)new ZoneSecurityGroupNameAndPorts(zone, groupId, (Iterable<Integer>)ImmutableSet.of()));
        return true;
    }

    public SecurityGroup addIpPermission(IpPermission ipPermission, SecurityGroup group) {
        String zone = group.getLocation().getId();
        ZoneAndId groupZoneAndId = ZoneAndId.fromSlashEncoded(group.getId());
        String id = groupZoneAndId.getId();
        Optional<? extends SecurityGroupApi> sgApi = this.api.getSecurityGroupExtensionForZone(zone);
        if (!sgApi.isPresent()) {
            return null;
        }
        if (ipPermission.getCidrBlocks().size() > 0) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                ((SecurityGroupApi)sgApi.get()).createRuleAllowingCidrBlock(id, ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(ipPermission.getIpProtocol())).fromPort(ipPermission.getFromPort())).toPort(ipPermission.getToPort())).build(), cidr);
            }
        }
        if (ipPermission.getGroupIds().size() > 0) {
            for (String zoneAndGroupRaw : ipPermission.getGroupIds()) {
                ZoneAndId zoneAndId = ZoneAndId.fromSlashEncoded(zoneAndGroupRaw);
                String groupId = zoneAndId.getId();
                ((SecurityGroupApi)sgApi.get()).createRuleAllowingSecurityGroupId(id, ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(ipPermission.getIpProtocol())).fromPort(ipPermission.getFromPort())).toPort(ipPermission.getToPort())).build(), groupId);
            }
        }
        return this.getSecurityGroupById(ZoneAndId.fromZoneAndId(zone, id).slashEncode());
    }

    public SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.addIpPermission(permBuilder.build(), group);
    }

    public SecurityGroup removeIpPermission(IpPermission ipPermission, SecurityGroup group) {
        String zone = group.getLocation().getId();
        ZoneAndId groupZoneAndId = ZoneAndId.fromSlashEncoded(group.getId());
        String id = groupZoneAndId.getId();
        Optional<? extends SecurityGroupApi> sgApi = this.api.getSecurityGroupExtensionForZone(zone);
        if (!sgApi.isPresent()) {
            return null;
        }
        org.jclouds.openstack.nova.v2_0.domain.SecurityGroup securityGroup = ((SecurityGroupApi)sgApi.get()).get(id);
        if (ipPermission.getCidrBlocks().size() > 0) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                for (SecurityGroupRule rule : Iterables.filter(securityGroup.getRules(), (Predicate)Predicates.and((Predicate[])new Predicate[]{SecurityGroupPredicates.ruleCidr(cidr), SecurityGroupPredicates.ruleProtocol(ipPermission.getIpProtocol()), SecurityGroupPredicates.ruleStartPort(ipPermission.getFromPort()), SecurityGroupPredicates.ruleEndPort(ipPermission.getToPort())}))) {
                    ((SecurityGroupApi)sgApi.get()).deleteRule(rule.getId());
                }
            }
        }
        if (ipPermission.getGroupIds().size() > 0) {
            for (String groupId : ipPermission.getGroupIds()) {
                for (SecurityGroupRule rule : Iterables.filter(securityGroup.getRules(), (Predicate)Predicates.and((Predicate[])new Predicate[]{SecurityGroupPredicates.ruleGroup(groupId), SecurityGroupPredicates.ruleProtocol(ipPermission.getIpProtocol()), SecurityGroupPredicates.ruleStartPort(ipPermission.getFromPort()), SecurityGroupPredicates.ruleEndPort(ipPermission.getToPort())}))) {
                    ((SecurityGroupApi)sgApi.get()).deleteRule(rule.getId());
                }
            }
        }
        return this.getSecurityGroupById(ZoneAndId.fromZoneAndId(zone, id).slashEncode());
    }

    public SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    public boolean supportsGroupIds() {
        return true;
    }

    public boolean supportsPortRangesForGroups() {
        return false;
    }

    protected Iterable<? extends SecurityGroupInZone> pollSecurityGroups() {
        Iterable groups = Iterables.transform((Iterable)((Iterable)this.zoneIds.get()), this.allSecurityGroupsInZone());
        return Iterables.concat((Iterable)groups);
    }

    protected Iterable<? extends SecurityGroupInZone> pollSecurityGroupsByZone(String zone) {
        return (Iterable)this.allSecurityGroupsInZone().apply((Object)zone);
    }

    protected Function<String, Set<? extends SecurityGroupInZone>> allSecurityGroupsInZone() {
        return new Function<String, Set<? extends SecurityGroupInZone>>(){

            public Set<? extends SecurityGroupInZone> apply(String from) {
                Optional<? extends SecurityGroupApi> sgApi = NovaSecurityGroupExtension.this.api.getSecurityGroupExtensionForZone(from);
                if (!sgApi.isPresent()) {
                    return ImmutableSet.of();
                }
                return ((SecurityGroupApi)sgApi.get()).list().transform(NovaSecurityGroupExtension.this.groupToGroupInZone(from)).toSet();
            }
        };
    }

    protected Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroupInZone> groupToGroupInZone(final String zone) {
        return new Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroupInZone>(){

            public SecurityGroupInZone apply(org.jclouds.openstack.nova.v2_0.domain.SecurityGroup group) {
                return new SecurityGroupInZone(group, zone);
            }
        };
    }
}

