/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.features.FlavorApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseFlavors
extends ParseJson<Flavors> {
    @Inject
    public ParseFlavors(Json json) {
        super(json, TypeLiteral.get(Flavors.class));
    }

    static class Flavors
    extends PaginatedCollection<Resource> {
        @ConstructorProperties(value={"flavors", "flavors_links"})
        protected Flavors(Iterable<Resource> flavors, Iterable<Link> flavors_links) {
            super(flavors, flavors_links);
        }
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Resource, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Resource>> markerToNextForArg0(Optional<Object> arg0) {
            String zone = arg0.get().toString();
            final FlavorApi flavorApi = this.api.getFlavorApiForZone(zone);
            return new Function<Object, IterableWithMarker<Resource>>(){

                public IterableWithMarker<Resource> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return (IterableWithMarker)IterableWithMarker.class.cast(flavorApi.list(paginationOptions));
                }

                public String toString() {
                    return "listFlavors()";
                }
            };
        }
    }
}

