/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.cim.ManagedElement;

public class ResourceAllocationSettingData
extends ManagedElement {
    protected final String address;
    protected final String addressOnParent;
    protected final String allocationUnits;
    protected final Boolean automaticAllocation;
    protected final Boolean automaticDeallocation;
    protected final ConsumerVisibility consumerVisibility;
    protected final Long limit;
    protected final MappingBehavior mappingBehavior;
    protected final String otherResourceType;
    protected final String parent;
    protected final String poolID;
    protected final Long reservation;
    protected final String resourceSubType;
    protected final ResourceType resourceType;
    protected final Long virtualQuantity;
    protected final String virtualQuantityUnits;
    protected final Integer weight;
    protected final List<String> connections;
    protected final List<String> hostResources;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return ResourceAllocationSettingData.builder().fromResourceAllocationSettingData(this);
    }

    public ResourceAllocationSettingData(String elementName, String instanceID, String caption, String description, String address, String addressOnParent, String allocationUnits, Boolean automaticAllocation, Boolean automaticDeallocation, ConsumerVisibility consumerVisibility, Long limit, MappingBehavior mappingBehavior, String otherResourceType, String parent, String poolID, Long reservation, String resourceSubType, ResourceType resourceType, Long virtualQuantity, String virtualQuantityUnits, Integer weight, List<String> connections, List<String> hostResources) {
        super(elementName, instanceID, caption, description);
        this.address = address;
        this.addressOnParent = addressOnParent;
        this.allocationUnits = allocationUnits;
        this.automaticAllocation = automaticAllocation;
        this.automaticDeallocation = automaticDeallocation;
        this.consumerVisibility = consumerVisibility;
        this.limit = limit;
        this.mappingBehavior = mappingBehavior;
        this.otherResourceType = otherResourceType;
        this.parent = parent;
        this.poolID = poolID;
        this.reservation = reservation;
        this.resourceSubType = resourceSubType;
        this.resourceType = resourceType;
        this.virtualQuantity = virtualQuantity;
        this.virtualQuantityUnits = virtualQuantityUnits;
        this.weight = weight;
        this.connections = ImmutableList.copyOf(connections);
        this.hostResources = ImmutableList.copyOf(hostResources);
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressOnParent() {
        return this.addressOnParent;
    }

    public String getAllocationUnits() {
        return this.allocationUnits;
    }

    public Boolean isAutomaticAllocation() {
        return this.automaticAllocation;
    }

    public Boolean isAutomaticDeallocation() {
        return this.automaticDeallocation;
    }

    public ConsumerVisibility getConsumerVisibility() {
        return this.consumerVisibility;
    }

    public Long getLimit() {
        return this.limit;
    }

    public MappingBehavior getMappingBehavior() {
        return this.mappingBehavior;
    }

    public String getOtherResourceType() {
        return this.otherResourceType;
    }

    public String getParent() {
        return this.parent;
    }

    public String getPoolID() {
        return this.poolID;
    }

    public Long getReservation() {
        return this.reservation;
    }

    public String getResourceSubType() {
        return this.resourceSubType;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Long getVirtualQuantity() {
        return this.virtualQuantity;
    }

    public String getVirtualQuantityUnits() {
        return this.virtualQuantityUnits;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public List<String> getConnections() {
        return this.connections;
    }

    public List<String> getHostResources() {
        return this.hostResources;
    }

    @Override
    public String toString() {
        return String.format("[elementName=%s, instanceID=%s, caption=%s, description=%s, address=%s, addressOnParent=%s, allocationUnits=%s, automaticAllocation=%s, automaticDeallocation=%s, connections=%s, consumerVisibility=%s, hostResources=%s, limit=%s, mappingBehavior=%s, otherResourceType=%s, parent=%s, poolID=%s, reservation=%s, resourceSubType=%s, resourceType=%s, virtualQuantity=%s, virtualQuantityUnits=%s, weight=%s]", new Object[]{this.elementName, this.instanceID, this.caption, this.description, this.address, this.addressOnParent, this.allocationUnits, this.automaticAllocation, this.automaticDeallocation, this.connections, this.consumerVisibility, this.hostResources, this.limit, this.mappingBehavior, this.otherResourceType, this.parent, this.poolID, this.reservation, this.resourceSubType, this.resourceType, this.virtualQuantity, this.virtualQuantityUnits, this.weight});
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.addressOnParent == null ? 0 : this.addressOnParent.hashCode());
        result = 31 * result + (this.resourceSubType == null ? 0 : this.resourceSubType.hashCode());
        result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceAllocationSettingData other = (ResourceAllocationSettingData)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.addressOnParent == null ? other.addressOnParent != null : !this.addressOnParent.equals(other.addressOnParent)) {
            return false;
        }
        if (this.resourceSubType == null ? other.resourceSubType != null : !this.resourceSubType.equals(other.resourceSubType)) {
            return false;
        }
        return !(this.resourceType == null ? other.resourceType != null : !this.resourceType.equals((Object)other.resourceType));
    }

    public static class Builder
    extends ManagedElement.Builder {
        protected String address;
        protected String addressOnParent;
        protected String allocationUnits;
        protected Boolean automaticAllocation;
        protected Boolean automaticDeallocation;
        protected ConsumerVisibility consumerVisibility;
        protected Long limit;
        protected MappingBehavior mappingBehavior;
        protected String otherResourceType;
        protected String parent;
        protected String poolID;
        protected Long reservation;
        protected String resourceSubType;
        protected ResourceType resourceType;
        protected Long virtualQuantity;
        protected String virtualQuantityUnits;
        protected Integer weight;
        protected List<String> connections = Lists.newArrayList();
        protected List<String> hostResources = Lists.newArrayList();

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder addressOnParent(String addressOnParent) {
            this.addressOnParent = addressOnParent;
            return this;
        }

        public Builder allocationUnits(String allocationUnits) {
            this.allocationUnits = allocationUnits;
            return this;
        }

        public Builder automaticAllocation(Boolean automaticAllocation) {
            this.automaticAllocation = automaticAllocation;
            return this;
        }

        public Builder automaticDeallocation(Boolean automaticDeallocation) {
            this.automaticDeallocation = automaticDeallocation;
            return this;
        }

        public Builder consumerVisibility(ConsumerVisibility consumerVisibility) {
            this.consumerVisibility = consumerVisibility;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder mappingBehavior(MappingBehavior mappingBehavior) {
            this.mappingBehavior = mappingBehavior;
            return this;
        }

        public Builder otherResourceType(String otherResourceType) {
            this.otherResourceType = otherResourceType;
            return this;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder poolID(String poolID) {
            this.poolID = poolID;
            return this;
        }

        public Builder reservation(Long reservation) {
            this.reservation = reservation;
            return this;
        }

        public Builder resourceSubType(String resourceSubType) {
            this.resourceSubType = resourceSubType;
            return this;
        }

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder virtualQuantity(Long virtualQuantity) {
            this.virtualQuantity = virtualQuantity;
            return this;
        }

        public Builder virtualQuantityUnits(String virtualQuantityUnits) {
            this.virtualQuantityUnits = virtualQuantityUnits;
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public Builder connection(String connection) {
            this.connections.add((String)Preconditions.checkNotNull((Object)connection, (Object)"connection"));
            return this;
        }

        public Builder hostResource(String hostResource) {
            this.hostResources.add((String)Preconditions.checkNotNull((Object)hostResource, (Object)"hostResource"));
            return this;
        }

        public Builder connections(List<String> connections) {
            this.connections.addAll((Collection)Preconditions.checkNotNull(connections, (Object)"connections"));
            return this;
        }

        public Builder hostResources(List<String> hostResources) {
            this.hostResources.addAll((Collection)Preconditions.checkNotNull(hostResources, (Object)"hostResources"));
            return this;
        }

        public ResourceAllocationSettingData build() {
            return new ResourceAllocationSettingData(this.elementName, this.instanceID, this.caption, this.description, this.address, this.addressOnParent, this.allocationUnits, this.automaticAllocation, this.automaticDeallocation, this.consumerVisibility, this.limit, this.mappingBehavior, this.otherResourceType, this.parent, this.poolID, this.reservation, this.resourceSubType, this.resourceType, this.virtualQuantity, this.virtualQuantityUnits, this.weight, this.connections, this.hostResources);
        }

        public Builder fromResourceAllocationSettingData(ResourceAllocationSettingData in) {
            return this.fromManagedElement(in).address(in.getAddress()).addressOnParent(in.getAddressOnParent()).allocationUnits(in.getAllocationUnits()).automaticAllocation(in.isAutomaticAllocation()).automaticDeallocation(in.isAutomaticDeallocation()).consumerVisibility(in.getConsumerVisibility()).limit(in.getLimit()).mappingBehavior(in.getMappingBehavior()).otherResourceType(in.getOtherResourceType()).parent(in.getParent()).poolID(in.getPoolID()).reservation(in.getReservation()).resourceSubType(in.getResourceSubType()).resourceType(in.getResourceType()).virtualQuantity(in.getVirtualQuantity()).virtualQuantityUnits(in.getVirtualQuantityUnits()).weight(in.getWeight()).connections(in.getConnections()).hostResources(in.getHostResources());
        }

        @Override
        public Builder fromManagedElement(ManagedElement in) {
            return (Builder)Builder.class.cast(super.fromManagedElement(in));
        }

        @Override
        public Builder caption(String caption) {
            return (Builder)Builder.class.cast(super.caption(caption));
        }

        @Override
        public Builder description(String description) {
            return (Builder)Builder.class.cast(super.description(description));
        }

        @Override
        public Builder elementName(String elementName) {
            return (Builder)Builder.class.cast(super.elementName(elementName));
        }

        @Override
        public Builder instanceID(String instanceID) {
            return (Builder)Builder.class.cast(super.instanceID(instanceID));
        }
    }

    public static enum ConsumerVisibility {
        UNKNOWN(0),
        PASSED_THROUGH(2),
        VIRTUALIZED(3),
        NOT_REPRESENTED(4),
        DMTF_RESERVED(Short.MAX_VALUE),
        VENDOR_RESERVED(65535);

        protected final int code;
        protected static final Map<Integer, ConsumerVisibility> MAPPING_BEHAVIOR_BY_ID;

        private ConsumerVisibility(int code) {
            this.code = code;
        }

        public String value() {
            return this.code + "";
        }

        public static ConsumerVisibility fromValue(String behavior) {
            return MAPPING_BEHAVIOR_BY_ID.get(Integer.valueOf((String)Preconditions.checkNotNull((Object)behavior, (Object)"behavior")));
        }

        static {
            MAPPING_BEHAVIOR_BY_ID = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])ConsumerVisibility.values()), (Function)new Function<ConsumerVisibility, Integer>(){

                public Integer apply(ConsumerVisibility input) {
                    return input.code;
                }
            });
        }
    }

    public static enum MappingBehavior {
        UNKNOWN(0),
        NOT_SUPPORTED(2),
        DEDICATED(3),
        SOFT_AFFINITY(4),
        HARD_AFFINITY(5),
        DMTF_RESERVED(Short.MAX_VALUE),
        VENDOR_RESERVED(65535);

        protected final int code;
        protected static final Map<Integer, MappingBehavior> MAPPING_BEHAVIOR_BY_ID;

        private MappingBehavior(int code) {
            this.code = code;
        }

        public String value() {
            return this.code + "";
        }

        public static MappingBehavior fromValue(String behavior) {
            return MAPPING_BEHAVIOR_BY_ID.get(Integer.valueOf((String)Preconditions.checkNotNull((Object)behavior, (Object)"behavior")));
        }

        static {
            MAPPING_BEHAVIOR_BY_ID = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])MappingBehavior.values()), (Function)new Function<MappingBehavior, Integer>(){

                public Integer apply(MappingBehavior input) {
                    return input.code;
                }
            });
        }
    }

    public static enum ResourceType {
        OTHER(1),
        COMPUTER_SYSTEM(2),
        PROCESSOR(3),
        MEMORY(4),
        IDE_CONTROLLER(5),
        PARALLEL_SCSI_HBA(6),
        FC_HBA(7),
        ISCSI_HBA(8),
        IB_HCA(9),
        ETHERNET_ADAPTER(10),
        OTHER_NETWORK_ADAPTER(11),
        IO_SLOT(12),
        IO_DEVICE(13),
        FLOPPY_DRIVE(14),
        CD_DRIVE(15),
        DVD_DRIVE(16),
        DISK_DRIVE(17),
        TAPE_DRIVE(18),
        STORAGE_EXTENT(19),
        OTHER_STORAGE_DEVICE(20),
        SERIAL_PORT(21),
        PARALLEL_PORT(22),
        USB_CONTROLLER(23),
        GRAPHICS_CONTROLLER(24),
        IEEE_1394_CONTROLLER(25),
        PARTITIONABLE_UNIT(26),
        BASE_PARTITIONABLE_UNIT(27),
        POWER(28),
        COOLING_CAPACITY(29),
        ETHERNET_SWITCH_PORT(30),
        LOGICAL_DISK(31),
        STORAGE_VOLUME(32),
        ETHERNET_CONNECTION(33),
        DMTF_RESERVED(Integer.valueOf("8000", 16)),
        VENDOR_RESERVED(Integer.valueOf("FFFF", 16));

        protected final int code;
        protected static final Map<Integer, ResourceType> RESOURCE_TYPE_BY_ID;

        private ResourceType(int code) {
            this.code = code;
        }

        public String value() {
            return this.code + "";
        }

        public static ResourceType fromValue(String type) {
            return RESOURCE_TYPE_BY_ID.get(Integer.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type")));
        }

        static {
            RESOURCE_TYPE_BY_ID = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])ResourceType.values()), (Function)new Function<ResourceType, Integer>(){

                public Integer apply(ResourceType input) {
                    return input.code;
                }
            });
        }
    }
}

