/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;

@Singleton
public class UnwrapOnlyJsonValueInSet<T>
implements Function<HttpResponse, T> {
    private final UnwrapOnlyJsonValue<Set<T>> json;

    @Inject
    UnwrapOnlyJsonValueInSet(UnwrapOnlyJsonValue<Set<T>> json) {
        this.json = json;
    }

    public T apply(HttpResponse arg0) {
        Set<T> set = this.json.apply(arg0);
        if (set == null || set.size() == 0) {
            return null;
        }
        return (T)Iterables.getOnlyElement(set);
    }
}

