/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;

public class ImageToImage
implements Function<org.jclouds.docker.domain.Image, Image> {
    private static final String CENTOS = "centos";
    private static final String UBUNTU = "ubuntu";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public Image apply(org.jclouds.docker.domain.Image from) {
        Preconditions.checkNotNull((Object)from, (Object)"image");
        String description = (String)Preconditions.checkNotNull((Object)Iterables.getFirst(from.getRepoTags(), (Object)"image must have at least one repo tag"));
        OsFamily osFamily = (OsFamily)this.osFamily().apply((Object)description);
        String osVersion = this.parseVersion(description);
        OperatingSystem os = OperatingSystem.builder().description(description).family(osFamily).version(osVersion).is64Bit(this.is64bit(from)).build();
        return new ImageBuilder().ids(from.getId()).name((String)Iterables.get((Iterable)Splitter.on((String)":").split((CharSequence)description), (int)0)).description(description).operatingSystem(os).status(Image.Status.AVAILABLE).build();
    }

    private boolean is64bit(org.jclouds.docker.domain.Image inspectedImage) {
        if (inspectedImage.getArchitecture() == null) {
            return true;
        }
        return inspectedImage.getArchitecture().matches("x86_64|amd64");
    }

    private Function<String, OsFamily> osFamily() {
        return new Function<String, OsFamily>(){

            public OsFamily apply(String description) {
                if (description != null) {
                    if (description.contains(ImageToImage.CENTOS)) {
                        return OsFamily.CENTOS;
                    }
                    if (description.contains(ImageToImage.UBUNTU)) {
                        return OsFamily.UBUNTU;
                    }
                }
                return OsFamily.UNRECOGNIZED;
            }
        };
    }

    private String parseVersion(String description) {
        String version = (String)Iterables.get((Iterable)Splitter.on((String)":").split((CharSequence)description), (int)1);
        this.logger.debug("os version for item: %s is %s", new Object[]{description, version});
        return version;
    }
}

