/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.config;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.docker.domain.Container;
import org.jclouds.json.config.GsonModule;

public class DockerParserModule
extends AbstractModule {
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings() {
        return new ImmutableMap.Builder().put(Container.class, (Object)new ContainerTypeAdapter()).build();
    }

    protected static class ContainerTypeAdapter
    implements JsonDeserializer<Container> {
        protected ContainerTypeAdapter() {
        }

        public Container deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Gson gson = new GsonBuilder().serializeNulls().create();
            JsonObject jsonObject = json.getAsJsonObject();
            return (Container)gson.fromJson((JsonElement)jsonObject, Container.class);
        }
    }
}

