/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;

public class State {
    @SerializedName(value="Pid")
    private final int pid;
    @SerializedName(value="Running")
    private final boolean running;
    @SerializedName(value="ExitCode")
    private final int exitCode;
    @SerializedName(value="StartedAt")
    private final String startedAt;
    @SerializedName(value="FinishedAt")
    private final String finishedAt;
    @SerializedName(value="Ghost")
    private final boolean ghost;

    @ConstructorProperties(value={"Pid", "Running", "ExitCode", "StartedAt", "FinishedAt", "Ghost"})
    protected State(int pid, boolean running, int exitCode, String startedAt, String finishedAt, boolean ghost) {
        this.pid = (Integer)Preconditions.checkNotNull((Object)pid, (Object)"pid");
        this.running = (Boolean)Preconditions.checkNotNull((Object)running, (Object)"running");
        this.exitCode = (Integer)Preconditions.checkNotNull((Object)exitCode, (Object)"exitCode");
        this.startedAt = (String)Preconditions.checkNotNull((Object)startedAt, (Object)"startedAt");
        this.finishedAt = (String)Preconditions.checkNotNull((Object)finishedAt, (Object)"finishedAt");
        this.ghost = (Boolean)Preconditions.checkNotNull((Object)ghost, (Object)"ghost");
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getStartedAt() {
        return this.startedAt;
    }

    public String getFinishedAt() {
        return this.finishedAt;
    }

    public boolean isGhost() {
        return this.ghost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State that = (State)o;
        return Objects.equal((Object)this.pid, (Object)that.pid) && Objects.equal((Object)this.running, (Object)that.running) && Objects.equal((Object)this.exitCode, (Object)that.exitCode) && Objects.equal((Object)this.startedAt, (Object)that.startedAt) && Objects.equal((Object)this.finishedAt, (Object)that.finishedAt) && Objects.equal((Object)this.ghost, (Object)that.ghost);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pid, this.running, this.exitCode, this.startedAt, this.finishedAt, this.ghost});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("pid", this.pid).add("running", this.running).add("exitCode", this.exitCode).add("startedAt", (Object)this.startedAt).add("finishedAt", (Object)this.finishedAt).add("ghost", this.ghost).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return State.builder().fromState(this);
    }

    public static final class Builder {
        private int pid;
        private boolean running;
        private int exitCode;
        private String startedAt;
        private String finishedAt;
        private boolean ghost;

        public Builder pid(int pid) {
            this.pid = pid;
            return this;
        }

        public Builder running(boolean running) {
            this.running = running;
            return this;
        }

        public Builder exitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public Builder startedAt(String startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public Builder finishedAt(String finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public Builder ghost(boolean ghost) {
            this.ghost = ghost;
            return this;
        }

        public State build() {
            return new State(this.pid, this.running, this.exitCode, this.startedAt, this.finishedAt, this.ghost);
        }

        public Builder fromState(State in) {
            return this.pid(in.getPid()).running(in.isRunning()).exitCode(in.getExitCode()).startedAt(in.getStartedAt()).finishedAt(in.getFinishedAt()).ghost(in.isGhost());
        }
    }
}

