/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;

public abstract class LeafReader
extends IndexReader {
    private final LeafReaderContext readerContext = new LeafReaderContext(this);

    protected LeafReader() {
    }

    @Override
    public final LeafReaderContext getContext() {
        this.ensureOpen();
        return this.readerContext;
    }

    protected static void addCoreClosedListenerAsReaderClosedListener(IndexReader reader, CoreClosedListener listener) {
        reader.addReaderClosedListener(new CoreClosedListenerWrapper(listener));
    }

    protected static void removeCoreClosedListenerAsReaderClosedListener(IndexReader reader, CoreClosedListener listener) {
        reader.removeReaderClosedListener(new CoreClosedListenerWrapper(listener));
    }

    public abstract void addCoreClosedListener(CoreClosedListener var1);

    public abstract void removeCoreClosedListener(CoreClosedListener var1);

    public abstract Fields fields() throws IOException;

    @Override
    public final int docFreq(Term term) throws IOException {
        Terms terms = this.terms(term.field());
        if (terms == null) {
            return 0;
        }
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.docFreq();
        }
        return 0;
    }

    @Override
    public final long totalTermFreq(Term term) throws IOException {
        Terms terms = this.terms(term.field());
        if (terms == null) {
            return 0L;
        }
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.totalTermFreq();
        }
        return 0L;
    }

    @Override
    public final long getSumDocFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumDocFreq();
    }

    @Override
    public final int getDocCount(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0;
        }
        return terms.getDocCount();
    }

    @Override
    public final long getSumTotalTermFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumTotalTermFreq();
    }

    public final Terms terms(String field) throws IOException {
        return this.fields().terms(field);
    }

    public final PostingsEnum postings(Term term, int flags) throws IOException {
        TermsEnum termsEnum;
        assert (term.field() != null);
        assert (term.bytes() != null);
        Terms terms = this.terms(term.field());
        if (terms != null && (termsEnum = terms.iterator()).seekExact(term.bytes())) {
            return termsEnum.postings(this.getLiveDocs(), null, flags);
        }
        return null;
    }

    public final PostingsEnum postings(Term term) throws IOException {
        return this.postings(term, 8);
    }

    public abstract NumericDocValues getNumericDocValues(String var1) throws IOException;

    public abstract BinaryDocValues getBinaryDocValues(String var1) throws IOException;

    public abstract SortedDocValues getSortedDocValues(String var1) throws IOException;

    public abstract SortedNumericDocValues getSortedNumericDocValues(String var1) throws IOException;

    public abstract SortedSetDocValues getSortedSetDocValues(String var1) throws IOException;

    public abstract Bits getDocsWithField(String var1) throws IOException;

    public abstract NumericDocValues getNormValues(String var1) throws IOException;

    public abstract FieldInfos getFieldInfos();

    public abstract Bits getLiveDocs();

    public abstract void checkIntegrity() throws IOException;

    @Deprecated
    public final DocsEnum termDocsEnum(Term term) throws IOException {
        TermsEnum termsEnum;
        assert (term.field() != null);
        assert (term.bytes() != null);
        Terms terms = this.terms(term.field());
        if (terms != null && (termsEnum = terms.iterator()).seekExact(term.bytes())) {
            return termsEnum.docs(this.getLiveDocs(), null);
        }
        return null;
    }

    @Deprecated
    public final DocsAndPositionsEnum termPositionsEnum(Term term) throws IOException {
        TermsEnum termsEnum;
        assert (term.field() != null);
        assert (term.bytes() != null);
        Terms terms = this.terms(term.field());
        if (terms != null && (termsEnum = terms.iterator()).seekExact(term.bytes())) {
            return termsEnum.docsAndPositions(this.getLiveDocs(), null);
        }
        return null;
    }

    public static interface CoreClosedListener {
        public void onClose(Object var1) throws IOException;
    }

    private static class CoreClosedListenerWrapper
    implements IndexReader.ReaderClosedListener {
        private final CoreClosedListener listener;

        CoreClosedListenerWrapper(CoreClosedListener listener) {
            this.listener = listener;
        }

        @Override
        public void onClose(IndexReader reader) throws IOException {
            this.listener.onClose(reader.getCoreCacheKey());
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof CoreClosedListenerWrapper)) {
                return false;
            }
            return this.listener.equals(((CoreClosedListenerWrapper)other).listener);
        }
    }
}

