/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class BooleanTopLevelScorers {
    BooleanTopLevelScorers() {
    }

    static class BoostedScorer
    extends FilterScorer {
        final float boost;

        BoostedScorer(Scorer in, float boost) {
            super(in);
            this.boost = boost;
        }

        @Override
        public float score() throws IOException {
            return this.in.score() * this.boost;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.in, "BOOSTED"));
        }
    }

    static class CoordinatingConjunctionScorer
    extends ConjunctionScorer {
        private final float[] coords;
        private final int reqCount;
        private final Scorer req;
        private final Scorer opt;

        CoordinatingConjunctionScorer(Weight weight, float[] coords, Scorer req, int reqCount, Scorer opt) {
            super(weight, Arrays.asList(req, opt), Arrays.asList(req, opt));
            this.coords = coords;
            this.req = req;
            this.reqCount = reqCount;
            this.opt = opt;
        }

        @Override
        public float score() throws IOException {
            return (this.req.score() + this.opt.score()) * this.coords[this.reqCount + this.opt.freq()];
        }
    }

    static class ReqMultiOptScorer
    extends ReqOptSumScorer {
        private final int requiredCount;
        private final float[] coords;

        public ReqMultiOptScorer(Scorer reqScorer, Scorer optScorer, int requiredCount, float[] coords) {
            super(reqScorer, optScorer);
            this.requiredCount = requiredCount;
            this.coords = coords;
        }

        @Override
        public float score() throws IOException {
            int curDoc = this.reqScorer.docID();
            float reqScore = this.reqScorer.score();
            if (this.optScorer == null) {
                return reqScore * this.coords[this.requiredCount];
            }
            int optScorerDoc = this.optScorer.docID();
            if (optScorerDoc < curDoc && (optScorerDoc = this.optScorer.advance(curDoc)) == Integer.MAX_VALUE) {
                this.optScorer = null;
                return reqScore * this.coords[this.requiredCount];
            }
            return optScorerDoc == curDoc ? (reqScore + this.optScorer.score()) * this.coords[this.requiredCount + this.optScorer.freq()] : reqScore * this.coords[this.requiredCount];
        }
    }

    static class ReqSingleOptScorer
    extends ReqOptSumScorer {
        private final float coordReq;
        private final float coordBoth;

        public ReqSingleOptScorer(Scorer reqScorer, Scorer optScorer, float coordReq, float coordBoth) {
            super(reqScorer, optScorer);
            this.coordReq = coordReq;
            this.coordBoth = coordBoth;
        }

        @Override
        public float score() throws IOException {
            int curDoc = this.reqScorer.docID();
            float reqScore = this.reqScorer.score();
            if (this.optScorer == null) {
                return reqScore * this.coordReq;
            }
            int optScorerDoc = this.optScorer.docID();
            if (optScorerDoc < curDoc && (optScorerDoc = this.optScorer.advance(curDoc)) == Integer.MAX_VALUE) {
                this.optScorer = null;
                return reqScore * this.coordReq;
            }
            return optScorerDoc == curDoc ? (reqScore + this.optScorer.score()) * this.coordBoth : reqScore * this.coordReq;
        }
    }
}

