/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.batch.BatchHelper;

public class BatchResponseWriter {
    private static final String COLON = ":";
    private static final String SP = " ";
    private static final String CRLF = "\r\n";
    private ResponseWriter writer = new ResponseWriter();

    public ODataResponse writeResponse(List<BatchResponsePart> batchResponseParts) throws BatchException {
        String boundary = BatchHelper.generateBoundary("batch");
        this.appendResponsePart(batchResponseParts, boundary);
        String batchResponseBody = this.writer.toString();
        return ODataResponse.entity(batchResponseBody).status(HttpStatusCodes.ACCEPTED).header("Content-Type", "multipart/mixed; boundary=" + boundary).header("Content-Length", String.valueOf(this.writer.length())).build();
    }

    private void appendChangeSet(BatchResponsePart batchResponsePart) throws BatchException {
        String boundary = BatchHelper.generateBoundary("changeset");
        this.writer.append("Content-Type").append(COLON).append(SP).append("multipart/mixed; boundary=" + boundary).append(CRLF).append(CRLF);
        for (ODataResponse response : batchResponsePart.getResponses()) {
            this.writer.append("--").append(boundary).append(CRLF);
            this.appendResponsePartBody(response);
        }
        this.writer.append("--").append(boundary).append("--").append(CRLF);
    }

    private void appendResponsePart(List<BatchResponsePart> batchResponseParts, String boundary) throws BatchException {
        for (BatchResponsePart batchResponsePart : batchResponseParts) {
            this.writer.append("--").append(boundary).append(CRLF);
            if (batchResponsePart.isChangeSet()) {
                this.appendChangeSet(batchResponsePart);
                continue;
            }
            ODataResponse response = batchResponsePart.getResponses().get(0);
            this.appendResponsePartBody(response);
        }
        this.writer.append("--").append(boundary).append("--");
    }

    private void appendResponsePartBody(ODataResponse response) throws BatchException {
        this.writer.append("Content-Type").append(COLON).append(SP).append("application/http").append(CRLF);
        this.writer.append("Content-Transfer-Encoding").append(COLON).append(SP).append("binary").append(CRLF);
        if (response.getHeader("MimeHeader-ContentId") != null) {
            this.writer.append("Content-Id").append(COLON).append(SP).append(response.getHeader("MimeHeader-ContentId")).append(CRLF);
        }
        this.writer.append(CRLF);
        this.writer.append("HTTP/1.1").append(SP).append(String.valueOf(response.getStatus().getStatusCode())).append(SP).append(response.getStatus().getInfo()).append(CRLF);
        this.appendHeader(response);
        if (!HttpStatusCodes.NO_CONTENT.equals((Object)response.getStatus())) {
            String body;
            if (response.getEntity() instanceof InputStream) {
                InputStream in = (InputStream)response.getEntity();
                body = this.readBody(in);
            } else {
                body = response.getEntity().toString();
            }
            this.writer.append("Content-Length").append(COLON).append(SP).append(String.valueOf(BatchHelper.getBytes(body).length)).append(CRLF).append(CRLF);
            this.writer.append(body);
        } else {
            this.writer.append(CRLF);
        }
        this.writer.append(CRLF);
    }

    private void appendHeader(ODataResponse response) {
        for (String name : response.getHeaderNames()) {
            if (!"MimeHeader-ContentId".equalsIgnoreCase(name) && !"RequestHeader-ContentId".equalsIgnoreCase(name)) {
                this.writer.append(name).append(COLON).append(SP).append(response.getHeader(name)).append(CRLF);
                continue;
            }
            if (!"RequestHeader-ContentId".equalsIgnoreCase(name)) continue;
            this.writer.append("Content-Id").append(COLON).append(SP).append(response.getHeader(name)).append(CRLF);
        }
    }

    private String readBody(InputStream in) throws BatchException {
        byte[] tmp = new byte[2048];
        BatchException cachedException = null;
        StringBuffer b = new StringBuffer();
        try {
            int count = in.read(tmp);
            while (count >= 0) {
                b.append(new String(tmp, 0, count, "utf-8"));
                count = in.read(tmp);
            }
        }
        catch (IOException e) {
            cachedException = new BatchException(ODataMessageException.COMMON, (Throwable)e);
            throw cachedException;
        }
        finally {
            block11: {
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (cachedException == null) break block11;
                    throw cachedException;
                }
            }
        }
        return b.toString();
    }

    private static class ResponseWriter {
        private StringBuilder sb = new StringBuilder();
        private int length = 0;

        private ResponseWriter() {
        }

        public ResponseWriter append(String content) {
            this.length += BatchHelper.getBytes(content).length;
            this.sb.append(content);
            return this;
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

