/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.core.batch.v2.BatchChangeSetPart;
import org.apache.olingo.odata2.core.batch.v2.BatchParserCommon;
import org.apache.olingo.odata2.core.batch.v2.BatchPart;
import org.apache.olingo.odata2.core.batch.v2.BatchQueryOperation;
import org.apache.olingo.odata2.core.batch.v2.BufferedReaderIncludingLineEndings;
import org.apache.olingo.odata2.core.batch.v2.Header;

public class BatchBodyPart
implements BatchPart {
    private final String boundary;
    private final boolean isStrict;
    final List<BufferedReaderIncludingLineEndings.Line> remainingMessage = new LinkedList<BufferedReaderIncludingLineEndings.Line>();
    private Header headers;
    private boolean isChangeSet;
    private List<BatchQueryOperation> requests;

    public BatchBodyPart(List<BufferedReaderIncludingLineEndings.Line> bodyPartMessage, String boundary, boolean isStrict) throws BatchException {
        this.boundary = boundary;
        this.isStrict = isStrict;
        this.remainingMessage.addAll(bodyPartMessage);
    }

    public BatchBodyPart parse() throws BatchException {
        this.headers = BatchParserCommon.consumeHeaders(this.remainingMessage);
        BatchParserCommon.consumeBlankLine(this.remainingMessage, this.isStrict);
        this.isChangeSet = this.isChangeSet(this.headers);
        this.requests = this.consumeRequest(this.remainingMessage);
        return this;
    }

    private boolean isChangeSet(Header headers) throws BatchException {
        List<String> contentTypes = headers.getHeaders("Content-Type");
        boolean isChangeSet = false;
        if (contentTypes.size() == 0) {
            throw new BatchException(BatchException.MISSING_CONTENT_TYPE.addContent(headers.getLineNumber()));
        }
        for (String contentType : contentTypes) {
            if (!this.isContentTypeMultiPartMixed(contentType)) continue;
            isChangeSet = true;
        }
        return isChangeSet;
    }

    private boolean isContentTypeMultiPartMixed(String contentType) {
        return BatchParserCommon.PATTERN_MULTIPART_MIXED.matcher(contentType).matches();
    }

    private List<BatchQueryOperation> consumeRequest(List<BufferedReaderIncludingLineEndings.Line> remainingMessage) throws BatchException {
        if (this.isChangeSet) {
            return this.consumeChangeSet(remainingMessage);
        }
        return this.consumeQueryOperation(remainingMessage);
    }

    private List<BatchQueryOperation> consumeChangeSet(List<BufferedReaderIncludingLineEndings.Line> remainingMessage) throws BatchException {
        List<List<BufferedReaderIncludingLineEndings.Line>> changeRequests = this.splitChangeSet(remainingMessage);
        LinkedList<BatchQueryOperation> requestList = new LinkedList<BatchQueryOperation>();
        for (List<BufferedReaderIncludingLineEndings.Line> changeRequest : changeRequests) {
            requestList.add(new BatchChangeSetPart(changeRequest, this.isStrict).parse());
        }
        return requestList;
    }

    private List<List<BufferedReaderIncludingLineEndings.Line>> splitChangeSet(List<BufferedReaderIncludingLineEndings.Line> remainingMessage) throws BatchException {
        Header.HeaderField contentTypeField = this.headers.getHeaderField("Content-Type");
        String changeSetBoundary = BatchParserCommon.getBoundary(contentTypeField.getValueNotNull(), contentTypeField.getLineNumber());
        this.validateChangeSetBoundary(changeSetBoundary, this.headers);
        return BatchParserCommon.splitMessageByBoundary(remainingMessage, changeSetBoundary);
    }

    private List<BatchQueryOperation> consumeQueryOperation(List<BufferedReaderIncludingLineEndings.Line> remainingMessage) throws BatchException {
        LinkedList<BatchQueryOperation> requestList = new LinkedList<BatchQueryOperation>();
        requestList.add(new BatchQueryOperation(remainingMessage, this.isStrict).parse());
        return requestList;
    }

    private void validateChangeSetBoundary(String changeSetBoundary, Header header) throws BatchException {
        if (changeSetBoundary.equals(this.boundary)) {
            throw new BatchException(BatchException.INVALID_BOUNDARY.addContent(header.getHeaderField("Content-Type").getLineNumber()));
        }
    }

    @Override
    public Header getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean isChangeSet() {
        return this.isChangeSet;
    }

    public List<BatchQueryOperation> getRequests() {
        return this.requests;
    }
}

