/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.debug.ODataDebugResponseWrapper;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class DebugInfoRequest
implements DebugInfo {
    private final String method;
    private final URI uri;
    private final String protocol;
    private final Map<String, List<String>> headers;

    public DebugInfoRequest(String method, URI uri, String protocol, Map<String, List<String>> headers) {
        this.method = method;
        this.uri = uri;
        this.protocol = protocol;
        this.headers = headers;
    }

    @Override
    public String getName() {
        return "Request";
    }

    @Override
    public void appendJson(JsonStreamWriter jsonStreamWriter) throws IOException {
        jsonStreamWriter.beginObject().namedStringValueRaw("method", this.method.toString()).separator().namedStringValue("uri", this.uri.toString()).separator().namedStringValue("protocol", this.protocol);
        if (!this.headers.isEmpty()) {
            jsonStreamWriter.separator().name("headers").beginObject();
            boolean first = true;
            for (String name : this.headers.keySet()) {
                for (String value : this.headers.get(name)) {
                    if (value == null) continue;
                    if (!first) {
                        jsonStreamWriter.separator();
                    }
                    first = false;
                    jsonStreamWriter.namedStringValue(name, value);
                }
            }
            jsonStreamWriter.endObject();
        }
        jsonStreamWriter.endObject();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        writer.append("<h2>Request Method</h2>\n").append("<p>").append(this.method).append("</p>\n").append("<h2>Request URI</h2>\n").append("<p>").append(ODataDebugResponseWrapper.escapeHtml(this.uri.toString())).append("</p>\n").append("<h2>Request Protocol</h2>\n").append("<p>").append(this.protocol).append("</p>\n");
        writer.append("<h2>Request Headers</h2>\n").append("<table>\n<thead>\n").append("<tr><th class=\"name\">Name</th><th class=\"value\">Value</th></tr>\n").append("</thead>\n<tbody>\n");
        for (String name : this.headers.keySet()) {
            for (String value : this.headers.get(name)) {
                if (value == null) continue;
                writer.append("<tr><td class=\"name\">").append(name).append("</td>").append("<td class=\"value\">").append(ODataDebugResponseWrapper.escapeHtml(value)).append("</td></tr>\n");
            }
        }
        writer.append("</tbody>\n</table>\n");
    }
}

