/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.EdmDateTime;

public class EdmDateTimeOffset
extends AbstractSimpleType {
    private static final Pattern PATTERN = Pattern.compile("\\p{Digit}{1,4}-\\p{Digit}{1,2}-\\p{Digit}{1,2}T\\p{Digit}{1,2}:\\p{Digit}{1,2}(?::\\p{Digit}{1,2}(?:\\.\\p{Digit}{1,7})?)?(Z|([-+]\\p{Digit}{1,2}:\\p{Digit}{2}))?");
    private static final Pattern JSON_PATTERN = Pattern.compile("/Date\\((-?\\p{Digit}+)(?:(\\+|-)(\\p{Digit}{1,4}))?\\)/");
    private static final EdmDateTimeOffset instance = new EdmDateTimeOffset();

    public static EdmDateTimeOffset getInstance() {
        return instance;
    }

    @Override
    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Matcher matcher;
        if (literalKind == EdmLiteralKind.URI) {
            if (value.length() > 16 && value.startsWith("datetimeoffset'") && value.endsWith("'")) {
                return this.internalValueOfString(value.substring(15, value.length() - 1), EdmLiteralKind.DEFAULT, facets, returnType);
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
        }
        Calendar dateTimeValue = null;
        if (literalKind == EdmLiteralKind.JSON && (matcher = JSON_PATTERN.matcher(value)).matches()) {
            long millis;
            try {
                millis = Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
            }
            String timeZone = "GMT";
            if (matcher.group(2) != null) {
                int offsetInMinutes = Integer.parseInt(matcher.group(3));
                if (offsetInMinutes >= 1440) {
                    throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
                }
                if (offsetInMinutes != 0) {
                    timeZone = timeZone + matcher.group(2) + String.valueOf(offsetInMinutes / 60) + ":" + String.format("%02d", offsetInMinutes % 60);
                    millis -= (long)((matcher.group(2).equals("+") ? 1 : -1) * offsetInMinutes * 60 * 1000);
                }
            }
            dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
            dateTimeValue.clear();
            dateTimeValue.setTimeInMillis(millis);
        }
        if (dateTimeValue == null) {
            matcher = PATTERN.matcher(value);
            if (!matcher.matches()) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            }
            String timeZoneOffset = matcher.group(1) != null && matcher.group(2) != null && !matcher.group(2).matches("[-+]0+:0+") ? matcher.group(2) : null;
            dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT" + timeZoneOffset));
            if (dateTimeValue.get(15) == 0 && timeZoneOffset != null) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            }
            dateTimeValue.clear();
            EdmDateTime.parseLiteral(value.substring(0, matcher.group(1) == null ? value.length() : matcher.start(1)), facets, dateTimeValue);
        }
        if (returnType.isAssignableFrom(Calendar.class)) {
            return returnType.cast(dateTimeValue);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(dateTimeValue.getTimeInMillis());
        }
        if (returnType.isAssignableFrom(Date.class)) {
            return returnType.cast(dateTimeValue.getTime());
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        int offset;
        Calendar dateTimeValue;
        Long milliSeconds;
        if (value instanceof Date) {
            milliSeconds = ((Date)value).getTime();
            dateTimeValue = Calendar.getInstance();
            dateTimeValue.setTime((Date)value);
            offset = dateTimeValue.get(15) + dateTimeValue.get(16);
        } else if (value instanceof Calendar) {
            dateTimeValue = (Calendar)((Calendar)value).clone();
            milliSeconds = dateTimeValue.getTimeInMillis();
            offset = dateTimeValue.get(15) + dateTimeValue.get(16);
        } else if (value instanceof Long) {
            milliSeconds = (Long)value;
            offset = 0;
        } else {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
        }
        milliSeconds = milliSeconds + (long)offset;
        int offsetInMinutes = offset / 60 / 1000;
        if (literalKind == EdmLiteralKind.JSON) {
            return "/Date(" + milliSeconds + (offset == 0 ? "" : String.format("%+05d", offsetInMinutes)) + ")/";
        }
        String localTimeString = EdmDateTime.getInstance().valueToString(milliSeconds, EdmLiteralKind.DEFAULT, facets);
        int offsetHours = offsetInMinutes / 60;
        int offsetMinutes = Math.abs(offsetInMinutes % 60);
        String offsetString = offset == 0 ? "Z" : String.format("%+03d:%02d", offsetHours, offsetMinutes);
        return localTimeString + offsetString;
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return "datetimeoffset'" + literal + "'";
    }
}

