/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.UUID;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;

public class EdmGuid
extends AbstractSimpleType {
    private static final String PATTERN = "\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}";
    private static final EdmGuid instance = new EdmGuid();

    public static EdmGuid getInstance() {
        return instance;
    }

    @Override
    public Class<?> getDefaultType() {
        return UUID.class;
    }

    @Override
    public boolean validate(String value, EdmLiteralKind literalKind, EdmFacets facets) {
        return value == null ? facets == null || facets.isNullable() == null || facets.isNullable().booleanValue() : this.validateLiteral(value, literalKind);
    }

    private boolean validateLiteral(String value, EdmLiteralKind literalKind) {
        return value.matches(literalKind == EdmLiteralKind.URI ? this.toUriLiteral(PATTERN) : PATTERN);
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        if (!this.validateLiteral(value, literalKind)) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
        }
        UUID result = UUID.fromString(literalKind == EdmLiteralKind.URI ? value.substring(5, value.length() - 1) : value);
        if (returnType.isAssignableFrom(UUID.class)) {
            return returnType.cast(result);
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof UUID) {
            return ((UUID)value).toString();
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
    }

    @Override
    public String toUriLiteral(String literal) {
        return "guid'" + literal + "'";
    }
}

