/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNamed;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;

public abstract class EdmNamedImplProv
implements EdmNamed {
    private static final Pattern PATTERN_VALID_NAME = Pattern.compile("^[:A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\x10000-\\xEFFFF][:A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]*\\Z");
    protected EdmImplProv edm;
    private String name;

    public EdmNamedImplProv(EdmImplProv edm, String name) throws EdmException {
        this.edm = edm;
        this.name = this.getValidatedName(name);
    }

    @Override
    public String getName() throws EdmException {
        return this.name;
    }

    private String getValidatedName(String name) throws EdmException {
        Matcher matcher = PATTERN_VALID_NAME.matcher(name);
        if (matcher.matches()) {
            return name;
        }
        throw new EdmException(EdmException.COMMON);
    }
}

