/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.rest;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataInternalServerErrorException;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.rest.MERGE;
import org.apache.olingo.odata2.core.rest.ODataExceptionWrapper;
import org.apache.olingo.odata2.core.rest.PATCH;
import org.apache.olingo.odata2.core.rest.RestUtil;
import org.apache.olingo.odata2.core.rest.SubLocatorParameter;

public final class ODataSubLocator {
    private ODataServiceFactory serviceFactory;
    private ODataRequest request;
    private HttpServletRequest httpRequest;

    @GET
    public Response handleGet() throws ODataException {
        return this.handle(ODataHttpMethod.GET);
    }

    @PUT
    public Response handlePut() throws ODataException {
        return this.handle(ODataHttpMethod.PUT);
    }

    @PATCH
    public Response handlePatch() throws ODataException {
        return this.handle(ODataHttpMethod.PATCH);
    }

    @MERGE
    public Response handleMerge() throws ODataException {
        return this.handle(ODataHttpMethod.MERGE);
    }

    @DELETE
    public Response handleDelete() throws ODataException {
        return this.handle(ODataHttpMethod.DELETE);
    }

    @POST
    public Response handlePost(@HeaderParam(value="X-HTTP-Method") String xHttpMethod) throws ODataException {
        Response response = xHttpMethod == null ? this.handle(ODataHttpMethod.POST) : ("MERGE".equals(xHttpMethod) ? this.handle(ODataHttpMethod.MERGE) : ("PATCH".equals(xHttpMethod) ? this.handle(ODataHttpMethod.PATCH) : ("DELETE".equals(xHttpMethod) ? this.handle(ODataHttpMethod.DELETE) : ("PUT".equals(xHttpMethod) ? this.handle(ODataHttpMethod.PUT) : ("GET".equals(xHttpMethod) ? this.handle(ODataHttpMethod.GET) : ("POST".equals(xHttpMethod) ? this.handle(ODataHttpMethod.POST) : ("HEAD".equals(xHttpMethod) ? this.handleHead() : ("OPTIONS".equals(xHttpMethod) ? this.handleOptions() : this.returnNotImplementedResponse(ODataNotImplementedException.TUNNELING)))))))));
        return response;
    }

    private Response returnNotImplementedResponse(MessageReference messageReference) {
        return this.returnException(new ODataNotImplementedException(messageReference));
    }

    private Response returnException(ODataMessageException messageException) {
        ODataContextImpl context = new ODataContextImpl(this.request, this.serviceFactory);
        context.setRequest(this.request);
        context.setAcceptableLanguages(this.request.getAcceptableLanguages());
        context.setPathInfo(this.request.getPathInfo());
        context.setServiceFactory(this.serviceFactory);
        context.setParameter("~httpRequestObject", this.httpRequest);
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(context, this.request.getQueryParameters(), this.request.getAcceptHeaders());
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse(messageException);
        return RestUtil.convertResponse(response);
    }

    private Response returnNoServiceResponse(MessageReference messageReference) {
        return this.returnException(new ODataInternalServerErrorException(messageReference));
    }

    @OPTIONS
    public Response handleOptions() throws ODataException {
        return this.returnNotImplementedResponse(ODataNotImplementedException.COMMON);
    }

    @HEAD
    public Response handleHead() throws ODataException {
        return this.returnNotImplementedResponse(ODataNotImplementedException.COMMON);
    }

    private Response handle(ODataHttpMethod method) throws ODataException {
        this.request = ODataRequest.fromRequest(this.request).method(method).build();
        ODataContextImpl context = new ODataContextImpl(this.request, this.serviceFactory);
        context.setParameter("~httpRequestObject", this.httpRequest);
        ODataService service = this.serviceFactory.createService(context);
        if (service == null) {
            return this.returnNoServiceResponse(ODataInternalServerErrorException.NOSERVICE);
        }
        service.getProcessor().setContext(context);
        context.setService(service);
        ODataRequestHandler requestHandler = new ODataRequestHandler(this.serviceFactory, service, context);
        ODataResponse odataResponse = requestHandler.handle(this.request);
        Response response = RestUtil.convertResponse(odataResponse);
        return response;
    }

    public static ODataSubLocator create(SubLocatorParameter param) throws ODataException {
        ODataSubLocator subLocator = new ODataSubLocator();
        subLocator.serviceFactory = param.getServiceFactory();
        subLocator.request = ODataRequest.acceptableLanguages(param.getHttpHeaders().getAcceptableLanguages()).acceptHeaders(RestUtil.extractAcceptHeaders(param)).body(RestUtil.contentAsStream(RestUtil.extractRequestContent(param))).pathInfo(RestUtil.buildODataPathInfo(param)).allQueryParameters((Map<String, List<String>>)param.getUriInfo().getQueryParameters()).requestHeaders((Map<String, List<String>>)param.getHttpHeaders().getRequestHeaders()).contentType(RestUtil.extractRequestContentType(param).toContentTypeString()).build();
        subLocator.httpRequest = param.getServletRequest();
        return subLocator;
    }

    private ODataSubLocator() {
    }
}

