/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.configuration;

import com.google.inject.AbstractModule;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.onami.configuration.PropertiesIterator;
import org.apache.onami.configuration.PropertiesURLReader;
import org.apache.onami.configuration.binder.PropertyValueBindingBuilder;
import org.apache.onami.configuration.binder.XMLPropertiesFormatBindingBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationModule
extends AbstractModule {
    private static final String ENV_PREFIX = "env.";
    private static final String CLASSPATH_SCHEME = "classpath";
    private List<PropertiesURLReader> readers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void configure() {
        if (this.readers != null) {
            throw new IllegalStateException("Re-entry not allowed");
        }
        this.readers = new LinkedList<PropertiesURLReader>();
        this.bindConfigurations();
        try {
            for (PropertiesURLReader reader : this.readers) {
                try {
                    this.bindProperties(reader.readConfiguration());
                }
                catch (Exception e) {
                    this.addError("An error occurred while reading properties from '%s': %s", new Object[]{reader.getUrl(), e.getMessage()});
                }
            }
        }
        finally {
            this.readers = null;
        }
    }

    protected abstract void bindConfigurations();

    protected PropertyValueBindingBuilder bindProperty(final String name) {
        ConfigurationModule.checkNotNull(name, "Property name cannot be null.", new Object[0]);
        return new PropertyValueBindingBuilder(){

            public void toValue(String value) {
                ConfigurationModule.checkNotNull(value, "Null value not admitted for property '%s's", new Object[]{name});
                ConfigurationModule.this.bindConstant().annotatedWith((Annotation)Names.named((String)name)).to(value);
            }
        };
    }

    protected void bindProperties(Properties properties) {
        ConfigurationModule.checkNotNull(properties, "Parameter 'properties' must be not null", new Object[0]);
        this.bindProperties(PropertiesIterator.newPropertiesIterator(properties));
    }

    protected void bindProperties(Iterable<Map.Entry<String, String>> properties) {
        ConfigurationModule.checkNotNull(properties, "Parameter 'properties' must be not null", new Object[0]);
        this.bindProperties(properties.iterator());
    }

    protected void bindProperties(Iterator<Map.Entry<String, String>> properties) {
        ConfigurationModule.checkNotNull(properties, "Parameter 'properties' must be not null", new Object[0]);
        while (properties.hasNext()) {
            Map.Entry<String, String> property = properties.next();
            this.bindProperty(property.getKey()).toValue(property.getValue());
        }
    }

    protected void bindSystemProperties() {
        this.bindProperties(System.getProperties());
    }

    protected void bindProperties(Map<String, String> properties) {
        ConfigurationModule.checkNotNull(properties, "Parameter 'properties' must be not null", new Object[0]);
        this.bindProperties(PropertiesIterator.newPropertiesIterator(properties));
    }

    protected void bindEnvironmentVariables() {
        this.bindProperties(PropertiesIterator.newPropertiesIterator(ENV_PREFIX, System.getenv()));
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(File propertiesResource) {
        ConfigurationModule.checkNotNull(propertiesResource, "Parameter 'propertiesResource' must be not null", new Object[0]);
        return this.bindProperties(propertiesResource.toURI());
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(URI propertiesResource) {
        ConfigurationModule.checkNotNull(propertiesResource, "Parameter 'propertiesResource' must be not null", new Object[0]);
        if (CLASSPATH_SCHEME.equals(propertiesResource.getScheme())) {
            String path = propertiesResource.getPath();
            if (propertiesResource.getHost() != null) {
                path = propertiesResource.getHost() + path;
            }
            return this.bindProperties(path);
        }
        try {
            return this.bindProperties(propertiesResource.toURL());
        }
        catch (MalformedURLException e) {
            throw new ProvisionException(String.format("URI '%s' not supported: %s", propertiesResource, e.getMessage()));
        }
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(String classPathResource) {
        return this.bindProperties(classPathResource, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(String classPathResource, ClassLoader classLoader) {
        ConfigurationModule.checkNotNull(classPathResource, "Parameter 'classPathResource' must be not null", new Object[0]);
        ConfigurationModule.checkNotNull(classLoader, "Parameter 'classLoader' must be not null", new Object[0]);
        String resourceURL = classPathResource;
        if ('/' == classPathResource.charAt(0)) {
            resourceURL = classPathResource.substring(1);
        }
        URL url = classLoader.getResource(resourceURL);
        ConfigurationModule.checkNotNull(url, "ClassPath resource '%s' not found, make sure it is in the ClassPath or you're using the right ClassLoader", classPathResource);
        return this.bindProperties(url);
    }

    protected XMLPropertiesFormatBindingBuilder bindProperties(URL propertiesResource) {
        ConfigurationModule.checkNotNull(propertiesResource, "parameter 'propertiesResource' must not be null", new Object[0]);
        PropertiesURLReader reader = new PropertiesURLReader(propertiesResource);
        this.readers.add(reader);
        return reader;
    }

    private static void checkNotNull(Object object, String messageFormat, Object ... args) {
        if (object == null) {
            throw new IllegalArgumentException(String.format(messageFormat, args));
        }
    }
}

