/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.configuration;

import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.onami.configuration.variables.AntStyleParser;
import org.apache.onami.configuration.variables.Parser;
import org.apache.onami.configuration.variables.VariablesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnamiVariablesExpander
extends AbstractModule {
    private final TypeLiteral<String> stringLiteral = new TypeLiteral<String>(){};
    private final Parser parser;
    private final List<Element> elements;

    public static Module expandVariables(Module ... baseModules) {
        return OnamiVariablesExpander.expandVariables(Arrays.asList(baseModules));
    }

    public static Module expandVariables(Parser parser, Module ... baseModules) {
        return OnamiVariablesExpander.expandVariables(parser, Arrays.asList(baseModules));
    }

    public static Module expandVariables(Iterable<? extends Module> baseModules) {
        return OnamiVariablesExpander.expandVariables((Parser)new AntStyleParser(), baseModules);
    }

    public static Module expandVariables(Parser parser, Iterable<? extends Module> baseModules) {
        return Modules.override(baseModules).with(new Module[]{new OnamiVariablesExpander(parser, Elements.getElements(baseModules))});
    }

    private OnamiVariablesExpander(Parser parser, List<Element> elements) {
        this.parser = parser;
        this.elements = elements;
    }

    protected void configure() {
        final VariablesMap variablesMap = new VariablesMap(this.parser);
        for (Element element : this.elements) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    Key bindingKey = binding.getKey();
                    if (OnamiVariablesExpander.this.stringLiteral.equals((Object)bindingKey.getTypeLiteral()) && bindingKey.getAnnotation() != null && (Named.class.isAssignableFrom(bindingKey.getAnnotationType()) || javax.inject.Named.class.isAssignableFrom(bindingKey.getAnnotationType()))) {
                        String propertyKey = Named.class.isAssignableFrom(bindingKey.getAnnotationType()) ? ((Named)bindingKey.getAnnotation()).value() : ((javax.inject.Named)bindingKey.getAnnotation()).value();
                        String propertyValue = (String)binding.getProvider().get();
                        variablesMap.put(propertyKey, propertyValue);
                    }
                    return (Void)super.visit(binding);
                }
            });
        }
        for (Map.Entry entry : variablesMap.entrySet()) {
            this.bindConstant().annotatedWith((Annotation)Names.named((String)((String)entry.getKey()))).to((String)entry.getValue());
        }
    }
}

