/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.configuration.variables;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.onami.configuration.variables.AntStyleParser;
import org.apache.onami.configuration.variables.Parser;
import org.apache.onami.configuration.variables.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariablesMap
implements Map<String, String> {
    private final Parser parser;
    private final Map<String, Resolver> resolvers = new HashMap<String, Resolver>();
    private final Map<String, String> data = new HashMap<String, String>();

    public VariablesMap() {
        this(new AntStyleParser());
    }

    public VariablesMap(Parser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("Parser used to resolve input variables cannot be null.");
        }
        this.parser = parser;
    }

    @Override
    public void clear() {
        this.resolvers.clear();
        this.data.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.data.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.data.keySet();
    }

    @Override
    public String put(String key, String value) {
        this.putValue(key, value);
        this.resolveVariables();
        return this.data.get(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        for (Map.Entry<? extends String, ? extends String> entry : t.entrySet()) {
            this.putValue(entry.getKey(), entry.getValue());
        }
        this.resolveVariables();
    }

    public void putAll(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.putValue(entry.getKey().toString(), entry.getValue().toString());
        }
        this.resolveVariables();
    }

    private void putValue(String key, String value) {
        this.data.put(key, value);
        Resolver resolver = this.parser.parse(value);
        if (resolver.needsResolving()) {
            this.resolvers.put(key, resolver);
        } else if (this.resolvers.containsKey(key)) {
            this.resolvers.remove(key);
        }
    }

    private void resolveVariables() {
        for (Map.Entry<String, Resolver> entry : this.resolvers.entrySet()) {
            this.data.put(entry.getKey(), entry.getValue().resolve(this.data));
        }
    }

    @Override
    public String remove(Object key) {
        String value = null;
        if (this.containsKey(key)) {
            value = this.data.remove(key);
            this.resolvers.remove(key);
            this.resolveVariables();
        }
        return value;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Collection<String> values() {
        return this.data.values();
    }

    public String toString() {
        return this.data.toString();
    }
}

