/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.util.Version;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseTokenStreamFactory {
    protected Map<String, String> args;
    protected Version luceneMatchVersion = null;
    public static final Logger log = LoggerFactory.getLogger(BaseTokenStreamFactory.class);

    BaseTokenStreamFactory() {
    }

    public void init(Map<String, String> args) {
        this.args = args;
        String matchVersion = args.get("luceneMatchVersion");
        if (matchVersion != null) {
            this.luceneMatchVersion = Config.parseLuceneVersionString(matchVersion);
        }
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    protected final void assureMatchVersion() {
        if (this.luceneMatchVersion == null) {
            throw new RuntimeException("Configuration Error: Factory '" + this.getClass().getName() + "' needs a 'luceneMatchVersion' parameter");
        }
        if (!this.luceneMatchVersion.onOrAfter(Version.LUCENE_30)) {
            log.warn(this.getClass().getSimpleName() + " is using deprecated " + this.luceneMatchVersion + " emulation. You should at some point declare and reindex to at least 3.0, because " + "2.x emulation is deprecated and will be removed in 4.0");
        }
    }

    protected final void warnDeprecated(String message) {
        log.warn(this.getClass().getSimpleName() + " is deprecated. " + message);
    }

    protected int getInt(String name) {
        return this.getInt(name, -1, false);
    }

    protected int getInt(String name, int defaultVal) {
        return this.getInt(name, defaultVal, true);
    }

    protected int getInt(String name, int defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new RuntimeException("Configuration Error: missing parameter '" + name + "'");
        }
        return Integer.parseInt(s);
    }

    protected boolean getBoolean(String name, boolean defaultVal) {
        return this.getBoolean(name, defaultVal, true);
    }

    protected boolean getBoolean(String name, boolean defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new RuntimeException("Configuration Error: missing parameter '" + name + "'");
        }
        return Boolean.parseBoolean(s);
    }

    protected CharArraySet getWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase) throws IOException {
        this.assureMatchVersion();
        List files = StrUtils.splitFileNames((String)wordFiles);
        CharArraySet words = null;
        if (files.size() > 0) {
            words = new CharArraySet(this.luceneMatchVersion, files.size() * 10, ignoreCase);
            for (String file : files) {
                List wlist = loader.getLines(file.trim());
                words.addAll((Collection)StopFilter.makeStopSet((Version)this.luceneMatchVersion, (List)wlist, (boolean)ignoreCase));
            }
        }
        return words;
    }
}

