/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal;

import java.util.List;
import org.mockito.internal.MockHandlerInterface;
import org.mockito.internal.MockitoInvocationHandler;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.MatchersBinder;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.mockito.internal.stubbing.VoidMethodStubbableImpl;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.VoidMethodStubbable;
import org.mockito.verification.VerificationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHandler<T>
implements MockitoInvocationHandler,
MockHandlerInterface<T> {
    private static final long serialVersionUID = -2917871070982574165L;
    InvocationContainerImpl invocationContainerImpl;
    MatchersBinder matchersBinder = new MatchersBinder();
    MockingProgress mockingProgress = new ThreadSafeMockingProgress();
    private final MockSettingsImpl mockSettings;

    public MockHandler(MockSettingsImpl mockSettings) {
        this.mockSettings = mockSettings;
        this.mockingProgress = new ThreadSafeMockingProgress();
        this.matchersBinder = new MatchersBinder();
        this.invocationContainerImpl = new InvocationContainerImpl(this.mockingProgress);
    }

    MockHandler() {
        this(new MockSettingsImpl());
    }

    public MockHandler(MockHandlerInterface<T> oldMockHandler) {
        this(oldMockHandler.getMockSettings());
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        if (this.invocationContainerImpl.hasAnswersForStubbing()) {
            InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
            this.invocationContainerImpl.setMethodForStubbing(invocationMatcher);
            return null;
        }
        VerificationMode verificationMode = this.mockingProgress.pullVerificationMode();
        InvocationMatcher invocationMatcher = this.matchersBinder.bindMatchers(this.mockingProgress.getArgumentMatcherStorage(), invocation);
        this.mockingProgress.validateState();
        if (verificationMode != null && verificationMode instanceof MockAwareVerificationMode && ((MockAwareVerificationMode)verificationMode).getMock() == invocation.getMock()) {
            VerificationDataImpl data = new VerificationDataImpl(this.invocationContainerImpl.getInvocations(), invocationMatcher);
            verificationMode.verify(data);
            return null;
        }
        this.invocationContainerImpl.setInvocationForPotentialStubbing(invocationMatcher);
        OngoingStubbingImpl ongoingStubbing = new OngoingStubbingImpl(this.invocationContainerImpl);
        this.mockingProgress.reportOngoingStubbing(ongoingStubbing);
        StubbedInvocationMatcher stubbedInvocation = this.invocationContainerImpl.findAnswerFor(invocation);
        if (stubbedInvocation != null) {
            stubbedInvocation.captureArgumentsFrom(invocation);
            return stubbedInvocation.answer(invocation);
        }
        Object ret = this.mockSettings.getDefaultAnswer().answer(invocation);
        this.invocationContainerImpl.resetInvocationForPotentialStubbing(invocationMatcher);
        return ret;
    }

    @Override
    public VoidMethodStubbable<T> voidMethodStubbable(T mock) {
        return new VoidMethodStubbableImpl<T>(mock, this.invocationContainerImpl);
    }

    @Override
    public MockSettingsImpl getMockSettings() {
        return this.mockSettings;
    }

    @Override
    public void setAnswersForStubbing(List<Answer> answers) {
        this.invocationContainerImpl.setAnswersForStubbing(answers);
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.invocationContainerImpl;
    }
}

