/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import org.mockito.ReturnValues;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.configuration.DefaultMockitoConfiguration;
import org.mockito.configuration.IMockitoConfiguration;
import org.mockito.internal.configuration.ClassPathLoader;
import org.mockito.stubbing.Answer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalConfiguration
implements IMockitoConfiguration {
    private static ThreadLocal<IMockitoConfiguration> globalConfiguration = new ThreadLocal();

    IMockitoConfiguration getIt() {
        return globalConfiguration.get();
    }

    public GlobalConfiguration() {
        if (globalConfiguration.get() == null) {
            globalConfiguration.set(this.createConfig());
        }
    }

    private IMockitoConfiguration createConfig() {
        DefaultMockitoConfiguration defaultConfiguration = new DefaultMockitoConfiguration();
        IMockitoConfiguration config = new ClassPathLoader().loadConfiguration();
        if (config != null) {
            return config;
        }
        return defaultConfiguration;
    }

    public static void validate() {
        new GlobalConfiguration();
    }

    @Override
    public ReturnValues getReturnValues() {
        return globalConfiguration.get().getReturnValues();
    }

    @Override
    public AnnotationEngine getAnnotationEngine() {
        return globalConfiguration.get().getAnnotationEngine();
    }

    @Override
    public boolean cleansStackTrace() {
        return globalConfiguration.get().cleansStackTrace();
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return globalConfiguration.get().getDefaultAnswer();
    }
}

