/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return null;
    }

    @Override
    public void process(Class<?> context, Object testClass) {
        Field[] fields;
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class)) continue;
            this.assertNoAnnotations(Spy.class, field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            boolean wasAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object instance = field.get(testClass);
                if (instance == null) {
                    throw new MockitoException("Cannot create a @Spy for '" + field.getName() + "' field because the *instance* is missing\n" + "The instance must be created *before* initMocks();\n" + "Example of correct usage of @Spy:\n" + "   @Spy List mock = new LinkedList();\n" + "   //also, don't forget about MockitoAnnotations.initMocks();");
                }
                if (new MockUtil().isMock(instance)) {
                    Mockito.reset(instance);
                    continue;
                }
                field.set(testClass, Mockito.spy(instance));
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), e);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
        }
    }

    void assertNoAnnotations(Class annotation, Field field, Class ... undesiredAnnotations) {
        for (Class u : undesiredAnnotations) {
            if (!field.isAnnotationPresent(u)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(annotation.getSimpleName(), annotation.getClass().getSimpleName());
        }
    }
}

