/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;

public class Only
implements VerificationMode {
    private final InvocationsFinder finder = new InvocationsFinder();
    private final InvocationMarker marker = new InvocationMarker();
    private final Reporter reporter = new Reporter();

    public void verify(VerificationData data) {
        InvocationMatcher wantedMatcher = data.getWanted();
        List<Invocation> invocations = data.getAllInvocations();
        List<Invocation> chunk = this.finder.findInvocations(invocations, wantedMatcher);
        if (invocations.size() != 1 && chunk.size() > 0) {
            this.marker.markVerified(chunk.get(0), (CapturesArgumensFromInvocation)wantedMatcher);
            Invocation unverified = this.finder.findFirstUnverified(invocations);
            this.reporter.noMoreInteractionsWanted(unverified);
        } else if (invocations.size() != 1 || chunk.size() == 0) {
            this.reporter.wantedButNotInvoked(wantedMatcher);
        }
    }
}

