/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.impl.DAAdvertisement;
import ch.ethz.iks.slp.impl.PlatformAbstraction;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPConfiguration;
import ch.ethz.iks.slp.impl.SLPDaemon;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.ServiceRequest;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SLPCore {
    private static volatile boolean isMulticastSocketInitialized;
    private static volatile boolean isInitialized;
    protected static PlatformAbstraction platform;
    static final Locale DEFAULT_LOCALE;
    static final int SLP_PORT;
    static final int SLP_RESERVED_PORT = 427;
    static final String SLP_MCAST_ADDRESS = "239.255.255.253";
    static final InetAddress MCAST_ADDRESS;
    static final SLPConfiguration CONFIG;
    static final boolean TCP_ONLY = false;
    static final String SLP_DA_TYPE = "service:directory-agent";
    static String[] myIPs;
    static final boolean noDiscovery;
    protected static final Constructor advertiser;
    protected static final Constructor locator;
    private static final Constructor daemonConstr;
    private static SLPDaemon daemon;
    private static Thread multicastThread;
    private static MulticastSocket mtcSocket;
    private static short nextXid;
    private static Map replyListeners;
    static Map dAs;
    static Map dASPIs;
    static InetAddress LOCALHOST;
    static /* synthetic */ Class class$java$util$Locale;

    protected static void init() {
        Object object;
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        platform.logDebug("jSLP is running on the following interfaces: " + Arrays.asList(myIPs));
        platform.logDebug("jSLP is using port: " + SLP_PORT);
        String[] stringArray = CONFIG.getDaAddresses();
        if (stringArray == null) {
            if (noDiscovery) {
                throw new IllegalArgumentException("Configuration 'net.slp.noDaDiscovery=true' requires a non-empty list of preconfigured DAs");
            }
        } else {
            try {
                object = new ServiceRequest(new ServiceType(SLP_DA_TYPE), null, null, null);
                ((SLPMessage)object).port = SLP_PORT;
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        ((SLPMessage)object).address = InetAddress.getByName(stringArray[i]);
                        DAAdvertisement dAAdvertisement = (DAAdvertisement)SLPCore.sendMessage((SLPMessage)object, true);
                        String[] stringArray2 = dAAdvertisement.scopeList.toArray(new String[dAAdvertisement.scopeList.size()]);
                        for (int j = 0; j < stringArray2.length; ++j) {
                            platform.logDebug("jSLP is adding DA, " + stringArray[i] + " for the Scope, " + stringArray2[j]);
                            SLPUtils.addValue(dAs, stringArray2[i].toLowerCase(), stringArray[i]);
                        }
                        continue;
                    }
                    catch (ServiceLocationException serviceLocationException) {
                        platform.logWarning("Error communitcating with " + stringArray[i], serviceLocationException);
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        platform.logWarning("Unknown net.slp.DAAddresses address: " + stringArray[i], unknownHostException);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                platform.logDebug("May never happen", illegalArgumentException);
            }
        }
        if (!noDiscovery) {
            try {
                object = new ArrayList<String>();
                object.add("default");
                SLPCore.daLookup((List)object);
            }
            catch (Exception exception) {
                platform.logError("Exception in initial DA lookup", exception);
            }
        }
    }

    protected static void initMulticastSocket() {
        if (isMulticastSocketInitialized) {
            return;
        }
        isMulticastSocketInitialized = true;
        try {
            mtcSocket = new MulticastSocket(SLP_PORT);
            mtcSocket.setTimeToLive(CONFIG.getMcastTTL());
            if (CONFIG.getInterfaces() != null) {
                try {
                    mtcSocket.setInterface(InetAddress.getByName(myIPs[0]));
                }
                catch (Throwable throwable) {
                    platform.logDebug("Setting multicast socket interface to " + myIPs[0] + " failed.", throwable);
                }
            }
            mtcSocket.joinGroup(MCAST_ADDRESS);
        }
        catch (BindException bindException) {
            platform.logError(bindException.getMessage(), bindException);
            throw new RuntimeException("You have to be root to open port " + SLP_PORT);
        }
        catch (Exception exception) {
            platform.logError(exception.getMessage(), exception);
        }
        multicastThread = new Thread(){

            public void run() {
                byte[] byArray = new byte[CONFIG.getMTU()];
                while (true) {
                    try {
                        while (true) {
                            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                            mtcSocket.receive(datagramPacket);
                            SLPMessage sLPMessage = SLPCore.handleMessage(SLPMessage.parse(datagramPacket.getAddress(), datagramPacket.getPort(), new DataInputStream(new ByteArrayInputStream(datagramPacket.getData())), false));
                            if (sLPMessage == null) continue;
                            byte[] byArray2 = sLPMessage.getBytes();
                            DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length, sLPMessage.address, sLPMessage.port);
                            mtcSocket.send(datagramPacket2);
                            platform.logDebug("SEND (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage.toString());
                        }
                    }
                    catch (Exception exception) {
                        platform.logError("Exception in Multicast Receiver Thread", exception);
                        continue;
                    }
                    break;
                }
            }
        };
        multicastThread.start();
        if (daemonConstr != null) {
            try {
                daemon = (SLPDaemon)daemonConstr.newInstance(null);
            }
            catch (Exception exception) {
                daemon = null;
            }
        }
    }

    static InetAddress getMyIP() {
        try {
            return InetAddress.getByName(myIPs[0]);
        }
        catch (UnknownHostException unknownHostException) {
            platform.logError("Unknown net.slp.interfaces address: " + myIPs[0], unknownHostException);
            return null;
        }
    }

    public static List findScopes() throws ServiceLocationException {
        return new ArrayList(dAs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SLPMessage handleMessage(SLPMessage sLPMessage) throws ServiceLocationException {
        if (sLPMessage == null) {
            return null;
        }
        platform.logTraceMessage("RECEIVED (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage);
        switch (sLPMessage.funcID) {
            case 8: {
                if (noDiscovery) {
                    platform.logTraceDrop("DROPPED (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage.toString() + "(reason: noDADiscovery is set");
                    return null;
                }
                DAAdvertisement dAAdvertisement = (DAAdvertisement)sLPMessage;
                if (dAAdvertisement.errorCode != 0) {
                    platform.logTraceDrop("DROPPED DAADvertisement (" + dAAdvertisement.address + ":" + dAAdvertisement.port + ") " + dAAdvertisement.toString() + "(reason: " + dAAdvertisement.errorCode + " != 0");
                    return null;
                }
                if (dAAdvertisement.url != dAAdvertisement.address.getHostAddress()) {
                    dAAdvertisement.url = dAAdvertisement.address.getHostAddress();
                }
                if (dAAdvertisement.statelessBootTimestamp == 0) {
                    Iterator iterator = dAAdvertisement.scopeList.iterator();
                    while (iterator.hasNext()) {
                        String string = ((String)iterator.next()).toLowerCase();
                        SLPUtils.removeValue(dAs, string.toLowerCase(), dAAdvertisement.url);
                        dASPIs.remove(dAAdvertisement.url);
                    }
                } else {
                    Object object = dAAdvertisement.scopeList.iterator();
                    while (object.hasNext()) {
                        String string = ((String)object.next()).toLowerCase();
                        SLPUtils.addValue(dAs, string, dAAdvertisement.url);
                        if (!CONFIG.getSecurityEnabled()) continue;
                        dASPIs.put(dAAdvertisement.url, SLPMessage.stringToList(dAAdvertisement.spi, ","));
                    }
                    object = dAs;
                    synchronized (object) {
                        dAs.notifyAll();
                    }
                    if (daemon != null) {
                        daemon.newDaDiscovered(dAAdvertisement);
                    }
                }
                platform.logDebug("NEW DA LIST: " + dAs);
                return null;
            }
            case 2: 
            case 7: 
            case 10: {
                Map map = replyListeners;
                synchronized (map) {
                    List list = (List)replyListeners.get(new Integer(sLPMessage.xid));
                    if (list != null) {
                        List list2 = list;
                        synchronized (list2) {
                            list.add(sLPMessage);
                            list.notifyAll();
                        }
                        return null;
                    }
                    platform.logTraceReg("SRVTYPEREPLY recieved (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage.toString() + " but not replyListeners present anymore");
                }
                return null;
            }
            case 1: 
            case 6: 
            case 9: {
                for (int i = 0; i < myIPs.length; ++i) {
                    if (!((RequestMessage)sLPMessage).prevRespList.contains(myIPs[i])) continue;
                    platform.logTraceDrop("DROPPED (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage.toString() + "(udp multicast)");
                    return null;
                }
                if (daemon != null) {
                    return daemon.handleMessage(sLPMessage);
                }
                platform.logDebug("SRVTYPERQST recieved (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage.toString() + " but no SLPDaemon to handle the message present");
                return null;
            }
        }
        if (daemon != null) {
            return daemon.handleMessage(sLPMessage);
        }
        platform.logDebug("A message recieved (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage.toString() + " but no SLPDaemon to handle the message present");
        return null;
    }

    static short nextXid() {
        if (nextXid == 0) {
            nextXid = 1;
        }
        short s = nextXid;
        nextXid = (short)(s + 1);
        return s;
    }

    static void daLookup(List list) throws ServiceLocationException {
        int n;
        try {
            for (n = 0; n < myIPs.length; ++n) {
                InetAddress inetAddress = InetAddress.getByName(myIPs[n]);
                DatagramSocket datagramSocket = new DatagramSocket(0, inetAddress);
                ServiceRequest serviceRequest = new ServiceRequest(new ServiceType(SLP_DA_TYPE), list, null, DEFAULT_LOCALE);
                serviceRequest.xid = SLPCore.nextXid();
                serviceRequest.scopeList = list;
                serviceRequest.address = MCAST_ADDRESS;
                serviceRequest.multicast = true;
                byte[] byArray = serviceRequest.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, MCAST_ADDRESS, SLP_PORT);
                platform.logTraceMessage("SENT " + serviceRequest + "(udp multicast)");
                SLPCore.setupReceiverThread(datagramSocket, CONFIG.getWaitTime(), serviceRequest);
                try {
                    datagramSocket.send(datagramPacket);
                    continue;
                }
                catch (SocketException socketException) {
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(myIPs));
                    String string = myIPs[n];
                    arrayList.remove(string);
                    myIPs = arrayList.toArray(new String[arrayList.size()]);
                    platform.logDebug("Blacklisting IP " + string);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            platform.logDebug("May never happen, no filter set", illegalArgumentException);
        }
        catch (UnknownHostException unknownHostException) {
            platform.logWarning("Unknown net.slp.interfaces address: " + myIPs[n], unknownHostException);
            throw new ServiceLocationException(19, unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            platform.logWarning("Error connecting to: " + myIPs[n], iOException);
            throw new ServiceLocationException(19, iOException.getMessage());
        }
    }

    static ReplyMessage sendMessageTCP(SLPMessage sLPMessage) throws ServiceLocationException {
        try {
            if (sLPMessage.xid == 0) {
                sLPMessage.xid = SLPCore.nextXid();
            }
            Socket socket = new Socket(sLPMessage.address, sLPMessage.port);
            socket.setSoTimeout(CONFIG.getTCPTimeout());
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            sLPMessage.writeTo(dataOutputStream);
            ReplyMessage replyMessage = (ReplyMessage)SLPMessage.parse(sLPMessage.address, sLPMessage.port, dataInputStream, true);
            socket.close();
            return replyMessage;
        }
        catch (Exception exception) {
            throw new ServiceLocationException(19, exception.getMessage());
        }
    }

    static ReplyMessage sendMessage(SLPMessage sLPMessage, boolean bl) throws ServiceLocationException {
        if (sLPMessage.xid == 0) {
            sLPMessage.xid = SLPCore.nextXid();
        }
        if (sLPMessage.getSize() > CONFIG.getMTU()) {
            return SLPCore.sendMessageTCP(sLPMessage);
        }
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(CONFIG.getDatagramMaxWait());
            byte[] byArray = sLPMessage.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, sLPMessage.address, sLPMessage.port);
            byte[] byArray2 = new byte[CONFIG.getMTU()];
            DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length);
            datagramSocket.send(datagramPacket);
            platform.logTraceMessage("SENT (" + sLPMessage.address + ":" + sLPMessage.port + ") " + sLPMessage + " (via udp port " + datagramSocket.getLocalPort() + ")");
            if (!bl) {
                return null;
            }
            datagramSocket.receive(datagramPacket2);
            datagramSocket.close();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(datagramPacket2.getData()));
            ReplyMessage replyMessage = (ReplyMessage)SLPMessage.parse(datagramPacket2.getAddress(), datagramPacket2.getPort(), dataInputStream, false);
            return replyMessage;
        }
        catch (SocketException socketException) {
            throw new ServiceLocationException(17, socketException.getMessage());
        }
        catch (ProtocolException protocolException) {
            return SLPCore.sendMessageTCP(sLPMessage);
        }
        catch (IOException iOException) {
            platform.logError("Exception during sending of " + sLPMessage);
            platform.logError("to " + sLPMessage.address + ":" + sLPMessage.port);
            platform.logError("Exception:", iOException);
            throw new ServiceLocationException(19, iOException.getMessage());
        }
        catch (Throwable throwable) {
            platform.logDebug(throwable.getMessage(), throwable);
            throw new ServiceLocationException(1, throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List multicastConvergence(RequestMessage requestMessage) throws ServiceLocationException {
        try {
            Object object;
            Integer n;
            ArrayList arrayList;
            ArrayList<String> arrayList2;
            ArrayList<ReplyMessage> arrayList3;
            long l;
            block25: {
                l = System.currentTimeMillis();
                arrayList3 = new ArrayList<ReplyMessage>();
                arrayList2 = new ArrayList<String>();
                arrayList = new ArrayList();
                if (requestMessage.xid == 0) {
                    requestMessage.xid = SLPCore.nextXid();
                }
                n = new Integer(requestMessage.xid);
                object = replyListeners;
                synchronized (object) {
                    replyListeners.put(n, arrayList3);
                }
                requestMessage.port = SLP_PORT;
                requestMessage.prevRespList = new ArrayList();
                requestMessage.multicast = true;
                requestMessage.address = LOCALHOST;
                try {
                    arrayList3.add(SLPCore.sendMessageTCP(requestMessage));
                }
                catch (ServiceLocationException serviceLocationException) {
                    if (serviceLocationException.getErrorCode() == 19) break block25;
                    throw serviceLocationException;
                }
            }
            requestMessage.address = MCAST_ADDRESS;
            block17: for (int i = 0; i < myIPs.length; ++i) {
                InetAddress inetAddress = InetAddress.getByName(myIPs[i]);
                MulticastSocket multicastSocket = new MulticastSocket();
                multicastSocket.setInterface(inetAddress);
                multicastSocket.setTimeToLive(CONFIG.getMcastTTL());
                SLPCore.setupReceiverThread(multicastSocket, CONFIG.getMcastMaxWait(), requestMessage);
                long l2 = System.currentTimeMillis() + (long)CONFIG.getMcastMaxWait();
                int[] nArray = CONFIG.getMcastTimeouts();
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                boolean bl2 = false;
                long l3 = System.currentTimeMillis() + (long)nArray[n2];
                while (!Thread.currentThread().isInterrupted() && l2 > System.currentTimeMillis() && l3 > System.currentTimeMillis() && n2 < nArray.length && n3 < CONFIG.getConvergenceFailerCount()) {
                    requestMessage.prevRespList = arrayList2;
                    byte[] byArray = requestMessage.getBytes();
                    if (byArray.length > CONFIG.getMTU()) continue block17;
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(SLP_MCAST_ADDRESS), SLP_PORT);
                    try {
                        multicastSocket.send(datagramPacket);
                    }
                    catch (IOException iOException) {
                        continue block17;
                    }
                    platform.logTraceMessage("SENT " + requestMessage);
                    try {
                        Thread.sleep(nArray[n2]);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    ArrayList<ReplyMessage> arrayList4 = arrayList3;
                    synchronized (arrayList4) {
                        if (arrayList3.isEmpty()) {
                            ++n3;
                            l3 = System.currentTimeMillis() + (long)nArray[n2++];
                            continue;
                        }
                        while (!arrayList3.isEmpty()) {
                            object = (ReplyMessage)arrayList3.remove(0);
                            if (arrayList2.contains(((SLPMessage)object).address.getHostAddress())) continue;
                            if (SLPCore.isLocalResponder(((SLPMessage)object).address)) {
                                if (bl2) continue;
                                bl2 = true;
                            }
                            bl = true;
                            arrayList2.add(((SLPMessage)object).address.getHostAddress());
                            arrayList.addAll(((ReplyMessage)object).getResult());
                        }
                        if (!bl) {
                            ++n3;
                        } else {
                            bl = false;
                        }
                    }
                    l3 = System.currentTimeMillis() + (long)nArray[n2++];
                }
            }
            Map map = replyListeners;
            synchronized (map) {
                replyListeners.remove(n);
            }
            platform.logDebug("convergence for xid=" + requestMessage.xid + " finished after " + (System.currentTimeMillis() - l) + " ms, result: " + arrayList);
            return arrayList;
        }
        catch (IOException iOException) {
            platform.logDebug(iOException.getMessage(), iOException);
            throw new ServiceLocationException(19, iOException.getMessage());
        }
    }

    private static boolean isLocalResponder(InetAddress inetAddress) {
        for (int i = 0; i < myIPs.length; ++i) {
            if (!inetAddress.getHostAddress().equals(myIPs[i])) continue;
            return true;
        }
        return false;
    }

    private static void setupReceiverThread(final DatagramSocket datagramSocket, final long l, final SLPMessage sLPMessage) {
        new Thread(){

            public void run() {
                byte[] byArray = new byte[CONFIG.getMTU()];
                long l3 = System.currentTimeMillis() + l + 1000L;
                while (System.currentTimeMillis() < l3) {
                    try {
                        long l2 = l3 - System.currentTimeMillis();
                        int n = (int)(l2 < 0L ? 1L : l2);
                        datagramSocket.setSoTimeout(n);
                    }
                    catch (SocketException socketException) {
                        platform.logError("Exception in mcast receiver thread", socketException);
                        return;
                    }
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    try {
                        datagramSocket.receive(datagramPacket);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        platform.logDebug(iOException.getMessage(), iOException);
                        return;
                    }
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(datagramPacket.getData()));
                    try {
                        SLPCore.handleMessage(SLPMessage.parse(datagramPacket.getAddress(), datagramPacket.getPort(), dataInputStream, false));
                    }
                    catch (ProtocolException protocolException) {
                        try {
                            sLPMessage.address = datagramPacket.getAddress();
                            sLPMessage.port = datagramPacket.getPort();
                            sLPMessage.multicast = false;
                            SLPCore.handleMessage(SLPCore.sendMessageTCP(sLPMessage));
                        }
                        catch (ServiceLocationException serviceLocationException) {
                        }
                    }
                    catch (ServiceLocationException serviceLocationException) {
                        platform.logDebug(serviceLocationException.getMessage(), serviceLocationException);
                    }
                }
                datagramSocket.close();
            }
        }.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        SLPConfiguration sLPConfiguration;
        isMulticastSocketInitialized = false;
        isInitialized = false;
        DEFAULT_LOCALE = Locale.getDefault();
        replyListeners = new HashMap();
        dAs = new HashMap();
        dASPIs = new HashMap();
        try {
            LOCALHOST = InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        Class[] classArray = new Class[]{class$java$util$Locale == null ? (class$java$util$Locale = SLPCore.class$("java.util.Locale")) : class$java$util$Locale};
        Constructor<?> constructor = null;
        try {
            constructor = Class.forName("ch.ethz.iks.slp.impl.AdvertiserImpl").getConstructor(classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        advertiser = constructor;
        constructor = null;
        try {
            constructor = Class.forName("ch.ethz.iks.slp.impl.LocatorImpl").getConstructor(classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        locator = constructor;
        constructor = null;
        try {
            constructor = Class.forName("ch.ethz.iks.slp.impl.SLPDaemonImpl").getConstructor(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        daemonConstr = constructor;
        File file = new File("jslp.properties");
        try {
            sLPConfiguration = file.exists() ? new SLPConfiguration(file) : new SLPConfiguration();
        }
        catch (IOException iOException) {
            System.out.println("Could not parse the property file" + file.toString());
            iOException.printStackTrace();
            sLPConfiguration = new SLPConfiguration();
        }
        CONFIG = sLPConfiguration;
        noDiscovery = CONFIG.getNoDaDiscovery();
        String[] stringArray = CONFIG.getInterfaces();
        if (stringArray == null) {
            object = null;
            try {
                object = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                stringArray = new String[((InetAddress[])object).length];
                for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                    stringArray[i] = object[i].getHostAddress();
                }
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Reverse lookup of host name failed. Running service discovery on localloop.");
                try {
                    object = new InetAddress[]{InetAddress.getLocalHost()};
                }
                catch (UnknownHostException unknownHostException2) {
                    unknownHostException2.printStackTrace();
                }
            }
        }
        myIPs = stringArray;
        SLP_PORT = CONFIG.getPort();
        nextXid = (short)Math.round(Math.random() * 32767.0);
        object = null;
        try {
            object = InetAddress.getByName(SLP_MCAST_ADDRESS);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        MCAST_ADDRESS = object;
    }
}

