/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WidgetInterpreter
implements XMLElement.Interpreter<String> {
    private static final Map<String, String> LEGAL_CHILD_ELEMENTS;
    private static final String DEFAULT_CHILD_ELEMENT = "span";
    private final String fieldName;
    private final UiBinderWriter uiWriter;

    private static String getLegalPlaceholderTag(XMLElement elem) {
        XMLElement parent = elem.getParent();
        String tag = null;
        if (parent != null) {
            tag = LEGAL_CHILD_ELEMENTS.get(parent.getLocalName());
        }
        if (tag == null) {
            tag = DEFAULT_CHILD_ELEMENT;
        }
        return tag;
    }

    public WidgetInterpreter(String fieldName, UiBinderWriter writer) {
        this.fieldName = fieldName;
        this.uiWriter = writer;
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (this.uiWriter.isWidgetElement(elem)) {
            String idHolder = this.uiWriter.declareDomIdHolder();
            String childField = this.uiWriter.parseElementToField(elem);
            this.uiWriter.ensureCurrentFieldAttached();
            String elementPointer = idHolder + "Element";
            this.uiWriter.addInitStatement("com.google.gwt.user.client.Element %s = com.google.gwt.dom.client.Document.get().getElementById(%s).cast();", new Object[]{elementPointer, idHolder});
            this.uiWriter.addDetachStatement("%1$s.addAndReplaceElement(%2$s, %3$s);", new Object[]{this.fieldName, childField, elementPointer});
            String tag = WidgetInterpreter.getLegalPlaceholderTag(elem);
            return "<" + tag + " id='\" + " + idHolder + " + \"'></" + tag + ">";
        }
        return null;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", "tbody");
        map.put("thead", "tr");
        map.put("tbody", "tr");
        map.put("tfoot", "tr");
        map.put("ul", "li");
        map.put("ol", "li");
        map.put("dl", "dt");
        LEGAL_CHILD_ELEMENTS = Collections.unmodifiableMap(map);
    }
}

