/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.editor.impl.EdGraphObject;
import agg.gui.editor.GraphMorphismEditor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class GraphMorphismEditorMouseAdapter
extends MouseAdapter {
    private final GraphMorphismEditor editor;
    private EdGraphObject leftObj;
    private EdGraphObject rightObj;

    public GraphMorphismEditorMouseAdapter(GraphMorphismEditor anEditor) {
        this.editor = anEditor;
        this.editor.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.editor.getLeftGraph() == null || this.editor.getRightGraph() == null) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object source = e.getSource();
        if (this.editor.getLeftGraph() == null || this.editor.getRightGraph() == null || this.editor.setActivePanel(source) == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (SwingUtilities.isLeftMouseButton(e) && this.editor.getLeftPanel().getEditMode() == 115) {
            if (source == this.editor.getLeftPanel().getCanvas()) {
                this.leftObj = this.editor.getLeftPanel().getGraph().getPicked(x, y);
            } else if (source == this.editor.getRightPanel().getCanvas()) {
                this.rightObj = this.editor.getRightPanel().getGraph().getPicked(x, y);
                if (this.rightObj != null && this.leftObj != null) {
                    if (this.editor.addMapping(this.leftObj.getBasisObject(), this.rightObj.getBasisObject())) {
                        this.editor.updateGraphs();
                        this.editor.updateGraphics();
                    }
                } else if (this.leftObj != null) {
                    this.editor.removeMapping(this.leftObj.getBasisObject());
                    this.editor.updateGraphs();
                    this.editor.updateGraphics();
                }
            }
        }
    }
}

