/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.attribute.gui.impl.ContextEditor;
import agg.attribute.gui.impl.TopEditor;
import agg.attribute.gui.impl.TupleTableModel;
import agg.attribute.gui.impl.VariableTupleEditor;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.AGGAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RuleSignatureDialog
extends JDialog
implements TableModelListener {
    static final String ttt = "The signature includes the rule name and \nthe number, types and order of its parameters. \nThe last parameter may be an output parameter.";
    protected JFrame applFrame;
    protected EdGraGra gragra;
    protected EdRule rule;
    protected ContextEditor contextEditor;
    protected VariableTupleEditor variableEditor;
    protected VarMember var;
    protected int indxOut;
    protected boolean inFailed;
    protected boolean outFailed;
    protected String signatureTxt;
    protected String s0;
    protected String s1;
    protected String s2;
    protected String s3;
    protected String s4;
    protected String s5;
    private List<Integer> indexesIn;
    private List<Integer> store;
    private JTextField signTxt;
    private static boolean showInfoMsg;
    JPanel pVarEditor;

    public RuleSignatureDialog(JFrame frame, Point location, EdRule r) {
        this.applFrame = frame;
        this.rule = r;
        this.gragra = r.getGraGra();
        this.setModal(true);
        this.setTitle("  Signature of the Rule:  " + this.rule.getName());
        this.initData();
        ((AGGAppl)this.applFrame).getGraGraEditor().getAttrEditor().setContext(this.rule.getBasisRule().getAttrContext());
        this.contextEditor = ((TopEditor)((AGGAppl)this.applFrame).getGraGraEditor().getAttrEditor()).getContextEditor();
        this.variableEditor = this.contextEditor.getVariableEditor();
        this.variableEditor.getTableModel().addTableModelListener(this);
        JPanel content = this.initContentPane();
        JScrollPane scroll = new JScrollPane(content);
        scroll.setPreferredSize(new Dimension(500, 550));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroll, "Center");
        this.validate();
        this.setLocation(location);
        this.pack();
        this.storeIndexes();
    }

    private void initData() {
        this.indxOut = -1;
        this.indexesIn = new Vector<Integer>(5);
        if (this.rule.getBasisRule().getSignaturOrder() != null) {
            VarTuple vars = (VarTuple)this.rule.getBasisRule().getAttrContext().getVariables();
            this.indexesIn.addAll(vars.getSignaturOrder());
            this.fillSignatureItems(vars);
        }
        this.fillSignatureItems();
    }

    private void fillSignatureItems() {
        this.s0 = "";
        this.s1 = this.rule.getName();
        this.s2 = "(";
        this.s3 = "";
        this.s4 = "";
        this.s5 = ")";
    }

    private void fillSignatureItems(VarTuple vars) {
        String nt;
        VarMember m;
        this.fillSignatureItems();
        int i = 0;
        while (i < this.indexesIn.size()) {
            m = (VarMember)vars.getMemberAt(this.indexesIn.get(i));
            nt = m.getName().concat(":").concat(m.getDeclaration().getTypeName());
            this.s3 = this.s3.concat(nt);
            if (i < this.indexesIn.size() - 1) {
                this.s3 = this.s3.concat(", ");
            }
            ++i;
        }
        i = 0;
        while (i < vars.getSize()) {
            m = (VarMember)vars.getMemberAt(i);
            if (m.isOutputParameter()) {
                this.indxOut = i;
                if (!this.s3.isEmpty()) {
                    this.s4 = this.s4.concat(", ");
                }
                this.s4 = this.s4.concat("out ");
                nt = m.getName().concat(":").concat(m.getDeclaration().getTypeName());
                this.s4 = this.s4.concat(nt);
                break;
            }
            ++i;
        }
    }

    private JPanel initContentPane() {
        JPanel p = new JPanel(new BorderLayout());
        JPanel p1 = this.makeRuleContextPanel();
        JPanel p2 = new JPanel(new BorderLayout());
        JPanel pAssign = new JPanel(new GridLayout());
        JPanel p3 = this.makeAssignInParPanel();
        JPanel p4 = this.makeAssignOutParPanel();
        pAssign.add(p3);
        pAssign.add(p4);
        JPanel pSign = this.makeSignaturePanel();
        p2.add((Component)pAssign, "North");
        p2.add((Component)pSign, "Center");
        JPanel pClose = new JPanel(new GridLayout());
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSignatureDialog.this.check()) {
                    RuleSignatureDialog.this.variableEditor.getTableModel().setColumnEditable(4, true);
                    RuleSignatureDialog.this.setVisible(false);
                    System.out.println(RuleSignatureDialog.this.signatureTxt);
                    RuleSignatureDialog.this.contextEditor.resetVariableEditorComponent();
                } else if (RuleSignatureDialog.this.inFailed) {
                    RuleSignatureDialog.this.warning("Incorrect Signature", "The rule signature contains an incorrect input parameter.");
                } else if (RuleSignatureDialog.this.outFailed) {
                    RuleSignatureDialog.this.warning("Incorrect Signature", "The rule signature contains an incorrect output parameter.");
                }
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSignatureDialog.this.variableEditor.getTableModel().setColumnEditable(4, true);
                RuleSignatureDialog.this.restoreSignature();
                RuleSignatureDialog.this.setVisible(false);
            }
        });
        pClose.add(new JLabel("     "));
        pClose.add(close);
        pClose.add(new JLabel("     "));
        pClose.add(new JLabel("     "));
        pClose.add(cancel);
        pClose.add(new JLabel("     "));
        p.add((Component)p1, "North");
        p.add((Component)p2, "Center");
        p.add((Component)pClose, "South");
        return p;
    }

    private void setSignatureText() {
        this.signatureTxt = String.valueOf(this.s0) + this.s1 + this.s2 + this.s3 + this.s4 + this.s5;
        this.signTxt.setText("  " + this.signatureTxt);
    }

    protected void clearSignatureText() {
        this.s3 = "";
        this.s4 = "";
        this.signatureTxt = String.valueOf(this.s0) + this.s1 + this.s2 + this.s3 + this.s4 + this.s5;
        this.signTxt.setText("  " + this.signatureTxt);
    }

    protected void clearIndexes() {
        this.indexesIn.clear();
        this.indxOut = -1;
        this.inFailed = false;
        this.outFailed = false;
    }

    protected void unsetInOutParams() {
        VarTuple vars = (VarTuple)this.variableEditor.getTuple();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember m = (VarMember)vars.getMemberAt(i);
            m.setInputParameter(false);
            m.setOutputParameter(false);
            ++i;
        }
    }

    private void storeIndexes() {
        this.store = new Vector<Integer>(this.indexesIn);
        this.store.add(0, this.indxOut);
    }

    protected void clearSignature() {
        this.unsetInOutParams();
        this.clearSignatureText();
        this.clearIndexes();
        this.validate();
    }

    protected void restoreSignature() {
        this.indxOut = this.store.get(0);
        this.indexesIn.clear();
        int i = 1;
        while (i < this.store.size()) {
            this.indexesIn.add(this.store.get(i));
            ++i;
        }
        VarTuple vars = (VarTuple)this.variableEditor.getTuple();
        if (this.indxOut >= 0) {
            ((VarMember)vars.getMemberAt(this.indxOut)).setOutputParameter(true);
        }
        int i2 = 0;
        while (i2 < this.indexesIn.size()) {
            ((VarMember)vars.getMemberAt(this.indexesIn.get(i2))).setInputParameter(true);
            ++i2;
        }
        this.fillSignatureItems(vars);
        this.setSignatureText();
    }

    private JPanel makeLabelPanel() {
        JPanel p = new JPanel(new GridLayout(3, 0));
        p.add(new JLabel(" Please define one or more input parameters "));
        p.add(new JLabel(" and one output parameter."));
        p.add(new JLabel("     "));
        return p;
    }

    private JPanel makeRuleContextPanel() {
        this.variableEditor.getTableModel().setColumnEditable(4, false);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JLabel("     "), "North");
        this.pVarEditor = new JPanel(new BorderLayout());
        this.pVarEditor.setBorder(new TitledBorder("  Rule  context  "));
        this.pVarEditor.add((Component)this.makeLabelPanel(), "North");
        this.pVarEditor.add(this.variableEditor.getComponent(), "Center");
        p.add((Component)this.pVarEditor, "Center");
        p.add((Component)new JLabel("     "), "South");
        return p;
    }

    private JPanel makeAssignInParPanel() {
        JPanel p = new JPanel(new GridLayout(3, 0));
        p.setBorder(new TitledBorder("  Input  "));
        p.add(new JLabel("  Please select an input parameter  "));
        p.add(new JLabel("  and assign it to the rule signature  "));
        JPanel p1 = new JPanel(new GridLayout(0, 2));
        JButton assign = new JButton("Assign Input");
        assign.setSize(50, 20);
        assign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSignatureDialog.this.var = (VarMember)RuleSignatureDialog.this.variableEditor.getSelectedMember();
                if (RuleSignatureDialog.this.var != null && RuleSignatureDialog.this.var.isInputParameter()) {
                    int i = RuleSignatureDialog.this.variableEditor.getTuple().getIndexForMember(RuleSignatureDialog.this.var);
                    if (!RuleSignatureDialog.this.s3.isEmpty() && RuleSignatureDialog.this.s4.isEmpty()) {
                        RuleSignatureDialog.this.s3 = String.valueOf(RuleSignatureDialog.this.s3) + ", ";
                    }
                    String nt = String.valueOf(RuleSignatureDialog.this.variableEditor.getSelectedMember().getDeclaration().getName()) + ":" + RuleSignatureDialog.this.variableEditor.getSelectedMember().getDeclaration().getTypeName();
                    if (RuleSignatureDialog.this.indexesIn.contains(i)) {
                        RuleSignatureDialog.this.s3 = RuleSignatureDialog.this.s3.replaceFirst(nt, "");
                        RuleSignatureDialog.this.s3 = RuleSignatureDialog.this.s3.equals(", ") ? "" : (RuleSignatureDialog.this.s3.startsWith(", ") ? RuleSignatureDialog.this.s3.replaceFirst(", ", "") : RuleSignatureDialog.this.s3.replaceFirst(", , ", ", "));
                        RuleSignatureDialog.this.indexesIn.remove((Object)i);
                    }
                    RuleSignatureDialog.this.s3 = RuleSignatureDialog.this.s3.concat(nt);
                    if (!RuleSignatureDialog.this.s4.isEmpty()) {
                        RuleSignatureDialog.this.s3 = String.valueOf(RuleSignatureDialog.this.s3) + ", ";
                    }
                    RuleSignatureDialog.this.indexesIn.add(i);
                    RuleSignatureDialog.this.setSignatureText();
                }
            }
        });
        p1.add(assign);
        p1.add(new JLabel("      "));
        p.add(p1);
        return p;
    }

    private JPanel makeAssignOutParPanel() {
        JPanel p = new JPanel(new GridLayout(3, 0));
        p.setBorder(new TitledBorder("  Output  "));
        p.add(new JLabel("  Please select one output parameter  "));
        p.add(new JLabel("  and assign it to the rule signature  "));
        JPanel p1 = new JPanel(new GridLayout(0, 2));
        JButton assign = new JButton("Assign Output");
        assign.setSize(50, 20);
        assign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSignatureDialog.this.var = (VarMember)RuleSignatureDialog.this.variableEditor.getSelectedMember();
                if (RuleSignatureDialog.this.var != null && RuleSignatureDialog.this.var.isOutputParameter()) {
                    String nt;
                    RuleSignatureDialog.this.indxOut = RuleSignatureDialog.this.variableEditor.getTuple().getIndexForMember(RuleSignatureDialog.this.var);
                    if (!RuleSignatureDialog.this.s3.isEmpty() && RuleSignatureDialog.this.s4.isEmpty()) {
                        RuleSignatureDialog.this.s3 = String.valueOf(RuleSignatureDialog.this.s3) + ", ";
                    }
                    RuleSignatureDialog.this.s4 = nt = "out " + RuleSignatureDialog.this.variableEditor.getSelectedMember().getDeclaration().getName() + ":" + RuleSignatureDialog.this.variableEditor.getSelectedMember().getDeclaration().getTypeName();
                    RuleSignatureDialog.this.setSignatureText();
                }
            }
        });
        p1.add(assign);
        p1.add(new JLabel("      "));
        p.add(p1);
        return p;
    }

    private JPanel makeSignaturePanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JLabel("     "), "North");
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setBorder(new TitledBorder("  Rule signature  "));
        this.signTxt = new JTextField();
        this.signTxt.setEditable(false);
        this.signTxt.setFont(new Font("SansSerif", 2, 14));
        this.setSignatureText();
        p1.add((Component)this.signTxt, "Center");
        JPanel pClear = new JPanel(new GridLayout(0, 5));
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSignatureDialog.this.clearSignature();
            }
        });
        pClear.add(new JLabel("     "));
        pClear.add(new JLabel("     "));
        pClear.add(clear);
        pClear.add(new JLabel("     "));
        pClear.add(new JLabel("     "));
        p1.add((Component)pClear, "South");
        p.add((Component)p1, "Center");
        p.add((Component)new JLabel("     "), "South");
        return p;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int c = ((TupleTableModel)e.getSource()).getChangedColumn();
        String cname = ((TupleTableModel)e.getSource()).getColumnName(c);
        if (cname.equals("In") || cname.equals("Out") || cname.equals("Type") || cname.equals("Name")) {
            int key = ((TupleTableModel)e.getSource()).getItemKeyAt(c);
            switch (key) {
                case 6: {
                    int i;
                    if (this.var != null && !this.var.isInputParameter() && this.indexesIn.contains(i = this.variableEditor.getTuple().getIndexForMember(this.var))) {
                        this.clearSignatureText();
                    }
                }
                case 7: {
                    if (this.var != null && !this.var.isOutputParameter() && !this.checkOut()) {
                        this.warning("Incorrect Signature", "The rule signature contains incorrect output parameter.\n\nThe signature will be unset.");
                        this.clearSignatureText();
                    }
                }
                case 2: 
                case 3: {
                    if (this.var == null) break;
                    int i = this.variableEditor.getTuple().getIndexForMember(this.var);
                    if (this.indexesIn.contains(i)) {
                        this.warning("Incorrect Signature", "Changing of the type or name of an input|output parameter \nleads to an incorrect signature.\n\nThe current rule signature will be unset.");
                        this.clearSignatureText();
                    }
                    if (this.checkOut()) break;
                    this.warning("Incorrect Signature", "Changing of the type or name of an input|output parameter \nleads to an incorrect signature.\n\nThe current rule signature will be unset.");
                    this.clearSignatureText();
                }
            }
        }
    }

    protected boolean check() {
        this.inFailed = !this.checkIn();
        boolean bl = this.outFailed = !this.checkOut();
        if (!this.inFailed && !this.outFailed) {
            this.rule.getBasisRule().disposeSignatur();
            if (!this.indexesIn.isEmpty() || this.indxOut >= 0) {
                this.rule.getBasisRule().initSignatur();
                int i = 0;
                while (i < this.indexesIn.size()) {
                    this.rule.getBasisRule().addInToSignatur(this.indexesIn.get(i));
                    ++i;
                }
                this.rule.getBasisRule().addOutToSignatur(this.indxOut);
                System.out.println(this.rule.getBasisRule().getSignatur());
            }
            return true;
        }
        return false;
    }

    protected boolean checkIn() {
        this.inFailed = false;
        int l = 0;
        while (l < this.indexesIn.size()) {
            int i = this.indexesIn.get(l);
            VarMember m = ((VarTuple)this.variableEditor.getTuple()).getVarMemberAt(i);
            if (m == null || !m.isInputParameter()) {
                this.inFailed = true;
                return false;
            }
            ++l;
        }
        return true;
    }

    protected boolean checkOut() {
        this.outFailed = false;
        if (!this.s4.isEmpty()) {
            String[] nt = this.s4.split(":");
            String n = nt[0].replaceFirst("out ", "");
            VarMember m = ((VarTuple)this.variableEditor.getTuple()).getVarMemberAt(n);
            if (m == null || !m.isOutputParameter() || !m.getDeclaration().getTypeName().equals(nt[1])) {
                this.outFailed = true;
                return false;
            }
        }
        return true;
    }

    protected void warning(String title, String msg) {
        JOptionPane.showMessageDialog(null, msg, title, 0);
    }

    public static final String getToolTipText() {
        return ttt;
    }

    public static final void infoMsg() {
        Object[] options;
        String msg;
        int answer;
        if (showInfoMsg && (answer = JOptionPane.showOptionDialog(null, msg = "The rule signature includes the rule name and \nthe number, types and order of its parameters. \nThe last parameter may be an output parameter.\n", "Rule Signature", -1, 1, null, options = new Object[]{"Ok", "Don't show this info anymore"}, options[0])) == 1) {
            showInfoMsg = false;
        }
    }
}

