/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.typeeditor;

import agg.editor.impl.EdType;
import agg.editor.impl.EditUndoManager;
import agg.editor.impl.TypeReprData;
import agg.gui.animation.AnimationParam;
import agg.gui.animation.AnimationParamDialog;
import agg.gui.event.TypeEvent;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import agg.gui.saveload.AGGFileFilter;
import agg.gui.typeeditor.ColorChooserDialog;
import agg.gui.typeeditor.TypeEditor;
import agg.gui.typeeditor.TypePalette;
import agg.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class NodeTypePropertyEditor
extends JPanel
implements ChangeListener,
StateEditable {
    private EditUndoManager undoManager;
    private StateEdit newEdit;
    private Pair<String, Vector<?>> undoObj;
    protected int undoID;
    private final JFrame applFrame;
    private final TypePalette palette;
    protected final TypeEditor typeEditor;
    private String typeName = "";
    private String typeComment = "";
    private Color typeColor = Color.black;
    protected int typeShape = 51;
    protected boolean filledShape;
    protected boolean animatedShape;
    protected final AnimationParam animationParam;
    protected AnimationParamDialog animationDialog;
    private final JFileChooser fileChooser;
    private String resourcesPath = System.getProperty("user.dir");
    private String imageFileName = "";
    protected Point location;
    protected final ColorChooserDialog colorChooser;
    private final ButtonGroup colorGroup;
    private final ButtonGroup shapeGroup;
    protected final JTextField nameEditor;
    private final JEditorPane commentEditor;
    protected final JButton addButton;
    protected final JButton modifyButton;
    protected final JButton deleteButton;
    protected final JButton closeButton;
    protected final JButton cancelButton;
    protected final JCheckBox moreColor;
    protected final JCheckBox imageCB;
    protected final JCheckBox filledCB;
    protected final JCheckBox animatedCB;
    protected final JDialog dialog;
    protected boolean changed = false;

    public NodeTypePropertyEditor(JFrame aggappl, TypeEditor typeEditor, TypePalette palette) {
        super(new BorderLayout());
        this.setBorder(new TitledBorder(" Node Type Properties "));
        this.applFrame = aggappl;
        this.typeEditor = typeEditor;
        this.palette = palette;
        this.colorChooser = new ColorChooserDialog();
        this.colorChooser.addChangeListener(this);
        this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
        AGGFileFilter filter = new AGGFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("gif");
        filter.setDescription("JPG & GIF Images");
        this.fileChooser.setFileFilter(filter);
        this.dialog = new JDialog((Frame)this.applFrame, " Node Type Editor ");
        this.nameEditor = new JTextField(this.typeName);
        this.colorGroup = new ButtonGroup();
        this.moreColor = new JCheckBox("Other", null);
        this.shapeGroup = new ButtonGroup();
        this.filledCB = new JCheckBox("filled", null);
        this.animatedCB = new JCheckBox("animated", null);
        this.animationParam = new AnimationParam(0, 0, 10, 0);
        this.imageCB = new JCheckBox("Load", null);
        this.commentEditor = new JEditorPane();
        this.addButton = new JButton();
        this.modifyButton = new JButton();
        this.deleteButton = new JButton();
        this.closeButton = new JButton();
        this.cancelButton = new JButton();
        this.initComponents();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
    }

    public boolean undoManagerAddEdit(String presentationName) {
        if (this.undoManager == null || !this.undoManager.isEnabled()) {
            return false;
        }
        EdType type = this.typeEditor.getSelectedNodeType();
        type.setContextUsage(String.valueOf(type.hashCode()));
        TypeReprData data = new TypeReprData(type);
        Vector<TypeReprData> vec = new Vector<TypeReprData>(1);
        vec.add(data);
        this.undoObj = new Pair(presentationName, vec);
        this.newEdit = new StateEdit(this, presentationName);
        return this.undoManager.addEdit(this.newEdit);
    }

    public void undoManagerEndEdit(EdType type) {
        if (this.undoObj == null || this.undoManager == null || !this.undoManager.isEnabled() || this.newEdit == null || type == null) {
            return;
        }
        String first = (String)this.undoObj.first;
        String kind = "";
        Vector<TypeReprData> gos = new Vector<TypeReprData>(1);
        gos.add(new TypeReprData(type));
        if (first.equals("CREATE_DELETE")) {
            kind = "DELETE_CREATE";
        } else if (first.equals("DELETE_CREATE")) {
            kind = "CREATE_DELETE";
        } else if (first.equals("COMMON_DELETE_CREATE")) {
            kind = "CREATE_DELETE";
        } else if (first.equals("CHANGE")) {
            kind = "CHANGE";
        }
        this.undoObj = new Pair(kind, gos);
        this.undoManager.end(this.newEdit);
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        if (this.undoObj.first != null && this.undoObj.second != null) {
            state.put(String.valueOf(this.hashCode()), this.undoObj);
            if (((String)this.undoObj.first).equals("COMMON_DELETE_CREATE")) {
                this.typeEditor.storeState(state);
            }
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        if (state == null) {
            return;
        }
        EdType type = null;
        Pair obj = (Pair)state.get(String.valueOf(this.hashCode()));
        if (obj == null) {
            return;
        }
        if (obj.first == null || obj.second == null) {
            return;
        }
        String op = (String)obj.first;
        Vector vec = (Vector)obj.second;
        TypeReprData data = (TypeReprData)vec.firstElement();
        if (op.equals("CHANGE")) {
            int hc = data.getTypeHashCode();
            int index = -1;
            int i = 0;
            while (i < this.typeEditor.getNodeTypes().size()) {
                type = this.typeEditor.getNodeTypes().get(i);
                if (type.hashCode() == hc) {
                    index = i;
                    break;
                }
                if (type.getContextUsage().indexOf(":" + String.valueOf(hc) + ":") != -1) {
                    index = i;
                    break;
                }
                type = null;
                ++i;
            }
            if (type != null) {
                data.restoreTypeFromTypeRepr(type);
                this.refreshTypeProperty(type, index);
            }
        } else if (op.equals("CREATE_DELETE")) {
            int hc = data.getTypeHashCode();
            int i = 0;
            while (i < this.typeEditor.getNodeTypes().size()) {
                type = this.typeEditor.getNodeTypes().get(i);
                if (type.hashCode() == hc || type.getContextUsage().indexOf(":" + String.valueOf(hc) + ":") != -1) break;
                type = null;
                ++i;
            }
            if (type != null && type.isNodeType() && !this.typeEditor.deleteNodeType(type, false)) {
                this.undoManagerAddEdit("CREATE_DELETE");
            }
        } else if (op.equals("DELETE_CREATE")) {
            type = data.createTypeFromTypeRepr(this.typeEditor.getGraGra().getBasisGraGra().createNodeType(false));
            this.typeEditor.addNodeType(type);
            this.palette.enableNodeTypeDeleteButton(true);
            this.palette.enableNodeTypeModifyButton(true);
        } else if (op.equals("COMMON_DELETE_CREATE")) {
            type = data.createTypeFromTypeRepr(this.typeEditor.getGraGra().getBasisGraGra().createNodeType(false));
            this.typeEditor.addNodeType(type);
            this.palette.enableNodeTypeDeleteButton(true);
            this.palette.enableNodeTypeModifyButton(true);
            if (state.get(this.typeEditor) != null) {
                this.typeEditor.restoreState(state);
            }
        }
    }

    public TypeEditor getTypeEditor() {
        return this.typeEditor;
    }

    protected JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    private void showPropertyDialog() {
        this.animatedCB.setEnabled(this.typeEditor.getTypeSet().getTypeGraph() != null && !this.typeEditor.getTypeSet().getTypeGraph().getArcs().isEmpty());
        if (!this.dialog.isVisible()) {
            if (this.location.y + this.dialog.getHeight() + 10 > Toolkit.getDefaultToolkit().getScreenSize().height) {
                this.location.y = Toolkit.getDefaultToolkit().getScreenSize().height - (this.dialog.getHeight() + 10);
            }
            this.dialog.setLocation(this.location.x, this.location.y);
            this.dialog.setVisible(true);
        }
        this.changed = false;
    }

    private void initComponents() {
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel namePanel = this.initName();
        p1.add((Component)namePanel, "Center");
        JPanel p2 = new JPanel(new GridLayout(1, 0, 5, 5));
        JPanel colorPanel = this.initColors();
        JPanel shapePanel = this.initShapes();
        p2.add(colorPanel);
        p2.add(shapePanel);
        JPanel imagePanel = this.initImageAndAnimation();
        JPanel commentPanel = this.initComment();
        JPanel closePanel = this.initButtons();
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)imagePanel, "North");
        p3.add((Component)commentPanel, "Center");
        p3.add((Component)closePanel, "South");
        this.add((Component)p1, "North");
        this.add((Component)p2, "Center");
        this.add((Component)p3, "South");
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NodeTypePropertyEditor.this.dialog.setVisible(false);
            }
        });
        this.dialog.setContentPane(this);
        this.dialog.validate();
        this.dialog.pack();
        this.dialog.setAlwaysOnTop(true);
    }

    private JPanel initName() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(" Name "));
        this.nameEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NodeTypePropertyEditor.this.addType(true)) {
                    NodeTypePropertyEditor.this.modifyButton.setEnabled(true);
                    NodeTypePropertyEditor.this.deleteButton.setEnabled(true);
                }
            }
        });
        this.nameEditor.setForeground(this.typeColor);
        JScrollPane scrolltf = new JScrollPane(this.nameEditor);
        scrolltf.setPreferredSize(new Dimension(50, 40));
        panel.add((Component)scrolltf, "Center");
        return panel;
    }

    private JPanel initColors() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(new TitledBorder(" Color "));
        JCheckBox black = new JCheckBox("Black", null, true);
        this.colorGroup.add(black);
        black.setForeground(Color.black);
        if (this.typeColor == Color.black) {
            black.setSelected(true);
        } else {
            black.setSelected(false);
        }
        black.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    NodeTypePropertyEditor.this.nameEditor.setForeground(Color.black);
                }
            }
        });
        panel.add(black);
        JCheckBox red = new JCheckBox("Red", null);
        this.colorGroup.add(red);
        red.setForeground(Color.red);
        if (this.typeColor == Color.red) {
            red.setSelected(true);
        } else {
            red.setSelected(false);
        }
        red.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    NodeTypePropertyEditor.this.nameEditor.setForeground(Color.red);
                }
            }
        });
        panel.add(red);
        JCheckBox orange = new JCheckBox("Orange", null);
        this.colorGroup.add(orange);
        orange.setForeground(Color.orange);
        if (this.typeColor == Color.orange) {
            orange.setSelected(true);
        } else {
            orange.setSelected(false);
        }
        orange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    NodeTypePropertyEditor.this.nameEditor.setForeground(Color.orange);
                }
            }
        });
        panel.add(orange);
        JCheckBox blue = new JCheckBox("Blue", null);
        this.colorGroup.add(blue);
        blue.setForeground(Color.blue);
        if (this.typeColor == Color.blue) {
            blue.setSelected(true);
        } else {
            blue.setSelected(false);
        }
        blue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    NodeTypePropertyEditor.this.nameEditor.setForeground(Color.blue);
                }
            }
        });
        panel.add(blue);
        JCheckBox pink = new JCheckBox("Pink", null);
        this.colorGroup.add(pink);
        pink.setForeground(Color.pink);
        if (this.typeColor == Color.pink) {
            pink.setSelected(true);
        } else {
            pink.setSelected(false);
        }
        pink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    NodeTypePropertyEditor.this.nameEditor.setForeground(Color.pink);
                }
            }
        });
        panel.add(pink);
        this.colorGroup.add(this.moreColor);
        if (!this.colorGroup.isSelected(this.colorGroup.getSelection())) {
            this.moreColor.setSelected(true);
        } else {
            this.moreColor.setSelected(false);
        }
        this.moreColor.setForeground(Color.black);
        this.moreColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeTypePropertyEditor.this.colorChooser.showColorDialog(NodeTypePropertyEditor.this.dialog, NodeTypePropertyEditor.this.location);
            }
        });
        panel.add(this.moreColor);
        return panel;
    }

    private JPanel initShapes() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(new TitledBorder(" Shape "));
        JCheckBox rect = new JCheckBox("Rectangle", null, true);
        this.shapeGroup.add(rect);
        if (this.typeShape == 51) {
            rect.setSelected(true);
        } else {
            rect.setSelected(false);
        }
        panel.add(rect);
        JCheckBox roundrect = new JCheckBox("Roundrect", null);
        this.shapeGroup.add(roundrect);
        if (this.typeShape == 54) {
            roundrect.setSelected(true);
        } else {
            roundrect.setSelected(false);
        }
        panel.add(roundrect);
        JCheckBox oval = new JCheckBox("Oval", null);
        this.shapeGroup.add(oval);
        if (this.typeShape == 53) {
            oval.setSelected(true);
        } else {
            oval.setSelected(false);
        }
        panel.add(oval);
        JCheckBox circle = new JCheckBox("Circle", null);
        this.shapeGroup.add(circle);
        if (this.typeShape == 52) {
            circle.setSelected(true);
        } else {
            circle.setSelected(false);
        }
        panel.add(circle);
        panel.add(new JLabel("      "));
        panel.add(this.filledCB);
        return panel;
    }

    private JPanel initImageAndAnimation() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(" Image "));
        if (this.imageFileName.equals("")) {
            this.imageCB.setText("Load");
            this.imageCB.setSelected(false);
        } else {
            this.imageCB.setText(this.imageFileName);
            this.imageCB.setSelected(true);
        }
        this.imageCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NodeTypePropertyEditor.this.imageCB.isSelected()) {
                    String fname = NodeTypePropertyEditor.this.loadImage();
                    if (!fname.equals("")) {
                        NodeTypePropertyEditor.this.imageCB.setText(fname);
                    } else {
                        NodeTypePropertyEditor.this.imageCB.setText("Load");
                        NodeTypePropertyEditor.this.imageCB.setSelected(false);
                    }
                } else {
                    NodeTypePropertyEditor.this.imageCB.setText("Load");
                    NodeTypePropertyEditor.this.imageCB.setSelected(false);
                }
            }
        });
        panel.add((Component)this.imageCB, "West");
        this.animatedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NodeTypePropertyEditor.this.typeEditor.getTypeSet().getBasisTypeSet().getTypeGraph() != null) {
                    if (NodeTypePropertyEditor.this.animatedCB.isSelected()) {
                        NodeTypePropertyEditor.this.animationDialog = new AnimationParamDialog(NodeTypePropertyEditor.this.animationParam, NodeTypePropertyEditor.this.typeEditor.getSelectedNodeType().getBasisType(), NodeTypePropertyEditor.this.typeEditor.getTypeSet().getBasisTypeSet().getTypeGraph());
                        NodeTypePropertyEditor.this.animationDialog.showParameterDialog(300, 300);
                    }
                } else {
                    NodeTypePropertyEditor.this.animatedCB.setSelected(false);
                    JOptionPane.showMessageDialog(null, "This option is only evailable for grammars with a TypeGraph", "TypeGraph missed", 2);
                }
            }
        });
        panel.add((Component)this.animatedCB, "East");
        return panel;
    }

    private JPanel initComment() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(" Comment "));
        this.commentEditor.setText(this.typeComment);
        JScrollPane scrollpane = new JScrollPane(this.commentEditor);
        scrollpane.setPreferredSize(new Dimension(200, 100));
        panel.add(scrollpane);
        return panel;
    }

    private JPanel initButtons() {
        JPanel p = new JPanel(new GridLayout(2, 0, 10, 10));
        JPanel p1 = new JPanel(new GridLayout(0, 3, 10, 10));
        JPanel p2 = new JPanel(new GridLayout(0, 2, 10, 10));
        this.addButton.setActionCommand("add");
        this.addButton.setText("Add");
        this.addButton.setToolTipText("Add new type.");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeTypePropertyEditor.this.addType(false);
                NodeTypePropertyEditor.this.modifyButton.setEnabled(true);
                NodeTypePropertyEditor.this.deleteButton.setEnabled(true);
            }
        });
        this.modifyButton.setActionCommand("change");
        this.modifyButton.setText("Modify");
        this.modifyButton.setToolTipText("Modify type properties.");
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeTypePropertyEditor.this.changeType();
            }
        });
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Delete type.");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeTypePropertyEditor.this.deleteType();
            }
        });
        p1.add(this.addButton);
        p1.add(this.modifyButton);
        p1.add(this.deleteButton);
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept type properties and close dialog.");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeTypePropertyEditor.this.close();
            }
        });
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel changes and close dialog.");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeTypePropertyEditor.this.cancel();
            }
        });
        p2.add(this.closeButton);
        p2.add(this.cancelButton);
        p.add(p1);
        p.add(p2);
        return p;
    }

    public void enableChangeButton(boolean b) {
        this.modifyButton.setEnabled(b);
    }

    public void enableDeleteButton(boolean b) {
        this.deleteButton.setEnabled(b);
    }

    private void accept() {
        String imagefname;
        JCheckBox cb;
        this.changed = false;
        if (!this.typeName.equals(this.nameEditor.getText())) {
            this.changed = true;
            this.typeName = this.nameEditor.getText().replaceAll(" ", "");
        }
        Enumeration<AbstractButton> en = this.colorGroup.getElements();
        while (en.hasMoreElements()) {
            Color c;
            cb = (JCheckBox)en.nextElement();
            if (cb.isSelected()) {
                c = this.getTypeColor(cb.getText());
                if (this.typeColor.equals(c)) continue;
                this.changed = true;
                this.typeColor = c;
                this.nameEditor.setForeground(this.typeColor);
                break;
            }
            if (!this.moreColor.isSelected() || this.typeColor.equals(c = this.moreColor.getForeground())) continue;
            this.changed = true;
            this.typeColor = c;
            this.nameEditor.setForeground(this.typeColor);
            break;
        }
        en = this.shapeGroup.getElements();
        while (en.hasMoreElements()) {
            int sh;
            cb = (JCheckBox)en.nextElement();
            if (!cb.isSelected() || this.typeShape == (sh = this.getTypeShape(cb.getText()))) continue;
            this.changed = true;
            this.typeShape = sh;
            break;
        }
        if (this.filledShape != this.filledCB.isSelected()) {
            this.changed = true;
            this.filledShape = this.filledCB.isSelected();
        }
        if (this.animatedShape != this.animatedCB.isSelected()) {
            this.changed = true;
            this.animatedShape = this.animatedCB.isSelected();
        }
        if (this.animatedCB.isSelected() && this.animationDialog != null) {
            this.animationDialog.getAnimationParameter();
            if (this.animationDialog.isVisible()) {
                this.animationDialog.setVisible(false);
            }
        }
        if (!(imagefname = this.imageCB.getText()).equals(this.imageFileName)) {
            if (imagefname.equals("Load")) {
                if (this.imageFileName.length() != 0) {
                    this.imageFileName = "";
                    this.changed = true;
                }
            } else {
                this.imageFileName = imagefname;
                this.changed = true;
            }
        }
        if (!this.typeComment.equals(this.commentEditor.getText())) {
            this.typeComment = this.commentEditor.getText();
            this.changed = true;
        }
    }

    protected boolean addType(boolean suppressWarning) {
        boolean result = false;
        this.accept();
        EdType t = this.typeEditor.addNodeType(this.typeName, this.typeColor, this.typeShape, this.filledShape, this.resourcesPath, this.imageFileName, this.typeComment, this.animatedShape);
        if (t == null) {
            if (!suppressWarning) {
                JOptionPane.showMessageDialog(this.dialog, "Type already exists.");
            }
        } else {
            if (t.isAnimated()) {
                this.resetAnimationParameterOfType(t);
                if (this.animationDialog != null && this.animationDialog.hasChanged()) {
                    this.typeEditor.fireTypeEvent(new TypeEvent(this, 17));
                    this.animationDialog.unsetChanged();
                }
            }
            result = true;
        }
        this.changed = false;
        return result;
    }

    protected void changeType() {
        this.accept();
        if (this.changed && !this.typeEditor.changeSelectedNodeType(this.typeName, this.typeColor, this.typeShape, this.filledShape, this.resourcesPath, this.imageFileName, this.typeComment, this.animatedShape)) {
            JOptionPane.showMessageDialog(this.dialog, "Type already exists.");
            this.changed = false;
            return;
        }
        EdType t = this.typeEditor.getSelectedNodeType();
        if (t.isAnimated()) {
            this.resetAnimationParameterOfType(t);
            if (this.animationDialog != null && this.animationDialog.hasChanged()) {
                this.typeEditor.fireTypeEvent(new TypeEvent(this, 17));
                this.animationDialog.unsetChanged();
            }
        }
        this.changed = false;
    }

    private void setAnimationParameter(AnimationParam p) {
        if (p != null) {
            this.animationParam.kind = p.kind;
            this.animationParam.step = p.step;
            this.animationParam.delay = p.delay;
            this.animationParam.plus = p.plus;
            this.animationParam.targetEdgeTypeName = p.targetEdgeTypeName;
        }
    }

    private void resetAnimationParameterOfType(EdType t) {
        t.animationParameter.kind = this.animationParam.kind;
        t.animationParameter.step = this.animationParam.step;
        t.animationParameter.delay = this.animationParam.delay;
        t.animationParameter.plus = this.animationParam.plus;
        t.animationParameter.targetEdgeTypeName = this.animationParam.targetEdgeTypeName;
    }

    protected void deleteType() {
        this.typeEditor.deleteSelectedNodeType(true);
    }

    protected void close() {
        this.accept();
        if (this.changed) {
            JOptionPane.showMessageDialog(this.dialog, "You have changed the type.\nPlease save it or cancel the entries.");
            return;
        }
        this.hideDialog();
    }

    protected void cancel() {
        this.hideDialog();
    }

    protected void hideDialog() {
        if (!this.palette.isNodeTypesEmpty()) {
            this.palette.enableNodeTypeModifyButton(true);
            this.palette.enableNodeTypeDeleteButton(true);
        } else {
            this.palette.enableNodeTypeModifyButton(false);
            this.palette.enableNodeTypeDeleteButton(false);
        }
        this.dialog.setVisible(false);
    }

    protected String loadImage() {
        String imageFile = "";
        int returnVal = this.fileChooser.showOpenDialog(this.dialog);
        if (returnVal == 0) {
            if (this.fileChooser.getSelectedFile() != null && !this.fileChooser.getSelectedFile().getName().equals("")) {
                this.resourcesPath = this.fileChooser.getCurrentDirectory().toString();
                imageFile = this.fileChooser.getSelectedFile().getName();
            } else {
                this.resourcesPath = System.getProperty("user.dir");
                imageFile = "";
            }
        }
        return imageFile;
    }

    public void setSelectedTypeProperty(EdType t) {
        this.typeName = t.getName();
        this.typeColor = t.getColor();
        this.typeShape = t.getShape();
        this.filledShape = t.hasFilledShape();
        this.animatedShape = t.isAnimated();
        this.setAnimationParameter(t.animationParameter);
        this.resourcesPath = t.getResourcesPath();
        this.imageFileName = t.getImageFileName();
        this.typeComment = t.getBasisType().getTextualComment();
        this.setTypeProperty();
        this.changed = false;
    }

    public void setSelectedTypeProperty(String tname, Color tcolor, int tshape, boolean tfilledshape, String tresourcespath, String timage, String tcomment, boolean tanimated) {
        this.typeName = tname;
        this.typeColor = tcolor;
        this.typeShape = tshape;
        this.filledShape = tfilledshape;
        this.animatedShape = tanimated;
        this.resourcesPath = tresourcespath;
        this.imageFileName = timage;
        this.typeComment = tcomment;
        this.setTypeProperty();
        this.changed = false;
    }

    public void setNewTypeDefaultProperty() {
        this.typeName = "";
        this.typeColor = Color.black;
        this.typeShape = 51;
        this.filledShape = false;
        this.resourcesPath = "";
        this.imageFileName = "";
        this.typeComment = "";
        this.setTypeProperty();
        this.changed = false;
    }

    private void refreshTypeProperty(EdType t, int index) {
        this.typeName = t.getName();
        this.typeColor = t.getColor();
        this.typeShape = t.getShape();
        this.filledShape = t.hasFilledShape();
        this.animatedShape = t.isAnimated();
        this.setAnimationParameter(t.animationParameter);
        this.resourcesPath = t.getResourcesPath();
        this.imageFileName = t.getImageFileName();
        this.typeComment = t.getBasisType().getTextualComment();
        this.setTypeProperty();
        this.accept();
        JLabel l = this.typeEditor.makeNodeTypeLabel(t);
        this.palette.refreshNodeType(l, index);
        this.typeEditor.fireTypeEvent(new TypeEvent(this, t, index, 12));
        this.changed = false;
    }

    private void setTypeProperty() {
        this.nameEditor.setText(this.typeName);
        this.nameEditor.setForeground(this.typeColor);
        String colorStr = this.getTypeColorStr(this.typeColor);
        Enumeration<AbstractButton> en = this.colorGroup.getElements();
        while (en.hasMoreElements()) {
            JCheckBox cb = (JCheckBox)en.nextElement();
            if (!cb.getText().equals(colorStr)) continue;
            if (cb.getText().equals("Other")) {
                this.moreColor.setForeground(this.typeColor);
            }
            cb.setSelected(true);
            break;
        }
        String shapeStr = this.getTypeShapeStr(this.typeShape);
        en = this.shapeGroup.getElements();
        while (en.hasMoreElements()) {
            JCheckBox cb = (JCheckBox)en.nextElement();
            if (!cb.getText().equals(shapeStr)) continue;
            cb.setSelected(true);
        }
        this.filledCB.setSelected(this.filledShape);
        this.animatedCB.setSelected(this.animatedShape);
        if (this.animationDialog != null) {
            this.animationDialog.setVisible(false);
        }
        if (this.imageFileName.indexOf(".gif") != -1 || this.imageFileName.indexOf(".jpg") != -1) {
            this.imageCB.setText(this.imageFileName);
            this.imageCB.setSelected(true);
        } else {
            this.imageFileName = "";
            this.imageCB.setText("Load");
            this.imageCB.setSelected(false);
        }
        this.commentEditor.setText(this.typeComment);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Color newColor = this.colorChooser.getColor();
        this.moreColor.setForeground(newColor);
        this.nameEditor.setForeground(newColor);
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    public Color getSelectedColor() {
        return this.typeColor;
    }

    public int getSelectedShape() {
        return this.typeShape;
    }

    private String getTypeShapeStr(int sh) {
        String s = "";
        switch (sh) {
            case 51: {
                s = "Rectangle";
                break;
            }
            case 54: {
                s = "Roundrect";
                break;
            }
            case 53: {
                s = "Oval";
                break;
            }
            case 52: {
                s = "Circle";
                break;
            }
        }
        return s;
    }

    public void invoke() {
        this.invoke(100, 100);
    }

    public void invoke(int x, int y) {
        this.location = new Point(x, y);
        this.showPropertyDialog();
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setResourcesPath(String path) {
        this.resourcesPath = path;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    private Color getTypeColor(String col) {
        if (col.equals("Black")) {
            return Color.black;
        }
        if (col.equals("Red")) {
            return Color.red;
        }
        if (col.equals("Blue")) {
            return Color.blue;
        }
        if (col.equals("White")) {
            return Color.white;
        }
        if (col.equals("Yellow")) {
            return Color.yellow;
        }
        if (col.equals("Orange")) {
            return Color.orange;
        }
        if (col.equals("Pink")) {
            return Color.pink;
        }
        if (col.equals("Other")) {
            return this.moreColor.getForeground();
        }
        return Color.black;
    }

    private String getTypeColorStr(Color col) {
        if (col.equals(Color.black)) {
            return "Black";
        }
        if (col.equals(Color.red)) {
            return "Red";
        }
        if (col.equals(Color.blue)) {
            return "Blue";
        }
        if (col.equals(Color.white)) {
            return "White";
        }
        if (col.equals(Color.yellow)) {
            return "Yellow";
        }
        if (col.equals(Color.orange)) {
            return "Orange";
        }
        if (col.equals(Color.pink)) {
            return "Pink";
        }
        return "Other";
    }

    private int getTypeShape(String shape) {
        if (shape.equals("Rectangle")) {
            return 51;
        }
        if (shape.equals("Circle")) {
            return 52;
        }
        if (shape.equals("Oval")) {
            return 53;
        }
        return 54;
    }

    public static Icon getNodeTypeIcon(int shape, Color color, boolean filled) {
        Icon icon = null;
        switch (shape) {
            case 51: {
                icon = new RectShapeIcon(color, filled);
                break;
            }
            case 54: {
                icon = new RoundRectShapeIcon(color, filled);
                break;
            }
            case 52: {
                icon = new CircleShapeIcon(color, filled);
                break;
            }
            case 53: {
                icon = new OvalShapeIcon(color, filled);
                break;
            }
        }
        return icon;
    }
}

