/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.concurrent.atomic.AtomicLong;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.SystemProperties;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HThriftClient {
    private static Logger log = LoggerFactory.getLogger(HThriftClient.class);
    private static final AtomicLong serial = new AtomicLong(0L);
    final CassandraHost cassandraHost;
    private final long mySerial;
    private final int timeout;
    private TTransport transport;
    private static final String NAME_FORMAT = "CassandraClient<%s-%d>";

    HThriftClient(CassandraHost cassandraHost) {
        this.cassandraHost = cassandraHost;
        this.timeout = this.getTimeout(cassandraHost);
        this.mySerial = serial.incrementAndGet();
    }

    public Cassandra.Client getCassandra() {
        if (!this.isOpen()) {
            throw new IllegalStateException("getCassandra called on client that was not open. You should not have gotten here.");
        }
        return new Cassandra.Client((TProtocol)new TBinaryProtocol(this.transport));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HThriftClient close() {
        if (log.isDebugEnabled()) {
            log.debug("Closing client {}", (Object)this);
        }
        if (this.isOpen()) {
            try {
                this.transport.flush();
            }
            catch (Exception e) {
                log.error("Could not flush transport (to be expected if the pool is shutting down) in close for client: " + this.toString(), (Throwable)e);
            }
            finally {
                try {
                    this.transport.close();
                }
                catch (Exception e) {
                    log.error("Error on transport close for client: " + this.toString(), (Throwable)e);
                }
            }
        }
        return this;
    }

    HThriftClient open() {
        if (this.isOpen()) {
            throw new IllegalStateException("Open called on already open connection. You should not have gotten here.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating a new thrift connection to {}", (Object)this.cassandraHost);
        }
        this.transport = this.cassandraHost.getUseThriftFramedTransport() ? new TFramedTransport((TTransport)new TSocket(this.cassandraHost.getHost(), this.cassandraHost.getPort(), this.timeout)) : new TSocket(this.cassandraHost.getHost(), this.cassandraHost.getPort(), this.timeout);
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            log.error("Unable to open transport to " + this.cassandraHost.getName(), (Throwable)e);
            throw new HectorTransportException("Unable to open transport to " + this.cassandraHost.getName() + " , " + e.getLocalizedMessage(), e);
        }
        return this;
    }

    boolean isOpen() {
        boolean open = false;
        if (this.transport != null) {
            open = this.transport.isOpen();
        }
        if (log.isDebugEnabled()) {
            log.debug("Transport open status {} for client {}", (Object)open, (Object)this);
        }
        return open;
    }

    private int getTimeout(CassandraHost cassandraHost) {
        int timeoutVar = 0;
        if (cassandraHost != null && cassandraHost.getCassandraThriftSocketTimeout() > 0) {
            timeoutVar = cassandraHost.getCassandraThriftSocketTimeout();
        } else {
            String timeoutStr = System.getProperty(SystemProperties.CASSANDRA_THRIFT_SOCKET_TIMEOUT.toString());
            if (timeoutStr != null && timeoutStr.length() > 0) {
                try {
                    timeoutVar = Integer.valueOf(timeoutStr);
                }
                catch (NumberFormatException e) {
                    log.error("Invalid value for CASSANDRA_THRIFT_SOCKET_TIMEOUT", (Throwable)e);
                }
            }
        }
        return timeoutVar;
    }

    public String toString() {
        return String.format(NAME_FORMAT, this.cassandraHost.getUrl(), this.mySerial);
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

