/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import org.apache.cassandra.thrift.Column;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class HColumnImpl<N, V>
implements HColumn<N, V> {
    private N name;
    private V value;
    private long clock;
    private int ttl;
    private Serializer<N> nameSerializer;
    private Serializer<V> valueSerializer;

    public HColumnImpl(N name, V value, long clock, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this(nameSerializer, valueSerializer);
        Assert.notNull(name, "name is null");
        Assert.notNull(value, "value is null");
        this.name = name;
        this.value = value;
        this.clock = clock;
    }

    public HColumnImpl(Column thriftColumn, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this(nameSerializer, valueSerializer);
        Assert.notNull(thriftColumn, "thriftColumn is null");
        this.name = nameSerializer.fromByteBuffer(ByteBuffer.wrap(thriftColumn.getName()));
        this.value = valueSerializer.fromByteBuffer(ByteBuffer.wrap(thriftColumn.getValue()));
        this.clock = thriftColumn.timestamp;
    }

    public HColumnImpl(Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.notNull(nameSerializer, "nameSerializer is null");
        Assert.notNull(valueSerializer, "valueSerializer is null");
        this.nameSerializer = nameSerializer;
        this.valueSerializer = valueSerializer;
    }

    public HColumnImpl(N name, V value, long clock) {
        this(name, value, clock, SerializerTypeInferer.getSerializer(name), SerializerTypeInferer.getSerializer(value));
    }

    @Override
    public HColumn<N, V> setName(N name) {
        Assert.notNull(name, "name is null");
        this.name = name;
        return this;
    }

    @Override
    public HColumn<N, V> setValue(V value) {
        Assert.notNull(value, "value is null");
        this.value = value;
        return this;
    }

    @Override
    public HColumn<N, V> setClock(long clock) {
        this.clock = clock;
        return this;
    }

    @Override
    public HColumn<N, V> setTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public N getName() {
        return this.name;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public long getClock() {
        return this.clock;
    }

    public Column toThrift() {
        return this.ttl > 0 ? new Column(this.nameSerializer.toByteBuffer(this.name), this.valueSerializer.toByteBuffer(this.value), this.clock).setTtl(this.ttl) : new Column(this.nameSerializer.toByteBuffer(this.name), this.valueSerializer.toByteBuffer(this.value), this.clock);
    }

    public HColumn<N, V> fromThrift(Column c) {
        Assert.notNull(c, "column is null");
        this.name = this.nameSerializer.fromByteBuffer(c.name);
        this.value = this.valueSerializer.fromByteBuffer(c.value);
        this.clock = c.timestamp;
        this.ttl = c.ttl;
        return this;
    }

    @Override
    public Serializer<N> getNameSerializer() {
        return this.nameSerializer;
    }

    @Override
    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public String toString() {
        return "HColumn(" + this.name + "=" + this.value + ")";
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.name).append(this.value).append(this.clock).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HColumnImpl other = (HColumnImpl)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.name, other.name).append(this.value, other.value).append(this.clock, other.clock).isEquals();
    }
}

