/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.prettyprint.cassandra.model.HColumnImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.HSuperColumn;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.SuperColumn;

public final class HSuperColumnImpl<SN, N, V>
implements HSuperColumn<SN, N, V> {
    private SN superName;
    private List<? extends HColumn<N, V>> columns;
    private long clock;
    private final Serializer<SN> superNameSerializer;
    private final Serializer<N> nameSerializer;
    private final Serializer<V> valueSerializer;

    public HSuperColumnImpl(SN sName, List<HColumn<N, V>> columns, long clock, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this(sNameSerializer, nameSerializer, valueSerializer);
        Assert.notNull(sName, "Name is null");
        Assert.notNull(columns, "Columns are null");
        this.superName = sName;
        this.columns = columns;
        this.clock = clock;
    }

    public HSuperColumnImpl(SuperColumn thriftSuperColumn, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        this(sNameSerializer, nameSerializer, valueSerializer);
        Assert.noneNull(thriftSuperColumn, sNameSerializer, nameSerializer, valueSerializer);
        this.superName = sNameSerializer.fromByteBuffer(ByteBuffer.wrap(thriftSuperColumn.getName()));
        this.columns = super.fromThriftColumns(thriftSuperColumn.getColumns());
    }

    HSuperColumnImpl(Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(sNameSerializer, nameSerializer, valueSerializer);
        this.superNameSerializer = sNameSerializer;
        this.nameSerializer = nameSerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public HSuperColumn<SN, N, V> setName(SN name) {
        Assert.notNull(name, "name is null");
        this.superName = name;
        return this;
    }

    @Override
    public HSuperColumn<SN, N, V> setSubcolumns(List<HColumn<N, V>> subcolumns) {
        Assert.notNull(subcolumns, "subcolumns are null");
        this.columns = subcolumns;
        return this;
    }

    @Override
    public HSuperColumn<SN, N, V> setClock(long clock) {
        this.clock = clock;
        return this;
    }

    @Override
    public long getClock() {
        return this.clock;
    }

    @Override
    public int getSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Override
    public SN getName() {
        return this.superName;
    }

    @Override
    public List<HColumn<N, V>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public HColumn<N, V> get(int i) {
        return this.columns.get(i);
    }

    @Override
    public Serializer<SN> getNameSerializer() {
        return this.superNameSerializer;
    }

    @Override
    public byte[] getNameBytes() {
        return this.superNameSerializer.toByteBuffer(this.getName()).array();
    }

    @Override
    public ByteBuffer getNameByteBuffer() {
        return this.superNameSerializer.toByteBuffer(this.getName());
    }

    public SuperColumn toThrift() {
        if (this.superName == null || this.columns == null) {
            return null;
        }
        return new SuperColumn(this.superNameSerializer.toByteBuffer(this.superName), this.toThriftColumn());
    }

    private List<Column> toThriftColumn() {
        ArrayList<Column> ret = new ArrayList<Column>(this.columns.size());
        for (HColumn<N, V> c : this.columns) {
            ret.add(((HColumnImpl)c).toThrift());
        }
        return ret;
    }

    private List<HColumn<N, V>> fromThriftColumns(List<Column> tcolumns) {
        ArrayList<HColumn<N, V>> cs = new ArrayList<HColumn<N, V>>(tcolumns.size());
        for (Column c : tcolumns) {
            cs.add(new HColumnImpl<N, V>(c, this.nameSerializer, this.valueSerializer));
        }
        return cs;
    }

    @Override
    public Serializer<SN> getSuperNameSerializer() {
        return this.superNameSerializer;
    }

    @Override
    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public String toString() {
        return String.format("HSuperColumn(%s,%s)", this.superName, this.columns);
    }
}

