/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.AbstractSerializer;

public final class IntegerSerializer
extends AbstractSerializer<Integer> {
    private static final IntegerSerializer instance = new IntegerSerializer();

    public static IntegerSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Integer obj) {
        if (obj == null) {
            return null;
        }
        int l = obj;
        int size = 4;
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = (byte)(l >> (size - i - 1 << 3));
        }
        return ByteBuffer.wrap(b);
    }

    @Override
    public Integer fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        int in = 0;
        int size = byteBuffer.capacity();
        for (int i = 0; i < size; ++i) {
            in |= (byteBuffer.get(i) & 0xFF) << (size - i - 1 << 3);
        }
        return in;
    }
}

