/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SuperColumn;

public final class BatchMutation<K> {
    private final Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap;
    private final Serializer<K> keySerializer;

    public BatchMutation(Serializer<K> serializer) {
        this.keySerializer = serializer;
        this.mutationMap = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
    }

    private BatchMutation(Serializer<K> serializer, Map<ByteBuffer, Map<String, List<Mutation>>> mutationMap) {
        this.keySerializer = serializer;
        this.mutationMap = mutationMap;
    }

    public BatchMutation<K> addInsertion(K key, List<String> columnFamilies, Column column) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setColumn(column));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation<K> addSuperInsertion(K key, List<String> columnFamilies, SuperColumn superColumn) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setSuper_column(superColumn));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation<K> addDeletion(K key, List<String> columnFamilies, Deletion deletion) {
        Mutation mutation = new Mutation();
        mutation.setDeletion(deletion);
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    private void addMutation(K key, List<String> columnFamilies, Mutation mutation) {
        Map<String, List<Mutation>> innerMutationMap = this.getInnerMutationMap(key);
        for (String columnFamily : columnFamilies) {
            if (innerMutationMap.get(columnFamily) == null) {
                innerMutationMap.put(columnFamily, Arrays.asList(mutation));
                continue;
            }
            ArrayList<Mutation> mutations = new ArrayList<Mutation>((Collection)innerMutationMap.get(columnFamily));
            mutations.add(mutation);
            innerMutationMap.put(columnFamily, mutations);
        }
        this.mutationMap.put(this.keySerializer.toByteBuffer(key), innerMutationMap);
    }

    private Map<String, List<Mutation>> getInnerMutationMap(K key) {
        Map<String, List<Mutation>> innerMutationMap = this.mutationMap.get(this.keySerializer.toByteBuffer(key));
        if (innerMutationMap == null) {
            innerMutationMap = new HashMap<String, List<Mutation>>();
        }
        return innerMutationMap;
    }

    Map<ByteBuffer, Map<String, List<Mutation>>> getMutationMap() {
        return this.mutationMap;
    }

    public BatchMutation<K> makeCopy() {
        return new BatchMutation<K>(this.keySerializer, this.mutationMap);
    }

    public boolean isEmpty() {
        return this.mutationMap.isEmpty();
    }
}

