/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Collections;
import java.util.Map;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;

public abstract class Operation<T> {
    private static final Map<String, String> EMPTY_CREDENTIALS = Collections.emptyMap();
    public final CassandraClientMonitor.Counter failCounter;
    public final String stopWatchTagName;
    public final FailoverPolicy failoverPolicy;
    public final String keyspaceName;
    public final Map<String, String> credentials;
    protected T result;
    private HectorException exception;
    private CassandraHost cassandraHost;

    public Operation(OperationType operationType) {
        this(operationType, EMPTY_CREDENTIALS);
    }

    public Operation(OperationType operationType, Map<String, String> credentials) {
        this.failCounter = operationType.equals((Object)OperationType.READ) ? CassandraClientMonitor.Counter.READ_FAIL : CassandraClientMonitor.Counter.WRITE_FAIL;
        this.stopWatchTagName = operationType.name();
        this.failoverPolicy = FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE;
        this.keyspaceName = null;
        this.credentials = Collections.unmodifiableMap(credentials);
    }

    public Operation(OperationType operationType, FailoverPolicy failoverPolicy, String keyspaceName) {
        this(operationType, failoverPolicy, keyspaceName, EMPTY_CREDENTIALS);
    }

    public Operation(OperationType operationType, FailoverPolicy failoverPolicy, String keyspaceName, Map<String, String> credentials) {
        this.failCounter = operationType.equals((Object)OperationType.READ) ? CassandraClientMonitor.Counter.READ_FAIL : CassandraClientMonitor.Counter.WRITE_FAIL;
        this.stopWatchTagName = operationType.name();
        this.failoverPolicy = failoverPolicy;
        this.keyspaceName = keyspaceName;
        this.credentials = Collections.unmodifiableMap(credentials);
    }

    public void setResult(T executionResult) {
        this.result = executionResult;
    }

    public T getResult() {
        return this.result;
    }

    public abstract T execute(Cassandra.Client var1) throws HectorException;

    public void executeAndSetResult(Cassandra.Client cassandra, CassandraHost cassandraHost) throws HectorException {
        this.cassandraHost = cassandraHost;
        this.setResult(this.execute(cassandra));
    }

    public void setException(HectorException e) {
        this.exception = e;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public HectorException getException() {
        return this.exception;
    }

    public CassandraHost getCassandraHost() {
        return this.cassandraHost;
    }
}

